#ifndef _STATTEXT_H_INCLUDED_
#define _STATTEXT_H_INCLUDED_
/*
  object t_stattext is used drawing formated text and placed it to the other object.
*/
typedef struct t_stattext *p_stattext;

typedef struct t_stattext {

  /* inherited functions / variabes from t_view and t_object objects */
  struct t_view  obclass;

  /* formated text */
  l_char         text[1024];

  /* alignment. use values TX_ALIGN_XXXX. */
  l_int          align;

  l_color        color_text;

  void           (*set_text) ( p_stattext o, l_text text, ... );

} t_stattext;

#define STATTEXT(o) ((p_stattext)(o))

p_stattext _stattext_init_ex ( p_stattext o, t_rect r, l_int align, l_text text, va_list argp );
p_stattext _stattext_init ( p_stattext o, t_rect r, l_int align, l_text format, ... );
extern p_stattext (*stattext_init_ex) ( p_stattext o, t_rect r, l_int align, l_text text, va_list argp );
extern p_stattext (*stattext_init) ( p_stattext o, t_rect r, l_int align, l_text format, ... );

void  stattext_draw ( p_view o );
void  stattext_set_text ( p_stattext o, l_text text, ... );

#endif
