#ifndef _SEAL_SAFE_TIMER_H_
#define _SEAL_SAFE_TIMER_H_

typedef struct t_timer_def *p_timer_def;

typedef struct t_timer_def {

  l_int   active; /* flag if the timer is active */

  void    (*stop) (); /* stop the timer */
  void    (*reload) (); /* reload timer */

  l_char  reserved[24];

  p_timer_def next;

} t_timer_def;

extern p_timer_def safe_timers;

/* safe timer */
void  safe_timer ( void (*stop)(), void (*reload)() );
/* erase previous saved timer */
void  erase_safe_timer ( void (*stop)() );
/* erase all saved timers */
void safe_timer_free_all ( void );
/* reload timers */
void safe_timer_reload ( void );
/* stop timers */
void safe_timer_halt ( void );

#endif
