/*
  This file is a part of SEAL

  (c) Copyright 2001 Sealsystem / Point Mad. All rights reserved.

  Seal is under the Sealsystem license. Please read
    license.txt in the main directory for more informations.

  For more informations about copyrights, read about.txt
    in the main directory.

*/

#include"lnk.h"

l_bool lnk_is_link ( l_text file ) {
  if ( !file ) return false;
  return !stricmp(get_extension(file), "LN");
};

l_text lnk_nice_link ( l_text file ) {
  if ( !file ) return NULL;
  if ( lnk_is_link(file) ) return stridup(file, strlen(file)-3);
  return _strdup(file);
};

BITMAP *lnk_get_link_icon ( l_text file, l_int size, l_bool *ownmem ) {
  if ( file ) {
    l_text icon = getini_fromfile(file,"definition",(size<32)?"icon16":"icon32");
    if ( icon ) {
      if ( icon[0] == '&' ) {
        return GETBMP(icon+1);
      } else {
        BITMAP* bmp = load_image(icon);
        conv_to_skipcolor_bitmap(bmp,255,0,255);
        return bmp;
      };
    };
  };
  return NULL;
};

l_text lnk_get_link ( l_text file ) {
  if ( file ) return getini_fromfile(file,"definition","link");
  return NULL;
};

l_int lnk_run_link ( l_text file, l_text args ) {
  if ( file ) {
    l_text rfile = lnk_get_link(file);
    if ( rfile ) {
      return run_file_args ( rfile, args);
    };
  };
  return 0;
};
