/*
  This file is a part of SEAL

  (c) Copyright 2001 Sealsystem / Point Mad. All rights reserved.
  (c) Copyright 1999-2000 Michal Stencl. All rights reserved.

  Seal is under the Sealsystem license. Please read
    license.txt in the main directory for more informations.

  For more informations about copyrights, read about.txt
    in the main directory.

*/


#ifdef  __DEBUG_MEMORY__
#define MSS
#include"mss.h"
#endif
#include"safmem.h"

void     tag_strcpy ( void *dst, void *src, l_int size )
{
  if ( dst ) {
     clear_type(dst, size);
     if ( src ) strncpy(dst, src, size-1);
  };
};

l_int   tag_stricmp ( void *dst, void *src )
{
  if ( dst && src ) return stricmp(dst, src);
  return 1;
};

/* safe malloc */
void   sf_alert ( void )
{
     seal_error(ERR_INFO, "%s.\n\n%s", TXT_NOTENOUGHMEMEMORYFOROPERATION, TXT_PLEASESTOREYOURDATAANDEXITSOMEAPPLICATION);
};

void  *sf_malloc ( size_t size )
{
void *p = malloc(size);
return p;
};
void  sf_free ( void *rec )
{
  if (rec) free(rec);
};
#ifdef __RSXNT__
#define cfree(rec) free(rec)
#endif
void  sf_cfree ( void *rec )
{
  if (rec) cfree(rec);
};
void  *sf_calloc ( size_t num_elements, size_t size )
{
   return calloc(num_elements, size);
};
char  *sf_strdup ( const char *source )
{
 return source?strdup(source):NULL;
};
void   *sf_realloc ( void *rec, size_t size )
{
 return rec?realloc(rec, size):sf_malloc(size);
};


