/*

    (c) Copyright 2001 Point Mad, Seal System. All rights reserved.

    Please read about.txt for copyrights details.
    And read license for license agreements.

*/

#include"stimer.h"

p_timer_def safe_timers;

void  safe_timer ( void (*stop)(), void (*reload)() )
{
   p_timer_def x = safe_timers;
   /* search for timer */
   while ( x && (x->stop != stop) ) x = x->next;
   if ( !x ) { /* not found, so insert */
       p_timer_def x = (p_timer_def)_malloc(sizeof(t_timer_def));
       if ( x ) /* enough memory */
          clear_type(x, sizeof(t_timer_def)); /* all to ZERO */
          x->stop = stop;
          x->reload = reload;
          x->active = 1;
          x->next = safe_timers;
          safe_timers = x;
   };
};


/* erase previous saved timer */
void  erase_safe_timer ( void (*stop)() )
{
   p_timer_def x = safe_timers;
   p_timer_def last = NULL;
   /* search for timer */
   while ( x ) {
      p_timer_def s = x->next;
      if ( !last ) { /* first item */
         safe_timers = x->next;
         _free(x);
         return;
      } else { /*  */
          last->next = x->next;
          _free(x);
          return;
      };
      last = x;
      x = s;
   };
};


void safe_timer_halt ( void )
{
   p_timer_def x = safe_timers;
   /* for all timers */
   while ( x ) {
      /* it's able to stop it */
      if ( x->active ) {
            x->stop(); /* stop timer */
            x->active = 0; /* set to passive timer */
      };
      /* go to the next one */
      x = x->next;
   };
};


void safe_timer_reload ( void )
{
   p_timer_def x = safe_timers;
   /* for all timers */
   while ( x ) {
      /* it's able to reload it */
      if ( !x->active ) {
            x->reload(); /* stop timer */
            x->active = 1; /* set to passive timer */
      };
      /* go to the next one */
      x = x->next;
   };
};


void safe_timer_free_all ( void )
{
   p_timer_def x = safe_timers;
   /* for all timers */
   while ( x ) {
      p_timer_def n = x->next;
      /* free memory */
      _free(x);
      /* go to the next one */
      x = n;
   };
   safe_timers = NULL;
};

