#include <errno.h>
#include <cv/convert.h>

//=========================================================
bool FAST_ fileref(CStr arg){
	count len = checklen(arg);
	return bool(len - memcspan(arg, len, '!'));
}

//=========================================================
const struct { int code; PCStr desc; } errlist[] = {
/* 2*/ { ENOFILE, "No such file" },
/* 3*/ { ENOPATH, "Invalid path" },
/* 4*/ { EMFILE,  "Too many open files" },
/* 5*/ { EACCES,  "Access denied" },
/* 8*/ { ENOMEM,  "Insufficient memory" },
/*15*/ { EINVDRV, "Invalid drive" },
/*19*/ { EINVAL,  "Bad argument" },
/*35*/ { EEXIST,  "Already exists" }};

void sayerror(CStr when, CVP what, size_t whatsz){
	int errcode = _doserrno;
	if((errcode == 0 || errcode == -1) && errno) errcode = errno;
	for(count i = 0; i < arraySize(errlist); i++){
		if(errlist[i].code == errcode){
			say(errlist[i].desc); errcode = 0; break;
	}	}
	if(errcode) { say("Unusual error #"); say(errcode); }
	if(when) { say(" ("); say(when); say(")"); }
	if(whatsz) { say(" \""); say(what, whatsz); say("\""); }
	say("\n");
}

void FAST_ sayerror(CStr when, CStr what){
	sayerror(when, what, checklen(what));
}
