; FRM.COM v0.0pre3 -
;    A tiny ASM app to initialize the undocumented x86 addressing

; Copyright (C) 1999 by Louis P. Santillan
;    Parts taken from bootsector code of Jeff Weeks, John Fine, and
;    Flat Real Mode demonstration code of ASM Gems and Robert Collins
;    (rcollins@x86.org).  HelpPC 2.11 & TechView 6.0 were also used
;    as references

; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to

; the Free Software Foundation, Inc.
; 59 Temple Place
; Suite 330
; Boston, MA  02111-1307
; USA

; ***NOTE***
; This code requires FRM-Lib to build which should be available at the
;    same place where you got this file

[BITS 16]
[ORG 0x100]

;---------------------- frm.com's macro -----------------------
; a tiny macro to make code a little bit clearer
%macro disp 1
   MOV SI, %1
   CALL _puts
%endmacro
;---------------------- frm.com's macro -----------------------

;---------------------------------------------------------------
; Program entry
_main:
   ; Display program info
   disp( introMessage )

   ; Tell user we are going to check for a 386+ CPU
   disp( check386plus )

   ; Make sure we have a 386+ CPU
   CALL _detect386

   ; Did the test verify existence of a 386+ CPU
   CMP AX, is386plus

   ; No 386+ CPU...jump to error message display
   JNE mainNo386plus

      ; Otherwise...display a check mark
      disp( checked )

      ; Display positive screen message
      ;disp( found386plus )

      ; Tell user we are gonna check to make sure we can enter FRM
      disp( checkingCR0 )

      ; Detect PE bit status
      CALL _detectCR0

      ; Was the PE bit set?
      CMP AX, isPEbitSet

      ; If either of the bits are set...jump to error message display
      JE mainPEBitSet

         ; Display check mark
         disp( unChecked )

         ; Tell user that bits were not set
         ;disp( isNotSetPEbit )

         ; Tell user we are going to enable the A20 line
         disp( enableA20String )

         ; Enable the A20 line
         CALL _enableA20

         ; Display check mark
         disp( checked )

         ; Tell user that the A20 line has been set
         ;disp( A20EnabledString )

         ; Tell user that FRM is about to be initialized
         disp( initializingFRMString )

         ; Initialize FRM
         CALL _initFRM

         ; Display check mark
         disp( checked )

         ; Tell use that FRM has been initialized
         ;disp( FRMInitializedString )

         ; Set the DOS exit/error code
         MOV AX, NoErrorReturnCode

         ; Jump to program exit point
         JMP mainEnd

   ; We come here if there was no 386+ CPU found
   mainNo386plus:

      ; Display an empty box
      disp( unChecked )

      ; Display 386+ CPU missing error message
      disp( missing386plus )

      ; Set the DOS exit/error code
      MOV AX, No386PlusErrorReturnCode

      ; Jump to program exit point
      JMP mainEnd

   ; We come here if the PE or PG bits were set in CR0
   mainPEBitSet:

      ; Display a check mark
      disp( checked )

      ; Tell user about the error
      disp( isSetPEbit )

      ; Set the DOS exit/error code
      MOV AX, PEBitSetErrorReturnCode

   mainEnd:

   MOV AH, DOS_OS_RETURN_FUNC
   INT DOS_INT

;---------------------- frm.com's defines ----------------------
NoErrorReturnCode EQU 0

No386PlusErrorReturnCode EQU 1

PEBitSetErrorReturnCode EQU 2

DOS_INT EQU 0x21

DOS_OS_RETURN_FUNC EQU 0x4C
;---------------------- frm.com's defines ----------------------

;---------------------- frm.com's includes ---------------------
%include "frm-lib.asm"

%include "output.asm"
