
;                                                                           ;
;                       ATTRIB.S  v1.09b  01-01-2001                        ;
;                     Copyright 1997-2001, Charles Dye                      ;
;                       email:  raster@highfiber.com                        ;
;                                                                           ;
;       This is source for NASM, the Netwide Assembler.  Type               ;
;       NASM ATTRIB.S -O ATTRIB.COM  to re-assemble.  NASM is               ;
;       freeware, available from  http://www.cryogen.com/Nasm               ;
;                                                                           ;
;       This program is copyrighted, but may be freely distributed          ;
;       under the terms of the Free Software Foundation's GNU General       ;
;       Public License v2 (or later.)  See the file COPYING for the         ;
;       legalities.  If you did not receive a copy of COPYING, you          ;
;       may request one from the Free Software Foundation, Inc.,            ;
;       59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           ;
;       ABSOLUTELY NO WARRANTY -- use it at your own risk!                  ;
;                                                                           ;


%macro doscall 1                       ; call to dos int 21 with a one-byte
%if %1 >= 0100h                        ; value in .ah, or a two-byte value
mov ax,%1                              ; in .ax :
%else
mov ah,%1
%endif
int 21h
%endmacro

%macro dosprint 1                      ; a simple wrapper for the dos 21/09
mov dx,%1                              ; print-a-string function
mov ah,09h
int 21h
%endmacro

%macro zero 1                          ; cheap way to zero a two-byte
xor %1,%1                              ; register
%endmacro

%macro testzero 1                      ; test 16-bit register against zero
or %1,%1
%endmacro

%macro zprint 1                        ; a wrapper for a call to my asciiz-
mov di,%1                              ; print routine
call zprint1
%endmacro

%macro bomb 2                          ; jump to handler for fatal errors
call bombs_away                        ; ... does not return!
dw %1                                  ; inline:  address of error message
db %2                                  ; inline:  exit code (errorlevel)
%endmacro

%define hilo(a,b) (a * 100h + b)       ; easy way to code two-byte quantities


%define Enable_Display                 ; support for switches /b /n and /v
%define Enable_Paging                  ; support for pausing and switch /m
%define Enable_A_Mask                  ; support for switch /a
%define Enable_Comma                   ; support for undocumented comma thing
%define Enable_Equals                  ; support for = operator
%define Enable_Lists                   ; support for dr-dos style file lists
%define Enable_Environment             ; support for switches in environment
%define Enable_Markver                 ; embedded version, copyright strings


org 0100h

country  equ  005ch                    ; put country data in the psp
country_date equ country + 00h         ; local date format, usa-eur-japan
country_thou equ country + 07h         ; local thousands char (',' in usa)
country_dsep equ country + 0bh         ; local date separator ('-' in usa)
country_tsep equ country + 0dh         ; local time separator (':' in usa)
country_time equ country + 11h         ; local time format (0 12hr, 1 24hr)

temp         equ  006eh                ; local temp variable (byte or word)
a_altered    equ  0070h                ; new attributes for file
dp_t4        equ  0071h                ; dec print routine - chars pushed
date1        equ  0072h                ; year value for julian calculation
date2        equ  0074h                ; month value
date3        equ  0076h                ; date value
dp_t1        equ  0078h                ; low  word for decimal print routine
dp_t2        equ  007ah                ; high word for decimal print routine

fn_max       equ  0104h                ; max number of characters in filename

attr_r       equ  01h                  ; value of read-only attribute
attr_h       equ  02h                  ; value of hidden attribute
attr_s       equ  04h                  ; value of system attribute
attr_v       equ  08h                  ; value of volume-label attribute
attr_d       equ  10h                  ; value of directory attribute
attr_a       equ  20h                  ; value of archive attribute
attr_c       equ  40h                  ; attribute bit for character devices
attr_user    equ  27h                  ; user-changeable attributes

SPC          equ  20h                  ; ascii space
BS           equ  08h                  ; ascii backspace
CR           equ  0dh                  ; ascii carriage return
LF           equ  0ah                  ; ascii line feed
EOF          equ  1ah                  ; ascii end of file


; -------------------------------------- START OF CODE:

begin:
cld
doscall 3000h                          ; check ms-dos version:
cmp al,02h
ja dos_okay
bomb msg_err_dos_bad,17h               ; complain and exit with errorlevel 23
dos_okay:
cmp bh,0fdh                            ; running under freedos?
jne not_freedos                        ; if not, never mind
jcxz freedos_fix
cmp cx,byte -01h                       ; early beta dos-c kernel?
jne not_freedos
freedos_fix:                           ; if so, fix attributes mask
or word [mask_4301],byte attr_d        ; so subdir bit is passed to 21/4301
not_freedos:
mov ax,sp                              ; examine stack pointer:
cmp ax,stack_end                       ; plenty of room?
jae enough_room
trs_80:                                ; not enough memory:
bomb msg_trs_80,11h                    ; complain and exit with errorlevel 17
enough_room:
mov sp,stack_end                       ; reduce stack size
push cs
pop es
mov bx,(stack_end / 10h) + 2h
doscall 4ah                            ; and shrink program's memory block
jc trs_80

call get_country_info                  ; get current country info
mov dx,dta
doscall 1ah                            ; set up disk transfer area
%ifdef Enable_Paging
call get_vga_lines                     ; figure default scroll length
%endif ; Enable_Paging
mov byte [last_dir_shown],00           ; note directory name not displayed
%ifdef Enable_Environment
call check_envars                      ; look for any environment variables
%else  ; Enable_Environment
mov si,0080h
%endif ; Enable_Environment

parse_main:                            ; PRIMARY PARSER LOOP:
inc si
switch_done:
mov al,byte [si]                       ; examine next character
call force_uc                          ; in uppercase:
call test_eol                          ; end of line?
je parse_done                          ; if so, terminate primary parser
call test_space                        ; is it a space?
je parse_main                          ; if so, ignore it
cmp al,'/'                             ; is it a switch character?
je found_switch                        ; if so, interpret it
call test_op                           ; is it an operator?  (+ - or ~)
je found_op                            ; if so, go handle it
%ifdef Enable_Equals
cmp al,'='                             ; is it an equals sign?
je found_eq                            ; if so, go handle it
%endif ; Enable_Equals
%ifdef Enable_Comma
cmp al,','
je found_comma                         ; microsoft undocumented feature
%endif ; Enable_Comma
%ifdef Enable_Environment
cmp si,stack_start                     ; parsing from the environment?
jae .l2                                ; if so, ignore filespec
%endif ; Enable_Environment
mov bx,[pointer_pointer]               ; otherwise, this is the start of a
mov [filespec_pointers+bx],si          ; filespec; remember it
inc bx
inc bx
mov [pointer_pointer],bx               ; save pointer to start of filespec
cmp bx,byte 0040h                      ; too many filespecs?
jb .l2                                 ; if so,
bomb msg_err_specs_galore,10h          ; complain and exit with errorlevel 16
.l2:
call parse_fn                          ; parse through the filespec
mov al,[si]
call test_eol                          ; if the end of the line was found,
je parse_done                          ; terminate primary parser
jmp short parse_main                   ; otherwise, keep on truckin'

found_op:                              ; plus, minus, tilde operator :
jmp handle_operator                    ; jump to handler

%ifdef Enable_Equals
found_eq:                              ; equals operator :
jmp handle_equals                      ; jump to handler
%endif ; Enable_Equals

%ifdef Enable_Comma
found_comma:                           ; comma operator :
jmp handle_comma                       ; jump to handler
%endif ; Enable_Comma

found_switch:                          ; FOUND A SWITCH CHARACTER:
inc si
lodsb                                  ; examine next character
call force_uc                          ; in uppercase:
mov bx,0ffffh                          ; start at beginning of switch table
.l0:
inc bx
cmp byte [switches+bx],00h             ; run out of legal switches to try?
je syntax                              ; if so, syntax error
cmp [switches+bx],al                   ; found this letter in table?
jne .l0                                ; if not, keep looking
shl bx,01h                             ; multiply .bx by two
mov ax,[switch_routines+bx]            ; and get address of switch routine
jmp ax                                 ; to jump to

syntax:                                ; SYNTAX ERROR IN COMMAND LINE:
call error_out
switch_syn:
dosprint msg_syntax                    ; print error message
doscall 4c10h                          ; and exit with errorlevel 16

parse_done:                            ; DONE WITH PRIMARY PARSER:
%ifdef Enable_Environment
cmp si,stack_start
jb .l0
mov si,0080h
jmp parse_main
%endif ; Enable_Environment
.l0:
mov bx,[pointer_pointer]
or bx,bx                               ; found any filespecs at all?
jne .l1
mov ax,star_dot_star
mov [filespec_pointers],ax             ; if not, slip in a star-dot-star-cr
inc bx
inc bx
.l1:
zero ax
mov [filespec_pointers+bx],ax          ; add a null to end of list
mov [pointer_pointer],ax               ; and point to the start of the list
%ifdef Enable_A_Mask
test byte [mask_val],attr_d
je .l2                                 ; if /a:d was specified,
or byte [flags],fb_swd                 ; invoke /d automagically
.l2:
%endif ; Enable_A_Mask

call hook_int_24                       ; disable critical-error handling
call alloc_tree_buffer                 ; create buffer for /s tree if needed
%ifdef Enable_Lists
call alloc_list_buffer                 ; get buffer for file list
%endif ; Enable_Lists
call template_fix                      ; transfer template bits to chgattr
call prompt_fix                        ; check usage of /p
call fix_paging                        ; disable paging if output redirected

big_loop:                              ; LOOP THROUGH COMMAND-LINE FILESPECS:
mov bx,[pointer_pointer]
mov ax,[filespec_pointers+bx]          ; get offset of command-line filespec
or ax,ax                               ; have we run out yet?
je big_loop_done                       ; if so, exit
add word [pointer_pointer],byte 02h    ; otherwise, point to next filespec
mov si,ax
call parse_fn                          ; and parse this one
call clean_up_filespec                 ; canonicalize it

filespec_loop:
%ifdef Enable_Lists
call get_fn_from_list                  ; read filespec from list, if needed
jc big_loop                            ; if eof, back for next user filespec
%endif ; Enable_Lists
subdir_loop:
call alter_multiple_files              ; alter files matching this filespec
call find_any_subdirs                  ; add any subdirectories to tree buff.
call use_next_subdir                   ; is there a subdirectory in buffer?
jnc subdir_loop                        ; if so, alter any files in it
%ifdef Enable_Lists
test byte [flags],fb_list              ; using a file list?
jne filespec_loop                      ; if so, get next filespec from it
%endif ; Enable_Lists
jmp short big_loop

big_loop_done:                         ; done with all user filespecs:
call show_file_count
call show_total_counts                 ; display num. of files found, changed
doscall 4c00h                          ; exit with errorlevel 0

parse_tfn:                             ; READ TEMPLATE FILENAME:
mov word [tfn_attr],0016h              ; directories are okay, hidden, etc.
and byte [flags],fb_quote ^ 0ffh       ; turn off quote mode
%ifdef Enable_Lists
or byte [flags],fb_list                ; turn on at-mode
%endif ; Enable_Lists
mov di,tfbuf                           ; point to template filename buffer
jmp short parse_fn_0

parse_fn:                              ; READ FILESPEC FROM COMMAND LINE:
and byte [flags],(fb_quote | fb_list) ^ 0ffh   ; turn off quote-mode, at-mode
mov di,fnbuf                           ; point to filespec buffer
parse_fn_0:
zero cx                                ; no characters yet
mov [di],cl                            ; empty the buffer

parse_fn_1:                            ; parse filename loop:
lodsb                                  ; get a character from command line
call force_uc                          ; and force it to uppercase
cmp al,'?'
je .l0                                 ; found a wildcard in the filespec?
cmp al,'*'
jne .l1                                ; if not, never mind
.l0:
and byte [tfn_attr],attr_d ^ 0ffh      ; if so, disallow subdirectories
.l1:
call test_eol                          ; end of line?
je parse_fn_eol                        ; if so, handle it
call test_space                        ; space or tab?
je parse_fn_space                      ; if so, handle it
cmp al,'"'                             ; quote mark?
je parse_fn_quote                      ; if so, handle it
cmp al,'/'                             ; forward slash?
jne .l2
mov al,'\'                             ; if so, convert to backslash
.l2:
%ifdef Enable_Lists
cmp al,'@'                             ; at sign?
jne parse_fn_char                      ; no, treat like a normal character
testzero cx                            ; yes:  got any characters yet?
jne parse_fn_char                      ; yes:  at sign is part of filename
test byte [flags],fb_quote | fb_list   ; quote-mode or at-mode?  if either,
jne parse_fn_char                      ; at sign is part of filename
or byte [flags],fb_list                ; note:  file list
jmp short parse_fn_1                   ; continue parsing
%endif ; Enable_Lists

parse_fn_char:                         ; NORMAL CHARACTER IN FILENAME:
mov ah,00h
mov [di],ax                            ; stash it, and null-terminate buffer
inc di
inc cx                                 ; increment count of characters
cmp cx,fn_max                          ; buffer overflow?
jb parse_fn_1                          ; if not, continue parsing
bomb msg_err_fn_ovf,10h                ; complain and exit with errorlevel 16

parse_fn_eol:                          ; FOUND THE END OF COMMAND LINE:
testzero cx                            ; found a filename yet?
jne .l0                                ; if not,
bomb msg_err_in_filespec,10h           ; complain and exit with errorlevel 16
.l0:
dec si                                 ; let the primary parser see it
ret                                    ; and we're done parsing the filespec

parse_fn_space:                        ; FOUND A SPACE IN THE FILESPEC:
test byte [flags],fb_quote             ; parsing between quotes?
jne parse_fn_char                      ; if so, treat like any other char
testzero cx                            ; any characters in filespec yet?
jne .l1                                ; if not,
bomb msg_err_in_filespec,10h           ; complain and exit with errorlevel 16
.l1:
dec si                                 ; if so, we're done parsing filespec
.quit:
ret

parse_fn_quote:                        ; found a quote mark:
test byte [flags],fb_quote             ; has an opening quote been found?
jne parse_close_quote                  ; if so, this is a close quote
testzero cx                            ; is the filename empty?
jne parse_fn_char                      ; if not, quote is part of filename
or byte [flags],fb_quote               ; note that open quote was found
jmp parse_fn_1                         ; and continue parsing
parse_close_quote:
testzero cx                            ; empty filename?
jne parse_fn_space.quit                ; if so,
bomb msg_err_in_filespec,10h           ; complain and exit with errorlevel 16


alter_multiple_files:                  ; ALTER FILES MATCHING CURRENT SPEC:
call append_short_filespec             ; add user's filespec
mov dx,fnbuf                           ; point to working filespec
mov cl,[find_attr]
mov ch,00h
doscall 4eh                            ; find first matching file
alter_multi_1:
jc parse_fn_space.quit                 ; any error, exit loop
cmp byte [dta_name],'.'
je alter_multi_next
mov al,[dta_attr]
test al,attr_c
jne alter_multi_next
%ifdef Enable_A_Mask
and al,[mask_bits]
cmp al,[mask_val]
jne alter_multi_next
%endif ; Enable_A_Mask
call show_cur_dir_maybe                ; display current directory if need be
or byte [more_flags],mf_found
add word [found_lo],byte 01h           ; add one to count of files found
adc word [found_hi],byte 00h
call alter_file                        ; do it to it!
alter_multi_next:
doscall 4fh                            ; find next matching file
jmp short alter_multi_1                ; till the cows come home

alter_file:                            ; CHANGE FILE ATTRIBUTES IF NEEDED :
mov al,[chgattr]
or  al,[newattr]                       ; are both chgattr and newattr zero?
je .l9                                 ; if so, don't alter attributes
call append_found_filespec             ; copy filename into fnbuf
mov cl,[dta_attr]                      ; .cl contains file's old attributes
test byte [more_flags],mf_togz         ; was ~z specified on command line?
je .l55                                ; if not, ~z fix not needed
test cl,07h                            ; if any bit of s h or r is set,
je .l55
or cl,07h                              ; pretend they're all set!
.l55:                                  ; .cl contains old attribs with ~z fix
mov ah,[chgattr]
xor ah,0ffh
mov al,[newattr]
and al,ah                              ; .al contains attributes to toggle
xor cl,al                              ; .cl attributes have been toggled
mov al,[chgattr]
and al,[newattr]                       ; .al contains attributes to set
or cl,al                               ; .cl attributes have been set
mov al,[chgattr]
xor al,0ffh
or al,[newattr]                        ; .al inverse of bits to clear
and cl,al                              ; .cl attributes have been cleared
cmp cl,[dta_attr]                      ; is this a significant change?
je .l9                                 ; if not, don't bother
mov [a_altered],cl                     ; save new attributes for file
call prompt_user                       ; prompt user if so desired
jne .l9                                ; if user declined, do not alter
mov cl,[a_altered]
and cx,[mask_4301]                     ; clear the subdirectory bit
mov dx,fnbuf
doscall 4301h                          ; and use dos call to alter attribs
jc .l20                                ; any error, go to error handler
mov dx,fnbuf
doscall 4300h                          ; get file's new attributes to check
mov al,cl                              ; actual file attributes in .al
mov ah,[a_altered]                     ; desired file attributes in .ah
and ax,hilo(attr_user, attr_user)      ; only interested in these attributes
cmp al,ah                              ; do they match?
jne .l22                               ; if not, error!
mov al,[a_altered]
mov [dta_attr],al                      ; update attributes byte in the dta
.l8:
add word [alter_lo],byte 01h           ; add one to count of files changed
adc word [alter_hi],byte 00h
.l9:
call show_file_info                    ; display filename, attribs, date etc.
call show_bytes_maybe                  ; display 'bytes' string if needed
ret                                    ; and exit
.l22:                                  ; error was not reported by dos :
mov [dta_attr],cl                      ; update dta with actual attributes
zero ax                                ; pretend this is dos error zero
.l20:                                  ; error was reported by dos :
push ax                                ; save dos error number
call show_file_info                    ; show file name, size, date, etc.
dosprint msg_failed                    ; print 'failed' message
pop ax                                 ; get dos error number
or ax,ax                               ; was it zero?
je .l24                                ; if so, don't display number
call decout                            ; if not, display dos error number
.l24:
add word [error_lo],byte 01h           ; add one to the count of failures
adc word [error_hi],byte 00h
jmp crlf                               ; terminate output line and exit

show_file_info:                        ; DISPLAY FILE'S DATE, TIME, ATTRIBS:
%ifdef Enable_Display
cmp byte [display],disp_native         ; was /b or /n specified?
jne show_file_other                    ; if so, go to alternate handler
%endif ; Enable_Display
test byte [more_flags],mf_redir
jne .l1                                ; if output is to the screen,
mov dl,CR                              ; move cursor to the start of the line
doscall 02h
.l1:
mov cx,0004h
call tab_cx                            ; tab right four spaces
call show_cur_filename                 ; and display current filename
mov dh,[dta_attr]
call show_attribs                      ; display file's attributes
mov ax,[dta_date]
call show_dow                          ; compute and show day of week
mov ax,[dta_date]
call show_date                         ; display file's date stamp
call tab_2                             ; and two spaces
mov ax,[dta_time]
call show_time                         ; display file's time stamp
call show_size                         ; display file size
.quit:
ret

%ifdef Enable_Display

show_file_other:                       ; DISPLAY FILE INFO, /B OR /N MODE :
cmp byte [display],disp_batch
je .l05
mov al,[chgattr]
or  al,[newattr]
jne show_file_info.quit
call tab_2
jmp short .l06
.l05:
dosprint msg_attrib_1
.l06:
mov cx,hilo (attr_a,'A')
call show_attr_other
cmp byte [display],disp_batch
je .l07
call tab_2
.l07:
mov cx,hilo (attr_s,'S')
call show_attr_other
mov cx,hilo (attr_h,'H')
call show_attr_other
mov cx,hilo (attr_r,'R')
call show_attr_other
cmp byte [display],disp_batch
je .l09
mov cx,0005h
call tab_cx
.l09:
mov si,fnbuf
.l10:
mov dl,[si]
inc si
int 21h
cmp si,[last_bs]
jna .l10
mov si,dta_name
.l20:
mov dl,[si]
inc si
cmp dl,00h
je .l30
int 21h
jmp short .l20
.l30:
jmp crlf

show_attr_other:
mov ah,02h
cmp byte [display],disp_batch
je .l30
mov dl,SPC
test byte [dta_attr],ch
je .l10
mov dl,cl
.l10:
jmp short .l50
.l30:
mov dl,'-'
test byte [dta_attr],ch
je .l40
mov dl,'+'
.l40:
int 21h
mov dl,cl
int 21h
mov dl,SPC
.l50:
int 21h
ret

%endif ; Enable_Display

find_any_subdirs:                      ; FIND SUBDIRECTORIES, ADD TO TREE BUF
test byte [flags],fb_sws               ; was /s specified?
je dir_loop_exit                       ; if not, don't bother finding subdirs
mov si,star_dot_star                   ; copy star-dot-star filespec
mov di,word [last_bs]                  ; just after the final backslash
inc di
call copy_string
cmp di,fnbuf + fn_max                  ; did the copy overflow the buffer?
jna .l2                                ; no, continue
jmp error_fnbuf_over                   ; yes, crash and burn
.l2:
mov dx,fnbuf
mov cx,0016h                           ; look for subdir, hidden, system ...
doscall 4eh
dir_loop:
jc dir_loop_exit                       ; any error, stop subdir search
test byte [dta_attr],attr_d            ; is the item found a subdir?
je dir_loop_next                       ; if not, keep looking
cmp byte [dta_name],'.'                ; stupid dos . or .. entries?
je dir_loop_next                       ; if so, keep looking
call append_found_filespec             ; add subdir name to current dir name
mov es,[tree_seg]
call find_es_zz                        ; find the end of the tree buffer
mov dx,si                              ; and remember where it was
mov di,si
mov si,fnbuf                           ; copy full pathname of found subdir
call copy_string_far                   ; into the tree buffer
mov cx,di
stosb                                  ; and add a second null
push ds
pop es
cmp cx,dx                              ; did we overflow the tree buffer?
jb tree_buffer_over                    ; if so, bomb out
dir_loop_next:                         ; look for next subdirectory:
doscall 4fh                            ; dos find-next-handle function
jmp short dir_loop
dir_loop_exit:
ret

tree_buffer_over:                      ; TREE BUFFER HAS OVERFLOWED:
bomb msg_tree_buffer_over,16h          ; complain and exit with errorlevel 22

use_next_subdir:                       ; IS A DIRECTORY NAME BUFFERED?
zero bx                                ; a convenient zero
test byte [flags],fb_sws               ; was /s specified?
jne .l1
.l0:
stc                                    ; if not, exit with no new subdir
ret
.l1:                                   ; /s was specified:
mov es,[tree_seg]
cmp [es:bx],bl                         ; is there anything in the buffer?
je .l0                                 ; if not, don't use it.  duh.
push ds
pop es
mov di,fnbuf                           ; es:di points to fnbuf
mov ds,[tree_seg]
zero si                                ; ds:si points to start of tree buffer
call copy_string_far                   ; get directory name from buffer
cmp [si],bl                            ; was it the last name in the buffer?
jne .l4
mov [bx],bx                            ; if so, empty the tree buffer
jmp short .l6
.l4:                                   ; if not,
zero di                                ; copy to the start of the tree buffer
mov es,[cs:tree_seg]
.l5:
lodsb                                  ; copy one byte from tree buffer
stosb                                  ; down into its new location
cmp al,00h                             ; null marking end of one subdir name?
jne .l5
cmp byte [si],00h                      ; if so, look for second (final) null
jne .l5                                ; and keep copying until you find it
stosb                                  ; store final null to new location
.l6:
push cs                                ; restore
push cs
pop ds                                 ; data segment
pop es                                 ; and extra segment
call find_null_fnbuf                   ; find the end of fnbuf
mov [last_bs],di
mov word [di],hilo (00h,'\')           ; add a backslash and terminal null
clc                                    ; and exit with carry clear
.quit:
ret                                    ; to indicate new dir. name present

show_total_counts:                     ; FINAL DISPLAY OF ALL FOUND, CHANGED:
%ifdef Enable_Display
cmp byte [display],disp_brief
jne .l05
test byte [more_flags],mf_found
jne .l05
call error_out
dosprint msg_err_not_found
zprint fnbuf
doscall 4c01h
.l05:
cmp byte [display],disp_native         ; was /b or /n specified?
jne use_next_subdir.quit               ; if so, display nothing
%endif ; Enable_Display
call crlf                              ; print a blank line
dosprint msg_total_found               ; print 'Total found'
mov ax,[total_found_lo]
mov dx,[total_found_hi]
call dec_print_big                     ; and number found.
dosprint msg_num_altered               ; print ', changed'
mov ax,[total_alter_lo]
mov dx,[total_alter_hi]
call dec_print_big                     ; and number changed.
mov ax,[error_lo]
or  ax,[error_hi]                      ; were there any errors?
je .l10                                ; if not, skip ahead
dosprint msg_num_errors                ; if there were, print 'errors'
mov ax,[error_lo]
mov dx,[error_hi]
call dec_print_big                     ; and the number of failures
.l10:
jmp crlf                               ; terminate print line and exit.

handle_operator:                       ; FOUND A PLUS, MINUS OR TILDE :
mov cl,al                              ; remember which it was
inc si                                 ; and skip over it
%ifdef Enable_Equals
test byte [more_flags],mf_equ
je op_parse
jmp err_equals
%endif ; Enable_Equals
op_parse:
lodsb                                  ; examine next character
call is_attrib_letter                  ; does it name an attribute?
jnc .l2                                ; if so, go handle it
cmp al,'Z'                             ; no; was the letter a Z ?
jne .l20
jmp attrib_z                           ; if so, go handle Z pseudo-attribute
.l20:                                  ; unrecognized attribute letter :
cmp al,'!'
ja .l10                                ; if the 'letter' was a bang or below,
mov word [msg_err_odd_attr1+0],2021h   ; patch the error message string to
mov word [msg_err_odd_attr1+2],2020h   ; end in an exclamation point
jmp short .l11
.l10:                                  ; if the 'letter' was above a space,
mov byte [msg_err_odd_attr1+1],al      ; poke it into the error message
.l11:
bomb msg_err_odd_attr,10h              ; complain and exit with errorlevel 16
.l2:                                   ; found an attribute letter:
cmp si,stack_start
jae .l8
and ah,attr_user                       ; ensure that attribute is legal
.l25:
test [chgattr],ah
jne .l9                                ; has this attribute bit been set yet?
test [newattr],ah                      ; if so, error -- go handle it
jne .l9
cmp cl,'~'                             ; tilde?
je .l5                                 ; if so, toggle this attribute bit
cmp cl,'-'                             ; minus?
je .l4                                 ; if so, clear this attribute bit
or [chgattr],ah                        ; plus:  this bit will be changed
or [newattr],ah                        ; this bit will be set
xor ah,0ffh
jmp short .l7                          ; remove bit from template mask, exit
.l4:
or [chgattr],ah                        ; minus:  this bit will be changed
xor ah,0ffh
and [newattr],ah                       ; this bit will be cleared
jmp short .l7                          ; remove bit from template mask, exit
.l5:
or [newattr],ah                        ; tilde:  toggle this attribute bit
xor ah,0ffh
and [chgattr],ah                       ; instead of setting / clearing it
.l7:
and [template_mask],ah                 ; remove bit from template mask
.l8:
mov al,[si]                            ; examine next character
call test_space
je .l75                                ; if it's a space, exit
call test_eol                          ; if it's an end-of-line, exit
je .l75
call test_op
je .l72
jmp op_parse                           ; else assume it's another attribute
.l72:
jmp handle_operator
.l75:
jmp switch_done                        ; and exit
.l9:                                   ; duplicate setting for attribute:
cmp al,'Z'                             ; was it the z attribute?
jne .l99                               ; no, skip over z fix
mov ah,[chgattr]
or  ah,[newattr]                       ; get the value of duplicated bits
mov al,'S'
test ah,attr_s                         ; if bit 2 is set,
jne .l99                               ; assume it's the s bit
mov al,'H'
test ah,attr_h                         ; if bit 1 is set,
jne .l99                               ; assume it's the h bit
mov al,'R'                             ; otherwise, assume it's the r bit
.l99:
mov [msg_err_multi_chg1],al            ; poke attribute letter into string
bomb msg_err_multi_chg,10h             ; complain and exit with errorlevel 16
attrib_z:                              ; found the Z pseudo-attribute:
cmp cl,'~'                             ; after a tilde?
jne .l28
or byte [more_flags],mf_togz           ; if so, note the fact
.l28:
mov ah,07h                             ; load S, H, and R bits
jmp op_parse.l25                       ; and handle normally

%ifdef Enable_Equals

handle_equals:                         ; FOUND AN EQUALS SIGN :
inc si                                 ; skip over it
%ifdef Enable_Environment
cmp si,stack_start                     ; parsing from the environment?
jae .l10                               ; if so, skip error checks
%endif ; Enable_Environment
mov al,[chgattr]
or  al,[newattr]                       ; if chgattr or newattr is nonzero,
jne err_equals                         ; go handle error
test byte [more_flags],mf_swc          ; if a template file was specified,
jne err_equals                         ; go handle error
mov byte [chgattr],attr_user           ; note all attributes to be changed
or byte [more_flags],mf_equ            ; note equals operator specified
.l10:
mov al,byte [si]                       ; if first char is a digit,
call test_digit                        ; get attrib as decimal number instead
je .l30
.l20:
mov al,byte [si]                       ; get next character from command line
call test_space
je .l50                                ; if it's a space or end-of-line,
call test_eol                          ; exit equals parser
je .l50
inc si
call is_attrib_letter                  ; does it name an attribute?
jnc .l25                               ; if so, continue
mov ah,(attr_s | attr_h | attr_r)
cmp al,'Z'                             ; if it's the letter Z,
je .l25                                ; fake it!
jmp op_parse.l20                       ; bad attribute letter -- bomb out
.l25:
%ifdef Enable_Environment
cmp si,stack_start                     ; parsing from the environment?
jae .l20                               ; if so, don't set attribute bit
%endif ; Enable_Environment
and ah,attr_user                       ; make sure attribute is legal
or byte [newattr],ah                   ; set the appropriate bit
jmp short .l20                         ; and loop back for more
.l30:                                  ; attrib specified as decimal number :
zero bx                                ; start with a working value of zero
.l35:
lodsb                                  ; get next character from command line
call test_digit
jne .l40                               ; exit if it's not a digit
mov dl,al
sub dl,'0'                             ; get character into .dx as a value
mov dh,00h
mov ax,bx                              ; working value into .ax
mov cl,0ah
mul cl                                 ; multiply working value by ten
add ax,dx                              ; and add in value of latest digit
mov bx,ax                              ; save working value to .bx
jmp short .l35                         ; and loop back for more
.l40:
%ifdef Enable_Environment
cmp si,stack_start                     ; parsing from the environment?
jae .l50                               ; if so, don't change attrib value
%endif ; Enable_Environment
and bl,attr_user
mov [newattr],bl
.l50:
jmp switch_done

err_equals:
bomb msg_err_equals,10                 ; complain and exit with errorlevel 16

%endif ; Enable_Equals

is_attrib_letter:                      ; DOES CHAR IN .AL NAME AN ATTRIBUTE?
call force_uc                          ; force letter to uppercase
zero bx                                ; start at beginning of attrib table
.l0:
cmp al,[attributes+bx]                 ; found the correct letter yet?
je .l2                                 ; yes, proceed
inc bx                                 ; if not, try the next letter
cmp byte [attributes+bx],00h           ; run out of letters yet?
jne .l0                                ; nope, keep looking
mov ah,0ffh                            ; ran out of letters :
stc                                    ; exit with carry set
ret
.l2:                                   ; letter does name an attribute :
mov ah,[attrib_values+bx]              ; return value of the attribute bit
clc                                    ; and exit with carry clear
ret

%ifdef Enable_Comma

handle_comma:                          ; MICROSOFT UNDOCUMENTED FEATURE :
inc si                                 ; skip over the comma
%ifdef Enable_Environment
cmp si,stack_start                     ; if parsing from the environment,
jae .l9                                ; do nothing and exit
%endif ; Enable_Environment
mov al,[chgattr]                       ; if either chgattr or newattr is
or  al,[newattr]                       ; nonzero, do nothing and exit
jne .l9
test byte [more_flags],mf_swc          ; if a template file was specified,
jne .l9                                ; do nothing and exit
mov byte [chgattr],attr_user           ; otherwise, clear all attributes
.l9:
jmp switch_done                        ; done with comma handler

%endif ; Enable_Comma

switch_c:                              ; /C -- TEMPLATE FILE
mov al,[si]                            ; examine the next character
cmp al,'?'                             ; question mark?
je switch_c_syn                        ; if so, display help for /c
call test_template_separator           ; colon or equals sign?
jne switch_c_err                       ; if not, automatic syntax error
test byte [more_flags],mf_swc          ; was there a previous /c ?
jne switch_c_dupe                      ; if there was, signal an error
%ifdef Enable_Equals
test byte [more_flags],mf_equ          ; was there a previous = operator?
jne err_equals                         ; if there was, error
%endif ; Enable_Equals
inc si                                 ; skip over the colon
call parse_tfn                         ; parse the template filename
%ifdef Enable_Environment
cmp si,stack_start                     ; parsing from the environment?
jae .l4                                ; if so, exit without further ado
%endif ; Enable_Environment
or byte [more_flags],mf_swc            ; note that we have a template file
mov dx,tfbuf                           ; use template filespec
mov cx,[tfn_attr]                      ; and template attributes
doscall 4eh                            ; attempt to locate matching file
jnc .l3
call error_out
dosprint msg_err_temp_open             ; problem -- print error message
zprint tfbuf                           ; and template filename
doscall 4c12h                          ; and exit with errorlevel 18
.l3:
mov cl,[dta_attr]                      ; get attributes of found file
and cl,attr_user                       ; mask off unwanted bits
mov [template_bits],cl                 ; save new attributes
.l4:
jmp switch_done                        ; done getting template attributes

switch_c_err:                          ; PROBLEM WITH /C SYNTAX :
call error_out
switch_c_syn:
dosprint msg_err_sw_c
doscall 4c10h
switch_c_dupe:                         ; MORE THAN ONE /C PRESENT:
mov byte [msg_err_dupe1],'C'
bomb msg_err_dupe,10h                  ; complain and exit with errorlevel 16

switch_s:                              ; /S -- RECURSE INTO SUBDIRECTORIES
or byte [flags],fb_sws
jmp switch_done

switch_p:                              ; /P /Q -- PROMPT USER, YES OR NO
or byte [flags],fb_swp
jmp switch_done

switch_d:                              ; /D -- WILDCARDS MAY MATCH SUBDIRS
or byte [flags],fb_swd
jmp switch_done

switch_h:                              ; /H -- DO NOT HOOK INT 24
or byte [more_flags],mf_swh
jmp switch_done

%ifdef Enable_Display

switch_b:                              ; /B -- BATCH OUTPUT
mov byte [display],disp_batch
jmp switch_done

switch_n:                              ; /N -- MICROSOFT-STYLE OUTPUT
mov byte [display],disp_brief
jmp switch_done

switch_v:                              ; /V -- VERBOSE (NATIVE) OUTPUT
mov byte [display],disp_native
jmp switch_done

%endif ; Enable_Display

switch_f_dupe:                         ; MORE THAN ONE /F ON COMMAND LINE :
mov byte [msg_err_dupe1],'F'
bomb msg_err_dupe,10h                  ; complain and exit with errorlevel 16

switch_f:                              ; /F -- DATE FORMAT
test byte [flags],fb_swf               ; has there already been a /f ?
jne switch_f_dupe                      ; if so, problem
or byte [flags],fb_swf                 ; note it
mov al,[si]                            ; examine the next character
cmp al,'?'                             ; question mark?
je switch_f_syn                        ; if so, display help for /f
call test_colon                        ; colon or equals sign?
jne switch_f_err                       ; if not, automatic syntax error
inc si                                 ; skip over colon
mov al,[si]                            ; examine the next character
call force_uc                          ; in uppercase:
cmp al,'U'                             ; /f:u ?
je switch_f_u                          ; if so, force united states format
cmp al,'E'                             ; /f:e ?
je switch_f_e                          ; if so, force european date format
cmp al,'J'                             ; /f:j ?
je switch_f_j                          ; if so, force japanese date format
cmp al,'I'                             ; /f:i ?
je switch_f_j                          ; if so, force japanese date format
switch_f_err:                          ; PROBLEM WITH /F SYNTAX
call error_out
switch_f_syn:
dosprint msg_err_sw_f                  ; complain
doscall 4c10h                          ; and exit with errorlevel 16

switch_f_u:                            ; united states :  use date format 0
mov al,00h
jmp short switch_f_x
switch_f_e:                            ; european :  use date format 1
mov al,01h
jmp short switch_f_x
switch_f_j:                            ; japanese :  use date format 2
mov al,02h
switch_f_x:
mov [country_date],al                  ; store date format
inc si                                 ; skip over the letter
jmp switch_done                        ; and exit

%ifdef Enable_Paging

switch_m_err:                          ; PROBLEM WITH /M SYNTAX
call error_out
switch_m_syn:
dosprint msg_err_sw_m                  ; display error message
doscall 4c10h                          ; and exit with errorlevel 16

switch_m:                              ; /M -- CONTROL PAGING
mov al,[si]                            ; examine the next character:
cmp al,'?'                             ; is it a question mark?
je switch_m_syn                        ; if so, display help for /m
call test_colon                        ; is the next character a colon?
jne .l1
inc si                                 ; if so, skip over it
mov al,[si]                            ; and expect the next character
call test_digit                        ; to be a digit
jne switch_m_err                       ; colon but no digit = syntax error!
.l1:                                   ; no colon:
call test_digit                        ; is the character a digit?
je .l3                                 ; if so, skip ahead, get user value
mov al,[vga_lines]
mov [screen_lines],al                  ; otherwise, default to 23 lines
jmp switch_done                        ; and return to main parse loop
.l3:                                   ; user-specified paging value:
call get_num                           ; read it in
cmp ah,00h                             ; more than 255?
jne switch_m_err                       ; if so, problem
mov [screen_lines],al                  ; otherwise, save it
jmp switch_done                        ; and exit

%endif ; Enable_Paging

%ifdef Enable_A_Mask

switch_a:                              ; /A -- ATTRIBUTE MASKS
mov al,[si]                            ; examine the next character
cmp al,'?'                             ; question mark?
je switch_a_syn                        ; if so, display help for /a
call test_colon                        ; colon or equals sign?
jne .l10
inc si                                 ; if so, skip over the colon
.l10:
zero cx                                ; .cl zero = last char was not a minus
.l12:
mov al,[si]                            ; get a character
call force_uc                          ; and uppercase it
cmp al,'-'                             ; minus sign?
jne .l18                               ; if so,
cmp cl,ch
jne switch_a_err
inc cl                                 ; note that the last char was a minus
inc si                                 ; skip over it
jmp short .l12                         ; and loop back for more
.l18:
call is_attrib_letter                  ; does character name an attribute?
jnc .l30
jmp op_parse.l20                       ; if not, bomb out
.l30:
%ifdef Enable_Environment
cmp si,stack_start                     ; parsing from the environment?
jae .l40                               ; if so, don't actually store bit
%endif ; Enable_Environment
test [mask_bits],ah                    ; attribute already specified?
jne switch_a_err                       ; if so, bomb out
or [mask_bits],ah                      ; note that this bit is significant
cmp cl,ch                              ; following a minus sign?
jne .l40
or [mask_val],ah                       ; no, note that this bit must be set
.l40:
mov cl,00h                             ; last character was not a minus
inc si
mov al,[si]                            ; examine next character
call test_space
je .l50                                ; if it's a space or end of line,
call test_eol                          ; exit
je .l50
jmp short .l10                         ; else loop back for more
.l50:                                  ; done parsing /a :
%ifdef Enable_Environment
cmp si,stack_start                     ; parsing from the environment?
jae .l60                               ; if so, skip following check
%endif ; Enable_Environment
cmp cl,ch                              ; if last character was a minus sign,
jne switch_a_err                       ; syntax error
cmp byte [mask_bits],ch                ; if no legal attributes were found,
je switch_a_err                        ; syntax error
.l60:
jmp switch_done

switch_a_err:                          ; PROBLEM WITH /A SYNTAX :
call error_out
switch_a_syn:
dosprint msg_err_sw_a
doscall 4c10h

%endif ; Enable_A_Mask

show_cur_dir_maybe:                    ; DISPLAY DIRECTORY NAME IF NEEDED:
cmp word [last_bs],byte 00h            ; is there a backslash in fnbuf?
je show_cur_filename.quit              ; if not, exit in disgust
%ifdef Enable_Display
cmp byte [display],disp_native         ; was either /b or /n specified?
jne show_cur_filename.quit             ; if so, do nothing and exit
%endif ; Enable_Display
mov si,fnbuf
mov di,last_dir_shown
.l2:
lodsb
cmp al,[di]
jne .l8
inc di
cmp si,[last_bs]
jbe .l2
cmp byte [di],00h
je show_cur_filename.quit
.l8:
call show_file_count
call crlf                              ; display a blank line

show_cur_dir:
%ifdef Enable_Display
cmp byte [display],disp_native
jne show_cur_filename.quit
%endif ; Enable_Display
mov si,fnbuf                           ; point to start of filespec buffer
mov di,last_dir_shown
mov ah,02h                             ; dos print-a-character function
.l0:
cmp si,[last_bs]                       ; passed the final backslash yet?
ja .l8                                 ; if so, exit
mov dl,[si]                            ; get a character from directory name
inc si
mov [di],dl
inc di
int 21h                                ; and print it out
jmp short .l0                          ; and loop back for more
.l8:                                   ; done printing current directory name
mov byte [di],00h
jmp crlf                               ; terminate the current print line

show_cur_filename:                     ; DISPLAY FILENAME OF FOUND FILE:
mov di,dta_name                        ; point to start of found filename
mov ah,02h                             ; dos print-a-character function
mov cx,000eh                           ; must print 14 characters
.l0:
mov dl,[di]                            ; get a character from filename
inc di
call petercase_dl                      ; force uppercase or lowercase
cmp dl,00h                             ; found the terminal null yet?
je .l1
int 21h                                ; if not, print the character
dec cx                                 ; decrement the characters index
jmp short .l0                          ; and loop back
.l1:                                   ; done printing filename:
call tab_cx                            ; pad with spaces to 14 characters
.quit:
ret                                    ; then quit

petercase_dl:
test byte [dta_attr],attr_d
jne .l4
cmp dl,'A'
jb .l5
cmp dl,'Z'
ja .l5
or dl,20h
ret
.l4:
cmp dl,'a'
jb .l5
cmp dl,'z'
ja .l5
and dl,0dfh
.l5:
ret

show_date:                             ; display file's date stamp:
push ax                                ; stash date stamp
mov al,[country_date]                  ; check country's date format
cmp al,01h
je show_datee                          ; 01, european date format
cmp al,02h
je show_datej                          ; 02, japanese date format
pop ax
push ax                                ; file's date stamp:
and ah,01h
mov cl,05h
shr ax,cl                              ; get month value in al
mov ah,80h                             ; suppress leading zeroes
call time_print                        ; print month
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
pop ax
push ax                                ; file's date stamp:
and ax,001fh                           ; day value in al; show leading zeroes
call time_print                        ; print day
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
pop ax                                 ; file's date stamp:
show_date_year:
mov cl,09h
shr ax,cl                              ; get year value in al
add ax,1980                            ; and normalize
jmp decout                             ; print the year

show_datee:                            ; show date, european:
pop ax
push ax                                ; file's date stamp:
and ax,001fh                           ; get day value in al
or ah,80h
call time_print                        ; print day without leading zeroes
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
pop ax
push ax                                ; file's date stamp:
and ah,01h
mov cl,05h
shr ax,cl                              ; get month value in al
call time_print                        ; print month, with leading zeroes
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
pop ax                                 ; file's date stamp:
jmp short show_date_year               ; display the year

show_datej:                            ; show date, japanese:
pop ax
push ax                                ; file's date stamp:
call show_date_year                    ; display the year
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
pop ax
push ax                                ; file's date stamp:
and ah,01h
mov cl,05h
shr ax,cl                              ; get month value in al
call time_print                        ; print month, with leading zeroes
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
pop ax                                 ; file's date stamp:
and ax,001fh                           ; get day value in al
jmp time_print                         ; print day with leading zeroes, exit

show_time:                             ; display file's time stamp:
push ax                                ; save time stamp for future reference
mov cl,0bh
shr ax,cl                              ; get hour in al
cmp byte [country_time],00h            ; do the locals use a 24-hour clock?
jne show_time_25                       ; if so, skip all am / pm fiddling
mov byte [msg_info_ampm+1],'a'         ; assume a.m.
cmp al,00h                             ; is it midnight?
jne show_time_15                       ; no, continue ....
mov al,0ch                             ; display midnight as '12 am'
jmp short show_time_20
show_time_15:                          ; not midnight:
cmp al,0ch                             ; is it before noon?
jb show_time_20                        ; if so, don't need to manipulate it
mov byte [msg_info_ampm+1],'p'         ; noon or later:  display as 'pm'
cmp al,0ch                             ; is it noon?
je show_time_20                        ; if so, display as '12 pm'
sub al,0ch                             ; otherwise, normalize hours
show_time_20:                          ; done fiddling with hours:
mov ah,80h                             ; suppress leading zeroes
show_time_25:
call time_print                        ; and print hours
mov dl,[country_tsep]
doscall 02h                            ; followed by the time separator char
pop ax
push ax                                ; file's time stamp:
and ah,07h
mov cl,05h
shr ax,cl                              ; get minutes in al
call time_print                        ; print minutes with leading zeroes
mov dl,[country_tsep]
doscall 02h                            ; followed by the time separator char
pop ax                                 ; file's time stamp:
and ax,001fh
shl ax,01h
call time_print                        ; print seconds with leading zeroes
cmp byte [country_time],00h            ; do the locals use a 24-hour clock?
jne show_time_30
dosprint msg_info_ampm                 ; if not, display a.m. or p.m.
ret
show_time_30:
call tab_2                             ; if so, just print some blanks
ret

time_print:                            ; STUPID TWO-DIGIT DECIMAL PRINT:
mov dh,ah
aam                                    ; unpack decimal digits
add ax,hilo ('0','0')                  ; and convert to ascii digits
push ax                                ; save the remainder
mov dl,ah
test dh,80h                            ; supposed to suppress leading zero?
je .l10                                ; if not, skip ahead
cmp dl,'0'                             ; is the tens digit zero?
jne .l10                               ; if not, skip ahead
mov dl,SPC                             ; if so, print a space instead
.l10:
doscall 02h                            ; print the tens digit
pop dx                                 ; get the ones digit
int 21h                                ; print the ones digit
ret

show_dow_err:                          ; error computing day of week:
mov dx,0007h                           ; return 7 (no day-of-week)
jmp show_dow_x

show_dow:                              ; compute and display day of week:
mov [temp],ax                          ; save date in directory format
mov cl,09h
shr ax,cl
mov [date3],ax                         ; save year
mov bl,1ch                             ; assume february has 28 days
cmp ax,120                             ; year 2100 (dos year 120) ?
je .l1                                 ; if so, not a leap year
test al,03h                            ; year divisible by 4 ?
jne .l1                                ; if it isn't, not a leap year
inc bl                                 ; leap year -- february has 29 days
.l1:
mov [months_table+1],bl                ; stash length of february
mov ax,[temp]
mov cl,05h
shr ax,cl
and ax,000fh                           ; extract month value
cmp al,01h                             ; month less than 1?
jb show_dow_err                        ; if so, no day-of-week
cmp al,0ch                             ; month greater than 12?
ja show_dow_err                        ; if so, no day-of-week
mov [date1],ax                         ; save month
mov ax,[temp]
and ax,001fh                           ; extract day value
cmp al,01h                             ; day less than 1?
jb show_dow_err                        ; if so, no day-of-week
mov [date2],ax                         ; save day
mov bx,[date1]
mov cl,[months_table-1+bx]             ; get length of month in .cl
cmp cl,[date2]                         ; date greater than maximum?
jb show_dow_err                        ; if so, no day-of-week
zero bx
.l3:
mov al,[months_table+bx]               ; get length of month
cbw                                    ; as a word
inc bx
cmp bx,[date1]                         ; hit the user's month yet?
je .l4                                 ; yes, exit this loop
add [date2],ax                         ; no, add month length into julian
jmp short .l3                          ; and loop back for next month
.l4:                                   ; added in lengths of previous months:
mov bx,[date3]                         ; get dos year in .bx
or bx,bx                               ; dos year zero?
je .l8                                 ; if so, skip following calculations
inc word [date2]                       ; add one for leap day 1980
mov ax,bx
mov dx,365
mul dx                                 ; multiply year number by 365
add [date2],ax                         ; and add into the julian number
mov ax,bx
dec ax                                 ; decrement year number
shr ax,01h
shr ax,01h                             ; and divide by four
add [date2],ax                         ; add leap days into julian number
cmp bx,byte 120                        ; year greater than 2100?
jbe .l8
dec word [date2]                       ; if so, subtract one leap day
.l8:                                   ; done computing julian number:
zero dx
mov ax,[date2]                         ; get julian date as 32-bit number
inc ax                                 ; add one (1-1-1980 was a tuesday)
mov cx,0007h                           ; divide julian number by seven
div cx                                 ; remainder in .dx is the day of week
show_dow_x:
shl dx,01h
shl dx,01h                             ; multiply dow number by four
add dx,dow_names                       ; to get offset within dow names table
doscall 09h                            ; print dow name
mov dl,SPC                             ; and a space
doscall 02h
ret                                    ; exit

show_attribs:                          ; display file's attributes in .dh :
mov si,attr1                           ; pointer to attribute letters
mov cl,attr_a                          ; highest bit is #5 (archive)
mov ah,02h
.l10:
mov dl,'.'                             ; assume bit clear
test dh,cl                             ; is this bet set?
je .l15
mov dl,[si]                            ; if so, get appropriate letter
.l15:
int 21h                                ; display letter
inc si                                 ; and increment pointer
.l20:
shr cl,1h                              ; move on to next bit
je .l30
cmp cl,attr_v                          ; volume-label bit?
je .l20                                ; if so, skip over it
jne .l10
.l30:
mov dl,SPC
int 21h
int 21h
ret

show_bytes_maybe:
%ifdef Enable_Display
cmp byte [display],disp_native
jne .l20
%endif ; Enable_Display
test byte [dta_attr],attr_d
jne .l10
dosprint msg_bytes
.l10:
call crlf
.l20:
ret

show_size:
test byte [dta_attr],attr_d
jne show_size_subdir
mov ax,[dta_size+0]
mov dx,[dta_size+2]
mov byte [dp_min],0bh
call dec_print_big
mov dl,SPC
doscall 02h
ret
show_size_subdir:
dosprint msg_subdir
ret

show_file_count:                       ; SHOW NUMBER OF FILES FOUND, CHANGED:
%ifdef Enable_Display
cmp byte [display],disp_native         ; was /b or /n specified?
jne .quit                              ; if so, exit at once
%endif ; Enable_Display
mov ax,[found_lo]
or  ax,[found_hi]                      ; found any at all?
je .quit                               ; if not, do nothing and exit
call crlf                              ; found some; print a blank line
dosprint msg_num_found                 ; and 'files found' message
mov ax,[found_lo]
mov dx,[found_hi]
call dec_print_big                     ; print number of files found
dosprint msg_num_altered               ; print 'files changed' message
mov ax,[alter_lo]
mov dx,[alter_hi]
call dec_print_big                     ; and number of files changed
dosprint msg_in_dir
zprint last_dir_shown
mov ax,[found_lo]
add [total_found_lo],ax                ; add number found
mov ax,[found_hi]
adc [total_found_hi],ax                ; to total number found
mov ax,[alter_lo]
add [total_alter_lo],ax                ; add number changed
mov ax,[alter_hi]
adc [total_alter_hi],ax                ; to total number changed
zero ax
mov [found_lo],ax
mov [found_hi],ax                      ; then zero out files-found count
mov [alter_lo],ax
mov [alter_hi],ax                      ; and files-changed count
.quit:
ret

dec_print_big:                         ; DISPLAY DOUBLEWORD IN DX:AX
mov [dp_t1],ax                         ; save the doubleword value
mov [dp_t2],dx                         ; for later use
mov bx,000ah                           ; ten decimal is our divisor
push bx                                ; also our end-of-stack marker
mov cl,00h                             ; init digits-between-commas count
mov [dp_t4],cl
dec_print_1:                           ; main decimal division loop
zero dx
mov ax,[dp_t2]                         ; dx:ax contains the high word as quad
div bx                                 ; divide by ten
mov [dp_t2],ax                         ; save new high-order word
mov ax,[dp_t1]                         ; get the old low word
div bx                                 ; and divide by ten
mov [dp_t1],ax                         ; save new low word
add dx,byte 0030h                      ; convert remainder to ascii digit
push dx                                ; and save it on the stack
inc byte [dp_t4]
or ax,ax                               ; anything left?
jne dec_print_12                       ; if so, continue with divisions
cmp word [dp_t2],byte 00h
je dec_print_15                        ; if not, print out digits
dec_print_12:
inc cl                                 ; increment digits-between-commas
cmp cl,03h                             ; three digits yet?
jne dec_print_1                        ; if not, loop back for next digit
mov cl,00h                             ; yes, zero counter
mov dl,[country_thou]                  ; and push a comma on the stack
mov dh,dl
push dx
inc byte [dp_t4]
jmp short dec_print_1                  ; and loop back for next digit
dec_print_15:                          ; done with divisions:
mov ah,02h                             ; dos print-character function:
cmp byte [dp_min],00h                  ; right-justified?
je dec_print_2                         ; if not, print digits now
mov cl,[dp_min]
sub cl,[dp_t4]
jbe dec_print_2
mov ch,00h
mov dl,SPC
dec_print_17:
int 21h
loop dec_print_17
dec_print_2:                           ; decimal printout loop
pop dx                                 ; get a digit from the stack
cmp dx,byte 0ah                        ; hit the end of stack yet?
je dec_print_3                         ; if so, exit decimal print routine
int 21h                                ; otherwise, print the digit
jmp short dec_print_2                  ; and loop back for next digit
dec_print_3:
mov byte [dp_min],00h
ret

dp_min:                                ; minimum number of chars to print
db 00

decout:                                ; DECIMAL PRINT, ONE WORD, NO COMMAS:
zero dx
push dx                                ; save zero as end-of-stack marker
mov cx,000ah                           ; use ten as decimal divisor
decout1:                               ; decimal division loop:
div cx                                 ; divide to get next lowest digit
add dx,byte '0'                        ; convert to ascii
push dx                                ; and save on the stack
zero dx                                ; recover high word for division
cmp ax,dx                              ; and check whether done dividing yet
jne decout1                            ; if not, loop back for more
mov ah,02h                             ; dos print-a-character function
decout2:                               ; decimal print loop:
pop dx                                 ; get a word from the stack
or dx,dx                               ; run out of decimal digits yet?
je get_num_err.quit                    ; if so, we're done
int 21h                                ; otherwise, print this digit
jmp short decout2                      ; and loop back for more

get_num:                               ; READ DEC. NUMBER FROM COMMAND LINE:
mov al,[si]                            ; examine first digit
call test_digit                        ; it is a digit, right?
jne get_num_err                        ; if not, exit with carry set
zero bx                                ; start with zero
get_num_loop:
lodsb                                  ; get digit from command line
sub al,'0'                             ; and convert to a value
mov cl,al                              ; save it in .cl
mov ch,00h                             ; as a word value
mov ax,bx                              ; get interim value
mov bx,000ah
mul bx                                 ; and multiply by ten
or dx,dx                               ; if overflow on multiply,
jne get_num_err                        ; abort
add ax,cx                              ; add in value of most recent digit
jc get_num_err
mov bx,ax                              ; and save
mov al,[si]                            ; examine next character
call test_digit                        ; is it a decimal digit?
je get_num_loop                        ; if so, use it as well
mov ax,bx                              ; if not, done -- return value in .ax
clc                                    ; with carry clear
ret
get_num_err:                           ; overflow, or no number at all:
stc                                    ; exit with carry set
.quit:
ret

force_uc:                              ; FORCE CHARACTER IN .AL TO UPPERCASE:
cmp al,'a'
jb .l10                                ; lowercase letter?
cmp al,'z'                             ; if not, make no changes
ja .l10
and al,0dfh                            ; if so, force to uppercase
.l10:
ret

test_space:                            ; IS CHARACTER IN .AL A SPACE OR TAB?
cmp al,SPC                             ; exit with zero-flag set if it is
je .l10
cmp al,09h
.l10:
ret

test_template_separator:               ; IS CHAR. IN .AL ONE OF : = OR ,
cmp al,','
je test_colon.l10

test_colon:                            ; IS CHAR. IN .AL A COLON OR EQUALS?
cmp al,':'                             ; exit with zero-flag set if it is
je .l10
cmp al,'='
.l10:
ret

test_digit:                            ; IS CHARACTER IN .AL A DECIMAL DIGIT?
cmp al,'0'                             ; exit with zero-flag set if it is
jb .l10
cmp al,'9'
ja .l10
cmp al,al
.l10:
ret

test_eol:                              ; IS CHARACTER IN .AL AN EOL OR NULL?
cmp al,CR                              ; exit with zero flag set if it is
je .l10
cmp al,00h
.l10:
ret

test_op:                               ; IS CHARACTER IN .AL AN OPERATOR?
cmp al,'+'                             ; exit with zero flag set if it is
je .l10
cmp al,'-'
je .l10
cmp al,'~'
.l10:
ret

%ifdef Enable_Paging

get_vga_lines:                         ; FIGURE DEFAULT SCROLL LENGTH
push cs
pop es                                 ; point es:di
mov di,dta                             ; to temporary buffer
mov ax,1b00h                           ; vga call:
zero bx
int 10h                                ; get state information
cmp al,1bh                             ; was call successful?
jne .l10                               ; if not, done with paging setup
mov al,[dta+22h]                       ; get number of lines
sub al,02h                             ; and subtract 2
mov [vga_lines],al                     ; save as number of lines to scroll
.l10:
ret

%endif ; Enable_Paging

clean_up_filespec:                     ; CANONICALIZE FILESPEC:
call fix_last_bs                       ; find final backslash
call must_have_drive                   ; supply drive letter if needed
call must_have_path                    ; supply pathname if needed
call never_ends_in_bs                  ; make sure filespec doesn't end in \
call set_attrib_mask                   ; make sure it isn't a directory name
call dots_fix                          ; eliminate any . or .. entries
call no_double_bs                      ; remove any duplicated backslashes
call get_short_filespec                ; extract short filespec from long
ret

must_have_drive:                       ; MAKE SURE FILESPEC HAS A DRIVE:
mov ax,[fnbuf]                         ; examine first two characters:
cmp ax,hilo ('\','\')                  ; is this a unc filespec?
je .l2                                 ; if so, don't muck about with it
cmp ax,hilo (':','A')
jb .l0                                 ; letter followed by a colon?
cmp ax,hilo (':','Z')                  ; if not, add drive letter
ja .l0                                 ; a drive letter was specified:
cmp byte [fnbuf+2],00h                 ; was there anything after it?
jne .l2                                ; if so, simply exit
mov si,star_dot_star                   ; drive letter, but nothing else :
mov di,fnbuf+2h                        ; supply a star-dot-star
jmp copy_string                        ; and exit
.l0:                                   ; doesn't have drive letter :
call find_null_fnbuf                   ; find the end of the filespec
mov si,di                              ; source for copy
inc di                                 ; and add 2 (destination)
inc di
cmp di,fnbuf + fn_max                  ; will this overflow fnbuf?
jae .l7                                ; if so, problem
.l1:
mov al,[si]                            ; copy a byte from source
dec si
mov [di],al                            ; to destination
dec di
cmp si,fnbuf                           ; done yet?
jae .l1                                ; no, continue
doscall 19h                            ; get current drive number
add al,'A'                             ; and convert to a letter
mov ah,':'
mov [fnbuf],ax                         ; stash it in the filename buffer
cmp word [last_bs],byte 00h            ; if a backslash was found,
je .l2
add word [last_bs],byte 02h            ; add 2 to its location
.l2:
ret                                    ; and we're done
.l7:                                   ; adding a drive would overflow fnbuf:
jmp error_fnbuf_over                   ; handle error

must_have_path:                        ; SUPPLY PATHNAME IF NEEDED:
cmp word [fnbuf],hilo ('\','\')        ; is this a unc filespec?
je .quit                               ; if so, don't muck about with it
mov si,fnbuf + 2
cmp byte [si],'\'                      ; did the user supply an abs. path?
je .quit                               ; if so, exit without further ado
; mov si,fnbuf + 2                     ; starting immediately after colon,
mov di,dta                             ; copy everything to temp buffer
call copy_string
mov word [fnbuf+2],hilo (00h,'\')      ; poke in initial backslash
mov dl,[fnbuf]                         ; get drive letter
sub dl,40h                             ; and convert to a number
mov si,fnbuf + 3
doscall 47h                            ; get current directory name
call find_null_fnbuf                   ; find the end of the pathname
dec di
cmp byte [di],'\'                      ; does path already end in backslash?
je .l3
inc di
.l3:
mov byte [di],'\'                      ; terminate pathname
inc di
mov si,dta
call copy_string                       ; and copy remainder of filespec back
call fix_last_bs                       ; repair last_bs variable
.quit:
ret

never_ends_in_bs:                      ; FIX PATHNAMES ENDING IN BACKSLASH:
mov di,[last_bs]                       ; get address of final backslash
inc di                                 ; and examine the following char.
cmp byte [di],00h                      ; is it a null?
jne must_have_path.quit                ; if not, do nothing and exit
mov si,star_dot_star                   ; if so, tack on a star-dot-star
call copy_string                       ; after the backslash
cmp di,fnbuf + fn_max                  ; didn't overflow the buffer, did we?
jna must_have_path.quit
.l70:
jmp error_fnbuf_over                   ; oops

set_attrib_mask:                       ; SET VALUE FOR FIND_ATTR VARIABLE :
mov al,[flags]
and al,fb_swd                          ; get value of /d switch
or al,06h
mov [find_attr],al                     ; and set up find_attr accordingly
mov si,[last_bs]
.l10:
lodsb                                  ; scan through filespec
cmp al,00h                             ; found a null?
je .l20                                ; if so, skip ahead
cmp al,'?'                             ; found a wildcard?
je .quit                               ; if so, default find_attr is okay
cmp al,'*'                             ; if not, keep scanning
je .quit
jne .l10
.l20:                                  ; no wildcards in filename :
mov di,[last_bs]
inc di
cmp byte [di],'.'                      ; if short name begins with a dot,
jne .l30                               ; this is really a directory name;
dec si                                 ; point to terminal null
cmp si,fnbuf + fn_max - 5
ja never_ends_in_bs.l70
mov [last_bs],si                       ; fix last-backslash pointer
mov word [si+0],hilo ('*','\')
mov word [si+2],hilo ('*','.')         ; append a star-dot-star
mov byte [si+4],00h
.quit:
ret                                    ; and exit
.l30:                                  ; no wildcards :
mov byte [find_attr],16h               ; okay to pick up subdirectories
ret

dots_fix:                              ; LOOK FOR . OR .. ENTRIES:
mov si,fnbuf                           ; start at beginning of filespec
.l0:
mov ax,[si]                            ; look at two bytes at a time
inc si
cmp al,00h                             ; found the end of the filespec yet?
jne .l1
.l9:
jmp fix_last_bs                        ; if so, exit
.l1:
cmp ax,hilo ('.','\')                  ; found a . entry?
jne .l0                                ; if not, keep looking
mov cx,0001h                           ; one dot found so far
.l2:
inc si                                 ; skip past that first dot
mov al,[si]                            ; examine the next character
cmp al,00h                             ; end of filespec?
je .l9                                 ; if so, exit
cmp al,'.'                             ; another dot?
jne .l3
inc cx                                 ; if so, count it
jmp short .l2                          ; and keep parsing
.l3:
cmp al,'\'                             ; another backslash?
jne .l0                                ; if not, ignore this (weird) entry
mov di,si                              ; point .di to backslash after dots
.l4:
dec di                                 ; and scan backwards through fnbuf
cmp di,fnbuf                           ; fell off the beginning of fnbuf?
jbe .l8                                ; if so error
cmp byte [di],'\'                      ; found a backslash?
jne .l4                                ; if not, keep searching backwards
loop .l4                               ; decrement dots count, continue
call copy_string                       ; copy string after dots down
jmp short dots_fix                     ; and loop back for more .\ entries
.l8:                                   ; too many dot entries:
bomb msg_err_dots_fix,15h              ; complain and exit with errorlevel 21

no_double_bs:                          ; remove any duplicated backslashes :
mov di,fnbuf                           ; start at beginning of filename
.l10:
inc di
mov ax,[di]                            ; examine two characters at a time
cmp al,00h                             ; found the end of the filespec yet?
je get_short_filespec.quit             ; if so, exit
cmp ax,hilo ('\','\')                  ; duplicate backslashes?
jne .l10                               ; if not, loop back, keep searching
.l20:
mov si,di                              ; copy down
inc si                                 ; from the second backslash
call copy_string                       ; onto the first
dec word [last_bs]                     ; adjust last-backslash pointer
jmp short no_double_bs                 ; and loop back for more abuse

get_short_filespec:                    ; EXTRACT SHORT FILESPEC FROM LONG:
mov si,fnbuf + 2                       ; copy entire filespec
cmp word [last_bs],byte 00h            ; or, if directory was specified,
je .l0
mov si,word [last_bs]                  ; the filespec immediately following
inc si                                 ; the last backslash
.l0:
mov di,nambuf                          ; into the name buffer
push ds
pop es
.l1:
lodsb                                  ; copy one character at a time
stosb                                  ; into the short name buffer
cmp al,00h                             ; until the terminal null is found
jne .l1                                ; then stop.
cmp di,nambuf + 0eh                    ; overflowed the short name buffer?
jae .l3
.quit:
ret                                    ; no, bliss
.l3:                                   ; nambuf has overflowed:
bomb msg_err_nambuf_over,10h           ; complain and exit with errorlevel 16


alloc_tree_buffer:                     ; CREATE BUFFER FOR /S TREE IF NEEDED:
test byte [flags],fb_sws               ; /s specified?
je .quit                               ; no, don't bother with tree buffer
mov bx,1000h                           ; yes, allocate 64k
doscall 48h                            ; for tree buffer
jnc .l0
jmp trs_80                             ; any problem, complain and abort
.l0:
mov [tree_seg],ax                      ; no problem, remember segment
mov es,ax
zero bx
mov [es:bx],bx                         ; and empty the tree buffer
.quit:
ret

%ifdef Enable_Lists

alloc_list_buffer:                     ; CREATE BUFFER FOR FILE LIST:
mov bx,0100h                           ; allocate four kilobytes
doscall 48h                            ; for list buffer
jnc .l0
jmp trs_80                             ; any problem, complain and abort
.l0:
mov [list_seg],ax                      ; no problem, remember segment
mov word [list_pnt],2000h              ; and note that the buffer is empty
ret

get_fn_from_list:                      ; READ FILESPEC FROM FILE LIST:
test byte [flags],fb_list              ; are we using a file list?
jne .l1
clc
ret                                    ; if not, simply exit with carry clear
.l1:
cmp word [auxhandle],byte 00h          ; is it open yet?
jne .l3                                ; if so, continue
mov dx,fnbuf
doscall 3d20h                          ; open file list file
jnc .l2
dosprint msg_err_listfile              ; problem:  print error message
zprint fnbuf                           ; and filename
stc                                    ; and exit with carry
ret
.l2:
mov [auxhandle],ax                     ; save file handle
mov word [list_pnt],2000h              ; and note that the buffer is empty
.l3:
mov di,fnbuf
mov byte [di],00h                      ; empty the filespec buffer
and byte [flags],fb_quote ^ 0ffh       ; not between quotes
read_fn_loop:
call read_from_list                    ; get a character from the file list
cmp al,EOF                             ; end of file?
je read_fn_eof                         ; if so, deal with it
cmp al,SPC                             ; end of line?
jb read_fn_eol                         ; if so, deal with it
call test_space                        ; space?
je read_fn_sp                          ; if so, deal with it
cmp al,'"'                             ; quote mark?
je read_fn_qu                          ; if so, deal with it
cmp al,';'                             ; semicolon?
je read_fn_semi                        ; if so, deal with it
cmp al,':'                             ; colon?
je read_fn_semi                        ; if so, deal with it
call force_uc
cmp al,'/'                             ; slash?
jne read_fn_ch
mov al,'\'                             ; if so, convert to a backslash
read_fn_ch:                            ; got a legal character for filename:
mov [di],al                            ; put it in the buffer
inc di
mov byte [di],00h                      ; and null-terminate it
cmp di,fnbuf + fn_max                  ; blown past the end of the buffer?
jb read_fn_loop                        ; no, loop back for more
jmp read_fn_spam                       ; yes, deal with it
read_fn_eof:                           ; found end of list file:
mov bx,[auxhandle]
doscall 3eh                            ; close the list file
zero ax
mov [auxhandle],ax                     ; and mark it closed
and byte [flags],fb_list ^ 0ffh        ; no more file list!
cmp byte [fnbuf],al                    ; was a filename retrieved before eof?
je .l1
clc                                    ; yes, exit with carry clear
ret
.l1:
stc                                    ; no, exit with carry set
ret
read_fn_sp:                            ; found a space:
test byte [flags],fb_quote             ; between quotes?
jne read_fn_ch                         ; if so, treat like any other char
read_fn_eol:                           ; found end of line:
cmp byte [fnbuf],00h                   ; anything in the buffer yet?
je read_fn_loop                        ; if not, keep looking
call clean_up_filespec                 ; clean it up
clc
ret                                    ; and exit
read_fn_qu:                            ; found a quote:
test byte [flags],fb_quote             ; was there an open quote?
jne read_fn_eol                        ; if so, it ends the filespec
cmp byte [fnbuf],00h                   ; anything in the buffer yet?
jne read_fn_ch                         ; if so, treat like any other char
or byte [flags],fb_quote               ; otherwise, this is an open quote
jmp short read_fn_loop                 ; keep reading
read_fn_semi:                          ; found a semicolon:
test byte [flags],fb_quote             ; between quotes?
jne read_fn_ch                         ; if so, treat like any other char
cmp byte [fnbuf],00h                   ; anything in the buffer yet?
jne read_fn_ch                         ; if so treat like any other char
cmp al,':'                             ; was comment character a colon?
je read_fn_notice                      ; if so, this is a printable 'notice'
read_fn_remark:                        ; NONPRINTABLE COMMENT IN FILE LIST:
call read_from_list                    ; get a character from the file list
cmp al,EOF                             ; end of file?
je read_fn_eof                         ; if so, deal with it
cmp al,SPC                             ; found the end of the remark?
jae read_fn_remark                     ; if not, keep looking
jmp read_fn_loop                       ; otherwise, resume hunt for filespec
read_fn_notice:                        ; PRINTABLE NOTICE IN FILE LIST:
dosprint msg_notice                    ; introduce it
.l0:
call read_from_list                    ; get a character from the file list
cmp al,EOF                             ; end of file?
je .l2                                 ; if so, deal with it
cmp al,SPC                             ; found the end of the notice?
jae .l1
call crlf                              ; if so, terminate the output line
jmp read_fn_loop                       ; and go back to the filespec search
.l1:
mov dl,al                              ; otherwise, this is a printable char
doscall 02h                            ; print it
jmp short .l0                          ; and continue scanning through notice
.l2:                                   ; end-of-file within notice:
call crlf                              ; terminate the output line
jmp read_fn_eof                        ; and the input file

read_fn_spam:                          ; overflowed the working buffer:
mov byte [fnbuf],00h                   ; empty the working buffer
dosprint msg_err_list_spam             ; print an error message
jmp read_fn_eof                        ; and kill the current file list

read_from_list:                        ; GET CHARACTER FROM FILE LIST FILE:
mov ax,[list_pnt]
cmp ax,1000h                           ; need to refill the buffer?
jb read_list                           ; nope, skip ahead
mov cx,1000h                           ; read four kilobytes
mov bx,[auxhandle]                     ; from the file list
zero dx                                ; to the start
mov ds,[list_seg]                      ; of the list buffer
doscall 3fh
push cs
pop ds                                 ; restore data segment
jnc .l3
bomb msg_err_read_list,13h             ; complain and exit with errorlevel 19
.l3:
mov word [list_pnt],0000h              ; move pointer back to start of buffer
cmp ax,1000h                           ; got four kilobytes?
je read_list                           ; cool!
or ax,ax                               ; got anything at all?
jne .l4
mov al,EOF                             ; if not, return end-of-file
ret
.l4:
mov si,ax                              ; got less than four kilobytes:
mov es,[list_seg]                      ; poke in an eof
mov byte [es:si],EOF                   ; just to be on the safe side
read_list:                             ; get buffered char from file list:
mov es,[list_seg]                      ; segment of file list buffer
mov si,[list_pnt]                      ; pointer into list buffer
mov al,byte [es:si]                    ; get character from buffer
inc si
mov [list_pnt],si                      ; and increment the pointer
push ds
pop es                                 ; fix data segment
ret                                    ; and exit

%endif ; Enable_Lists

find_null_fnbuf:                       ; FIND END OF FILESPEC:
mov di,fnbuf                           ; fall through to:

find_null:                             ; FIND END OF ASCIIZ STRING:
cmp byte [di],00h                      ; found null yet?
je fix_last_bs.quit                    ; yes, exit
inc di
jmp short find_null

fix_last_bs:                           ; REPAIR LAST_BS VARIABLE:
zero ax
mov [last_bs],ax                       ; note no backslash found yet
mov si,fnbuf                           ; point to start of filespec buffer
.l0:
mov al,byte [si]                       ; look at character
cmp al,00h                             ; terminal null?
je .l2                                 ; if so, exit
cmp al,'\'                             ; backslash?
jne .l1
mov [last_bs],si                       ; if so, save its address
.l1:
inc si                                 ; and keep on going
jmp short .l0
.l2:                                   ; found the terminal null :
cmp si,fnbuf + fn_max                  ; have we wandered off the edge?
jae .l4                                ; if so, problem
.quit:
ret
.l4:                                   ; spammed fnbuf:
jmp error_fnbuf_over                   ; abort

prompt_user:                           ; PROMPT USER, IF NEEDED:
test byte [flags],fb_swp               ; was /p or /q specified?
je prompt_user_x                       ; if not, bug out
mov cx,0004h
call tab_cx                            ; tab right four spaces
call show_cur_filename
call show_file_info
dosprint msg_query                     ; display prompt message
.l0:
call flush_key_buffer                  ; empty keyboard buffer
mov ah,00h
int 16h                                ; get a keystroke
call force_uc                          ; and convert it to uppercase
cmp al,'A'                             ; 'a' for 'all' ?
je prompt_user_all                     ; if so, deal with it
cmp al,'Q'                             ; 'q' for 'quit' ?
je prompt_user_quit                    ; if so, deal with it
cmp al,'N'                             ; 'n' for 'no' ?
je prompt_user_1                       ; if so, normal exit
cmp al,'Y'                             ; 'y' for 'yes' ?
jne .l0                                ; if not, ignore this keystroke
prompt_user_1:                         ; 'y' or 'n' pressed:
push ax                                ; save the keystroke
call unquery                           ; erase the prompt message
pop ax                                 ; and check the user's keystroke
cmp al,'Y'                             ; was it 'y' for 'yes' ?
prompt_user_x:                         ; exit
ret
prompt_user_all:                       ; 'a' for 'all' :
and byte [flags],fb_swp ^ 0ffh         ; turn off prompting
mov al,'Y'                             ; pretend this was a 'y'
jmp short prompt_user_1                ; and exit normally
prompt_user_quit:                      ; 'q' for 'quit' :
call unquery                           ; erase the prompt message
call show_file_info                    ; redisplay the current line
call show_bytes_maybe                  ; display 'bytes' message if needed
call crlf                              ; terminate the current print line
call show_file_count                   ; show current files found / changed
jmp big_loop_done                      ; and break out of big_loop

unquery:
mov dl,BS
mov cx,000ah
call repeat_char
mov cx,000ah
jmp short tab_cx

tab_2:
mov cx,0002h

tab_cx:
mov dl,SPC
repeat_char:
mov ah,02h
.l10:
int 21h
loop .l10
ret

flush_key_buffer:                      ; EMPTY KEYBOARD BUFFER:
mov ah,01h
int 16h                                ; check keyboard buffer
je get_country_info.quit               ; exit if empty
mov ah,00h                             ; otherwise,
int 16h                                ; get a keystroke from buffer
jmp short flush_key_buffer             ; and loop back

get_country_info:                      ; time and date formats, etcetera
mov dx,country
doscall 3800h                          ; get current country info
.quit:
ret                                    ; and exit

append_found_filespec:                 ; ADD FOUND FILESPEC AFTER PATHNAME:
mov di,[last_bs]                       ; destination is
inc di                                 ; character following final backslash
mov si,dta_name                        ; source is filename in dta
call copy_string                       ; copy found filename into fnbuf
cmp di,fnbuf + fn_max                  ; fnbuf overflow?
ja error_fnbuf_over                    ; if so, handle it
ret                                    ; else exit

append_short_filespec:                 ; ADD USER FILESPEC AFTER PATHNAME:
mov di,[last_bs]                       ; destination is
inc di                                 ; character following final backslash
mov si,nambuf                          ; source is short filespec buffer
call copy_string                       ; copy found filename into fnbuf
cmp di,fnbuf + fn_max                  ; fnbuf overflow?
ja error_fnbuf_over                    ; if so, handle it
ret                                    ; else exit

error_fnbuf_over:                      ; fnbuf has overflowed:
bomb msg_err_fnbuf_over,14h            ; complain and exit with errorlevel 20

copy_string:                           ; COPY ASCIIZ STRING [SI] TO [DI]:
push ds                                ; make .es equal to .ds
pop es                                 ; and fall through ....

copy_string_far:                       ; COPY ASCIIZ STRING [SI] TO [ES:DI]:
lodsb                                  ; get a character from [ds:si]
stosb                                  ; put it in [es:di]
cmp al,00h                             ; until the final null is found
jne copy_string_far
ret                                    ; then quit

find_es_zz:                            ; FIND TERMINAL DOUBLE-NULL:
zero si                                ; start at beginning of tree buffer
cmp [es:si],si                         ; is the tree buffer empty?
je .l2                                 ; if so, return zero in .si
.l0:                                   ; scan forward through tree buffer:
cmp word [es:si],byte 0000h            ; found the double null null yet?
je .l1
inc si                                 ; if not, increment pointer
jmp short .l0                          ; and keep looking
.l1:                                   ; found the double null:
inc si                                 ; return offset of _second_ null
.l2:
ret                                    ; exit

zprint1:                               ; PRINT ASCIIZ STRING VIA .DI:
mov ah,02h                             ; dos print-a-character function
.l0:
mov dl,[di]                            ; get a byte from string
inc di
cmp dl,00h                             ; found the final null?
je .l1                                 ; if so, deal with it
int 21h                                ; otherwise, print the character
jmp short .l0                          ; and loop back for more abuse
.l1:                                   ; found the final null; fall through

%ifdef Enable_Paging

crlf:                                  ; END OF PRINT LINE:
dosprint msg_crlf                      ; print a carriage return, line feed
test byte [more_flags],mf_redir        ; was stdout redirected?
jne .l25                               ; if so, skip ctrl/alt-key check
push es
mov ax,0040h
mov es,ax
test byte [es:0017h],04h               ; is control key down?
je .l20                                ; if not, never mind
.l10:                                  ; control pressed, so do brief delay :
test byte [es:006ch],01h               ; wait for an even jiffy
jne .l10
.l15:
test byte [es:006ch],01h               ; then wait for an odd jiffy
je .l15
.l20:
cmp byte [line],00h                    ; continuous scrolling?
jne .l22                               ; if not, skip check for alt key
test byte [es:0017h],08h               ; is alt key down?
je .l22                                ; if not, don't interrupt scroll
call flush_key_buffer                  ; pause request!  empty key buffer
mov byte [line],01h                    ; and note that next line should pause
cmp byte [screen_lines],00h
jne .l22                               ; if number of screen lines not set,
mov al,[vga_lines]
mov [screen_lines],al                  ; set to default value
.l22:
pop es
.l25:
cmp byte [line],00h                    ; paging output?
je pause_maybe.quit                    ; if not, simply exit

pause_maybe:                           ; CHECK WHETHER PAUSE NEEDED:
dec byte [line]                        ; decrement line count
jne .quit                              ; hit zero yet?  if not, just exit
.l0:                                   ; time for a pause:
dosprint msg_pause                     ; announce it
call flush_key_buffer                  ; empty keyboard buffer
.l1:
mov ah,00h
int 16h                                ; get a keystroke
call force_uc                          ; and force it to uppercase
call unpause                           ; erase pause message
cmp al,CR                              ; enter?
je pause_cr                            ; if so, deal with it (scroll line)
cmp al,'/'                             ; slash?
je pause_slash                         ; if so, deal with it (scroll half)
cmp al,'C'                             ; C ?
je pause_c                             ; if so, deal with it (continuous)
cmp al,1bh                             ; escape ?
je pause_c                             ; if so, deal with it (continuous)
mov al,[screen_lines]                  ; otherwise, move scroll value
mov [line],al                          ; into line count
.quit:
ret                                    ; and exit
pause_cr:                              ; scroll line:
inc byte [line]                        ; set line count to one
ret                                    ; and exit
pause_slash:                           ; scroll half:
mov al,[screen_lines]                  ; get normal scroll value
shr al,01h                             ; divide by two
inc al                                 ; and add one
mov [line],al                          ; save new line count
ret                                    ; and exit
pause_c:                               ; continuous:
mov byte [line],00h                    ; set for no paging
ret                                    ; and exit

unpause:                               ; ERASE PAUSE MESSAGE FROM SCREEN:
push ax                                ; save .ax
mov ah,02h                             ; dos print-a-character function
mov dl,CR                              ; carriage return
int 21h                                ; move cursor to start of line
mov cx,004fh                           ; 79 repetitions:
call tab_cx                            ; print 79 spaces
mov dl,CR                              ; then another carriage return
int 21h                                ; move cursor to start of line
pop ax                                 ; restore previous .ax value
ret                                    ; and exit

%else  ; Enable_Paging

crlf:
dosprint msg_crlf
ret

%endif ; Enable_Paging

template_fix:                          ; TRANSFER TEMPLATE BITS TO VARIABLES:
test byte [more_flags],mf_swc          ; was /c specified?
je .l7                                 ; if not, exit without further ado
mov ah,[template_mask]                 ; get the template mask bits
mov al,[chgattr]                       ; neither chgattr
or  al,[newattr]                       ; nor newattr should have any bits set
and al,ah                              ; in common with the template mask
cmp al,00h                             ; if they do,
jne .l8                                ; flag an error
or [chgattr],ah                        ; note these attributes will change
and ah,[template_bits]                 ; get appropriate bits from template
or [newattr],ah                        ; and poke them into the new values
.l7:
ret                                    ; exit
.l8:                                   ; MASK CONFLICTS WITH CHANGERS:
bomb msg_err_c_bits,10h                ; complain and exit with errorlevel 16

prompt_fix:                            ; CHECK USAGE OF /P :
mov al,[chgattr]
or  al,[newattr]                       ; supposed to change any attributes?
jne .l1                                ; if so, accept /p
and byte [flags],fb_swp ^ 0ffh         ; if not, disregard any /p
ret
.l1:
test byte [flags],fb_swp               ; was /p specified?
je error_out.quit                      ; if not, simply exit
%ifdef Enable_Display
mov byte [display],disp_native         ; if so, disable /b and /n
%endif ; Enable_Display
                                       ; and fall through to....

error_out:                             ; FORCE STDOUT TO STDERR:
mov cx,0001h                           ; force stdout
mov bx,0002h                           ; to stderr
doscall 46h
%ifdef Enable_Paging
mov byte [screen_lines],00h            ; and disable paging
%endif ; Enable_Paging
and byte [more_flags],mf_redir ^ 0ffh  ; note that output is to the screen
.quit:
ret

fix_paging:                            ; CHECK FOR OUTPUT REDIRECTION :
mov bx,0001h                           ; standard output handle
doscall 4400h                          ; ioctl get handle info
and dl,82h
cmp dl,82h                             ; is this the console device?
je .l0
%ifdef Enable_Paging
mov byte [screen_lines],00h            ; if not, disable paging
%endif ; Enable_Paging
or byte [more_flags],mf_redir          ; and note stdout was redirected
.l0:
%ifdef Enable_Paging
mov al,[screen_lines]                  ; use paging value
mov [line],al                          ; to initialize lines count
%endif ; Enable_Paging
ret                                    ; and exit

hook_int_24:                           ; DISABLE CRITICAL-ERROR HANDLING:
test byte [more_flags],mf_swh          ; was /h specified?
jne .l10                               ; if not, do not hook int 24
mov dx,new_int_24                      ; address of new int 24 handler
doscall 2524h                          ; intercept int 24
.l10:
ret

new_int_24:                            ; REPLACEMENT INT 24 HANDLER
mov al,03h                             ; always fail
iret

%ifdef Enable_Environment

check_envars:                          ; CHECK FOR ENVIRONMENT VARIABLES :
mov di,stack_start
mov ax,[002ch]
cmp ax,0008h
jbe .l50
mov es,ax
mov bx,var_cdattrib
call find_envar
jc .l20
call copy_envar
jmp short .l40
.l20:
mov bx,var_attrib
call find_envar
jc .l40
call copy_envar
.l40:
cmp di,stack_start
je .l50
mov si,stack_start - 0001h
ret
.l50:
mov si,0080h
ret

find_envar:
zero bp
.l10:
zero si
.l20:
mov al,[es:bp+si]
call force_uc
cmp al,[bx+si]
jne .l30
cmp al,'='
je .l50
inc si
jmp short .l20
.l30:
inc bp
cmp byte [es:bp],00h
jne .l30
inc bp
cmp byte [es:bp],00h
jne .l10
.l40:
stc
ret
.l50:
add si,bp
inc si
clc
ret

copy_envar:                            ; copy variable's contents to buffer :
mov cl,00h                             ; no double-quotes found yet
.l10:
mov al,[es:si]                         ; get a byte from environment table
mov [di],al                            ; and copy it to working buffer
cmp al,'"'                             ; is the character a double-quote?
jne .l12
inc cl                                 ; if it is, then count it
.l12:
inc si                                 ; bump pointers
inc di
cmp al,00h                             ; hit end of string yet?
jne .l10                               ; if not, loop back, keep on truckin'
dec di                                 ; done; point .di to terminal null
test cl,01h                            ; was there an odd number of quotes?
je .l20                                ; if so,
mov byte [di],'"'                      ; append one more double-quote mark
inc di                                 ; and point to the new end-of-string
.l20:
mov word [di],hilo (00h,SPC)           ; always append a space
inc di                                 ; point to the new terminal null
ret                                    ; and exit

%endif ; Enable_Environment

bombs_away:                            ; HANDLE PARSE ERRORS:
call error_out                         ; reset output to console
dosprint msg_err_begin                 ; print start of error message
pop di
mov dx,[di]                            ; get pointer to error message
doscall 09h                            ; print error message
mov al,[di+02]                         ; get errorlevel
doscall 4ch                            ; and exit program
int 20h


; -------------------------------------- TEXT AND STRINGS :

%ifdef Enable_Markver

msg_markver:                           ; for mark aitchison's version utility
db 'VeRsIoN=1.09b',00h
db 'CoPyRiGhT=Copyright 2001, Charles Dye',00h

%endif ; Enable_Markver

msg_syntax:
db CR,LF
db 'ATTRIB.COM   v1.09b   01-01-2001   C. Dye   raster@highfiber.com',CR,LF
db 'GPL Freeware.  Copyright 1997-2001, Charles Dye.  No warranty!',CR,LF
db LF
db 'ATTRIB [operators] [filespecs] [switches]',CR,LF
db LF
%ifdef Enable_Equals
db '   + set   - clear   ~ toggle   = exact',CR,LF
%else  ; Enable_Equals
db '   + set   - clear   ~ toggle',CR,LF
%endif ; Enable_Equals
db '   A  Archive    H  Hidden',CR,LF
db '   S  System     R  Read-only',CR,LF
db LF
db '   /S  recurse into subdirectories',CR,LF
db '   /P  offer yes/no prompt',CR,LF
%ifdef Enable_Display
db '   /B  batch,  /V verbose,  /N traditional display',CR,LF
%endif ; Enable_Display
%ifdef Enable_Paging
db '   /M  page output',CR,LF
%endif ; Enable_Paging
db '   /D  wildcards may match directory names',CR,LF
db LF
db '   /C=filename   copy attributes from file',CR,LF
%ifdef Enable_A_Mask
db '   /A:mask       filter by attributes',CR,LF
%endif ; Enable_A_Mask
db LF
db 'This program may be freely distributed under the terms of the Free',CR,LF
db "Software Foundation's GNU General Public License, version 2; or, at",CR,LF
db 'your option, any later version of that License.  See the file COPYING',CR,LF
db 'for details.'

msg_crlf:
db CR,LF,'$'

switches:
db 'SPQRFDCH?'
%ifdef Enable_Display
db 'BNV'
%endif ; Enable_Display
%ifdef Enable_Paging
db 'M'
%endif ; Enable_Paging
%ifdef Enable_A_Mask
db 'A'
%endif ; Enable_A_Mask
db 00h

switch_routines:
dw switch_s, switch_p, switch_p, switch_s, switch_f, switch_d, switch_c
dw switch_h, switch_syn
%ifdef Enable_Display
dw switch_b, switch_n, switch_v
%endif ; Enable_Display
%ifdef Enable_Paging
dw switch_m
%endif ; Enable_Paging
%ifdef Enable_A_Mask
dw switch_a
%endif ; Enable_A_Mask


months_table:                          ; number of days in each month
db 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31

dow_names:
db 'Sun$Mon$Tue$Wed$Thu$Fri$Sat$---$'

msg_err_begin:
db CR,LF,'Error:  $'

msg_err_dos_bad:
db 'Requires DOS 3.0 or higher!',CR,LF,'$'

msg_trs_80:
db 'Not enough memory!',CR,LF,'$'

msg_err_fn_ovf:
db 'Filespec too long!',CR,LF,'$'

msg_err_in_filespec:
db 'In filespec!',CR,LF,'$'

msg_err_specs_galore:
db 'More than 31 filespecs!',CR,LF,'$'

msg_err_dots_fix:
db 'Resolving dots!',CR,LF,'$'

%ifdef Enable_Lists

msg_err_listfile:
db "Can't open file list:  $"

msg_err_read_list:
db 'Problem reading from file list!$'

msg_err_list_spam:
db 'Filespec too long in file list!  Closing file list.',CR,LF,'$'

%endif ; Enable_Lists

%ifdef Enable_Display

msg_err_not_found:
db 'File not found - $'

%endif ; Enable_Display

msg_err_temp_open:
db CR,LF,'Error:  Problem with template file $'

msg_err_fnbuf_over:
db 'Spammed working buffer!',CR,LF,'$'

msg_tree_buffer_over:
db 'Tree buffer overflow!',CR,LF,'$'

msg_err_nambuf_over:
db 'Filename longer than 12 characters!',CR,LF,'$'

msg_err_dupe:
db 'More than one /'

msg_err_dupe1:
db '# specified!',CR,LF,'$'

msg_err_c_bits:
db '/C mask conflict!',CR,LF,'$'

msg_err_multi_chg:
db 'More than one setting for '
msg_err_multi_chg1:
db '# bit!',CR,LF,'$'

msg_err_odd_attr:
db 'Unknown attribute'
msg_err_odd_attr1:
db ' # !',CR,LF,'$'

%ifdef Enable_Equals
msg_err_equals:
db 'May not combine = with other operators or /C!',CR,LF,'$'
%endif ; Enable_Equals

msg_failed:
db ' ERROR $'

msg_err_sw_c:
db CR,LF
db 'ATTRIB /C=filename  -- copy attributes from file',CR,LF,LF
db 'Filename may contain wildcards or name a subdirectory.',CR,LF
db '$'

msg_err_sw_f:
db CR,LF
db 'ATTRIB /F:x  -- format for date display',CR,LF,LF
db '/F:U   MM-DD-YYYY',CR,LF
db '/F:E   DD-MM-YYYY',CR,LF
db '/F:J   YYYY-MM-DD',CR,LF
db '$'

%ifdef Enable_Paging

msg_err_sw_m:
db CR,LF
db 'ATTRIB /M:x  -- pause every x lines (More)',CR,LF,LF
db 'Sets the number of lines to display before pausing.  The value x',CR,LF
db 'is optional.  Screen pausing will be disabled if /P is specified',CR,LF
db 'or output is redirected.',CR,LF
db '$'

%endif ; Enable_Paging

%ifdef Enable_A_Mask

msg_err_sw_a:
db CR,LF
db 'ATTRIB /A:mask  -- display or change only items matching mask',CR,LF,LF
db 'The mask may include A D S H R and prefix -',CR,LF
db '$'

%endif ; Enable_A_Mask

%ifdef Enable_Lists

msg_notice:
db 'Notice:  $'

%endif ; Enable_Lists

attributes:                            ; legal after an operator :
db 'ASHRD._',00h

attrib_values:                         ; values for the above :
db attr_a,attr_s,attr_h,attr_r,attr_d,00h,00h

msg_info_ampm:
db ' am  $'

msg_bytes:
db 'bytes$'

msg_attrib_1:
db 'ATTRIB $'

attr1:
db 'ADSHR'

msg_subdir:
db '     <Dir>  $'

msg_num_found:
db 'Files found: $'

msg_num_altered:
db '; altered: $'

msg_in_dir:
db ' in $'

msg_total_found:
db 'Total found: $'

msg_num_errors:
db '; errors: $'

msg_query:
db ' [Y/N] ? $'

%ifdef Enable_Paging

msg_pause:
db ' -- MORE --  <space> page, <enter> line, </> half page, <C> continuous $'

%endif ; Enable_Paging

star_dot_star:
db '*.*',00h

%ifdef Enable_Environment

var_cdattrib:
db 'CDATTRIB='

var_attrib  equ  var_cdattrib + 0002h

%endif ; Enable_Environment


; -------------------------------------- BYTE LENGTH VARIABLES :

flags:
db 00h

; Values for manipulating the Flags byte :

fb_swf    equ  80h                     ; user date format specified       /F
fb_swp    equ  40h                     ; prompt user                   /P /Q
fb_swd    equ  10h                     ; wildcards may match subdirs      /D
fb_sws    equ  08h                     ; recurse into subdirectories   /R /S
fb_list   equ  04h                     ; using file list           @filename
fb_quote  equ  01h                     ; parsing between quotes

more_flags:
db 00h

; Values for manipulating the More_Flags byte :

mf_equ    equ  40h                     ; equals operator
mf_swc    equ  20h                     ; template filespec                /C
mf_redir  equ  10h                     ; standard output is redirected
mf_swh    equ  08h                     ; do not hook int 24               /H
mf_togz   equ  04h                     ; toggle the Z pseudo-attribute    ~Z
mf_isdir  equ  02h                     ; current filespec names a subdir
mf_found  equ  01h                     ; found anything at all?

chgattr:                               ; which attributes to change?
db 00h

newattr:                               ; new attributes
db 00h

%ifdef Enable_A_Mask

mask_bits:
db 00h

mask_val:
db 00h

%endif ; Enable_A_Mask

template_mask:                         ; use which attributes from template?
db attr_user

template_bits:                         ; attributes from template file
db 00h

find_attr:                             ; legal attributes for findfirst/next:
db attr_s | attr_h                     ; 06 files only, 16 files and subdirs

%ifdef Enable_Display

display:                               ; output mode
db disp_native

disp_native  equ  00h                  ; legal values for the display byte
disp_brief   equ  01h
disp_batch   equ  02h

%endif ; Enable_Display


%ifdef Enable_Paging

vga_lines:                             ; default number of lines to scroll
db 17h

screen_lines:                          ; lines to print between pauses
db 00h

line:                                  ; lines remaining before next pause
db 00h

%endif ; Enable_Paging

align 2

; ------------------------------------- WORD LENGTH VARIABLES :

%ifdef Enable_Lists

auxhandle:                             ; handle for file list
dw 0000h

list_seg:                              ; segment of file list buffer
dw 0000h

list_pnt:                              ; pointer into file list buffer
dw 0000h

%endif ; Enable_Lists

last_bs:                               ; offset of final backslash in fnbuf
dw 0000h

tree_seg:                              ; segment of tree buffer
dw 0000h

pointer_pointer:                       ; pointer into list of filespec
dw 0000h                               ; pointers

tfn_attr:                              ; legal attributes for template file
dw 0000h

mask_4301:                             ; which attributes should be passed
dw attr_a | attr_s | attr_h | attr_r   ; to 21/4301 ?

found_lo:                              ; number of files found in current
dw 0000h                               ; directory:
found_hi:                              ; low word / high word
dw 0000h

alter_lo:                              ; number of files changed in current
dw 0000h                               ; directory:
alter_hi:                              ; low word / high word
dw 0000h

total_found_lo:                        ; total number of files found so far:
dw 0000h                               ; low word / high word
total_found_hi:
dw 0000h

total_alter_lo:                        ; total number of files changed:
dw 0000h                               ; low word / high word
total_alter_hi:
dw 0000h

error_lo:                              ; number of files we failed to change:
dw 0000h                               ; low word / high word
error_hi:
dw 0000h


; -------------------------------------- UNINITIALIZED DATA AND STACK :

filespec_pointers:                               ; room for 32 pointers
                                                 ; (31 valid plus final null)

dta       equ  filespec_pointers + 0040h         ; disk transfer area:
dta_attr  equ  dta + 0015h                       ; attribute of found file
dta_time  equ  dta + 0016h                       ; time stamp of found file
dta_date  equ  dta + 0018h                       ; date stamp of found file
dta_size  equ  dta + 001ah                       ; size of found file
dta_name  equ  dta + 001eh                       ; name of found file


fnbuf     equ  dta + 0040h                  ; filespec of files to alter,
                                            ; or of file list

tfbuf     equ  fnbuf + fn_max               ; filespec of template file

last_dir_shown  equ  tfbuf + fn_max         ; last directory name displayed

nambuf    equ  last_dir_shown + fn_max      ; filename of files to alter,
                                            ; without directory name


stack1  equ  (nambuf - $$ + 0100h)
stack_start  equ  (stack1 * 10h + 10fh) / 10h    ; stack starts on paragraph

stack_end  equ  stack_start + 0800h         ; stack is about 2k long


;   Errorlevels:
;   00   Normal exit
;   01   File not found (/N mode only)
;   16   General syntax, buffer overflow
;   17   Not enough memory
;   18   Problem with template file
;   19   Problem with list file
;   20   Internal buffer overflow
;   21   Error resolving directory name
;   22   Tree buffer overflow
;   23   Bad DOS version
;
;
;   Version log:
;
;   1.00   08-12-1997
;          Switches:  /S recurse into subdirectories, /P /Q prompt user,
;          /F set date format, /D allow wildcards to match subdirectory
;   names, /C copy attributes from template, /H do not hook INT 24, /M page
;   output
;   Operators:  - clear, + set, ~ toggle, comma clear all
;   Attributes:  Archive System Hidden Read-only, plus Z pseudo-attribute
;   for setting/clearing S H and R simultaneously
;
;   1.01   11-01-1997
;          Template filespec may now include wildcards; the first matching
;          file (not subdirectory!) will be used.
;
;   1.02   08-05-1998   6056 bytes
;          Various tweaks for FreeDOS compatibility.  NUL and CR are both
;          legal end-of-line markers.  Duplicate backslashes are removed from
;   the filespec.  Will not convert subdirectories into files.  Also fixed
;   a problem which prevented changing attributes of empty subdirectories
;   under DOS-C.
;
;   1.02a  08-13-1998   6121 bytes
;          Fixes an incompatibility with 8086 and 8088 CPUs (logical shifts
;   with immediate count values.)  Also adds version and copyright strings
;   for Mark Aitchison's VERSION.EXE program.
;
;   1.03   09-11-1998   6000 bytes
;          No significant changes in operation, but now it's distributed
;   under the GNU General Public License.  I've modified the syntax display
;   accordingly.  Also moved the filespec buffers out into the uninitialized
;   data area, and generally rearranged things to save space.  Other minor
;   tweaks to shave the program size.  Also corrected the /C? message, which
;   still said /C didn't permit wildcards.
;
;   1.03a  01-14-1999   6,000 bytes                           B5F9D3C6  83DB
;          Fix for /H, which didn't actually do a bloody thing.  Also adds
;   the year of the original release to the copyright message in the syntax
;   screen.
;
;   1.04   01-31-1999   6,000 bytes                           E6691E92  B407
;          Two changes to scrolling.  The key to pause a continuous scroll is
;   now Alt (was Esc.)  This fixes the annoying problem where ATTRIB ate all
;   keystrokes in the typeahead buffer.  Also, the Control key may now be
;   used to slow a scrolling display.
;
;   1.05   03-04-1999   5,980 bytes                           F5CB2A18  A40B
;          Rewrote the test for subdirectory names.  Tightened the code in
;   places.  Disable paging (/M) when prompting (/P) is on.  Added switches
;   /D and /C to the syntax screen.
;
;   1.06   07-07-1999   6,400 bytes                           27427C16  354B
;          Rewritten for NASM.  Added switches /B (batch display), /N
;   (Microsoft-style display), /V (verbose display), /R (synonym for /S).
;   Added support for environment variables CDATTRIB= and ATTRIB=.  Fix for
;   a completely unimportant bug (if Q for Quit was pressed at the prompt,
;   the 'bytes' message was not displayed.)  Also, leading zeroes will not be
;   dropped for the hour value in 24-hour mode.
;
;   1.07   10-04-1999   6,674 bytes                           077C5FBF  D7B1
;          Added /A: (mask by attributes).  Added /F:I as a synonym for /F:J
;   (ISO).  Added /? /C? /F? /M? /A? to display syntax help to stdout (can be
;   redirected to a file).  Allow _ . and D as do-nothing attributes after an
;   operator for compatibility with the 4DOS @ATTRIB function.  Allow
;   operators to be run together without intervening spaces.  Disallowed
;   character device names like con, prn, nul and so on.  Added lots of
;   %defines and %ifdefs to allow features to be removed easily.
;
;   1.08   12-30-1999   6,746 bytes                           1ED0C6DF  83C3
;          Two changes to /N (Microsoft-style) mode.  First, if no files were
;   found an error message is displayed and errorlevel 1 returned.  Second,
;   file info will not be displayed if any changes are to be made.
;   Also, the colon after /A is now optional.
;
;   1.09   02-29-2000   6,956 bytes                           1AABF2E4  AFF3
;          New operator = to set exact attributes:  any bits listed after the
;   equals sign will be set, and all others cleared.
;
;   1.09a  04-24-2000   6,952 bytes                           E8213B6D  CCD6
;          Filespec buffers increased to 260 bytes to handle the super-long
;   pathnames permitted by Windows 95/98.
;
;   1.09b  01-01-2001   6,956 bytes                           EE5889E0  1D12
;          /C now permits a comma instead of the equals sign, to allow for
;   changes to filename completion in the latest 4DOS.

