/*
	emm386c.c
	
	Copyright (c) by tom ehlert 2001 - all rights reserved
	
	to be release under GPL license (when the c't copyright is cleared)


	this code is based on ct0890s (copyright 1990 by harry albrecht, c't)
	
	this was taken, hacked, patched, tweaked, to make a real EMM386

	for current operational status see status.txt
	
*/

#define PROGRAM "EMM386"

#include "useful.h"

#define VDS

/******************** globals in EMM386.ASM **************************************/
#define DMA_BUFFER_SIZE 64

extern ushort far MAXPAGES;
extern ushort far FRAME;
extern ulong  far MONITOR_ADDR;
extern ulong  far EMM_MEMORY_END;
extern ulong  far TOTAL_MEMORY;  
extern char   far IllegalOpcodeHandler[];
extern char   far startup_verbose;
extern char   far INIT_DONE;

extern struct {
	ushort segment;
	ushort size;
	ulong  linearaddress_bottom;
	ulong  linearaddress_top; 
	ulong  physical_offset;
	} far UMBsegments[4];	/* UMB block 'array' :-) */


extern ushort IS386(void);
extern ushort ISPROTECTEDMODE(void);





/********************** local globals   ***************************************/

int FlagNOEMS = FALSE;					/* should be set from commandline */
ushort FlagFRAMEwanted = 0xe000;		/* should be set from commandline */
ushort FlagEMSwanted   = 8*1024;		/* wanted EMM memory          */

char VDS_enabled = 0;					/* only if explicitely enabled */


ulong  XmsLinearAdress;					/* address for our allocated memory */
ulong  XmsAllocatedBytes;				/* memory reserved for EMM          */
ulong  XmsHighestMemoryByte;			/* simply end of ALL memory         */


/*****************************************************************************/

uchar SystemMemory[256];	/* 256*4K pagesize = 1MB */


/* set memory type , but honour "EXCLUDE=" and "INCLUDE=" types */
void SetMemoryType(ushort addr, uchar type)
{
	uchar *mem = &SystemMemory[addr >>8];
	
	if (*mem == 'I' && type != 'X')
		;
	else
		*mem = type;
}	

/*
	'R' = RAM
	'E' = EPROM
    'G' = GRAPHICS
	
	'U' = possible UMB space, because nothing else found
	'P' = PAGEFRAME
	
	'I' = INCLUDE = forced from commandline
	'X' = EXCLUDE = forbidden from commandline
	
	
*/	

/* 
	search memory for ROMS, adapters, graphics,...
	
	builds SystemMemory map
*/	

void ScanSystemMemory(void)
{
	uint mem,i;


	
	for (mem = 0; mem < 0xa000; mem++) /* system memory - reserved */
		SetMemoryType(mem,'R');
		
	for (mem = 0xf000; ; mem++)			/* system EPROM F000..FFFF */
		{
		SetMemoryType(mem,'E');
		if (mem == 0xffff) break;
		}


/* feel free to optimize graphics memory */

	for (mem = 0xa000; mem <= 0xaFFF; mem++) 	/* VGA graphics */
		SetMemoryType(mem,'G');

	for (mem = 0xB000; mem <= 0xB7FF; mem++) 	/* MONO TEXT+graphic */
		SetMemoryType(mem,'G');

	for (mem = 0xb800; mem <= 0xbFFF; mem++) 	/* VGA TEXT */
		SetMemoryType(mem,'G');


	for (mem = 0xf000; ; mem++)			/* system EPROM F000..FFFF */
		{
		SetMemoryType(mem,'S');
		if (mem == 0xffff) break;
		}



	/* scan for ROMS */

	for (mem = 0xc000; mem < 0xf000;)
		{
		uint romsize;
		uchar far *pmem = MK_FP(mem,0);
		
		if ( pmem[0] != 0x55u || pmem[1] != 0xaau)
			{
								/* no adapter EPROM */
			mem += 2048/16;		/* advance by 2K    */   
			continue;
			}            

		romsize = pmem[2] / 2;
		
		if (startup_verbose)	
			printf("EPROM at %p, size %u KB\n", pmem, romsize);
								/* romsize given in 512 byte*/

		for ( i = 0; i < romsize; i+=2)
			{
			SetMemoryType(mem,'E');
			mem += 2048/16;		/* advance by 2K    */
			}
		}

	/* for (i = 0xa0; i < 0xf0; i++)
			printf("%x00 : %c\n",i,SystemMemory[i]); */
}

/* 
	find a contiguos area of 64 KB 
	if none is found, EMS should be disabled
	should handle commandline option like "PAGEFRAME=0xd000"
*/	
ushort LocatePageFrame(void)
{   
	int base,i;
	ushort frame = 0xe0;

	if (FlagNOEMS)
		{
		/* FRAME = 0; */ 
		return 0xe000;
		}

	if (FlagFRAMEwanted)
		{
		base = FlagFRAMEwanted >> 8;
		
		for (i = 0; i < 16; i++)
			{
			if (SystemMemory[base+i] != 'U')
				break;
			}
		if (i == 16)
			{
			frame = base;
			goto frameset;
			}							
		printf("selected page frame %04x not available, searching automatically\n", FlagFRAMEwanted);
		}


	for (base = 0xa0; base <= 0xf0; base++)
		{		
		for (i = 0; i < 16; i++)
			{
			if (SystemMemory[base+i] != 'U')
				break;
			}
		if (i == 16)
			{
			frame = base;
			}							
		}	 

	if (frame == 0)
		{
		printf("no suitable page frame found, which we can't handle\n");
		FlagNOEMS = TRUE;
		}


frameset:
	printf("using PAGEFRAME %02x00:0000\n", frame);
	fmemset(SystemMemory+frame,'P',16);
		
	return frame << 8;
}

/* check if there is 16 KB contiguos memory here to be used as UMB */ 

int isUMBMemory(ushort base)
{
	int i;
	
	for (i = 0; i < 4; base++,i++)
		if (SystemMemory[base] == 'U' ||
		    SystemMemory[base] == 'I' ||
			( FlagNOEMS && SystemMemory[base] == 'P') )
			;
		else
			return FALSE;			
	
	return TRUE;
}


/*
	return number of pages, we need to do UMB mapping 
*/
UMBpageswanted(void)
{
	int i,wanted = 0;
	for (wanted = 0, i = 0xa0; i < 0xf0; i+=4)
		if (isUMBMemory(i))
			{
			wanted++;
			}

	return wanted;
}	

/*
	make sure we have an XMS handler + enable A20
	
	return 1 for SUCCESS
*/

void (far *XMSdriverAdress)(void);

ushort xmsax,xmsbx,xmscx,xmsdx;

int xmscall(uint function)
{
	asm mov dx,xmsdx
	asm mov cx,xmscx
	asm mov bx,xmsbx
	asm mov ax,xmsax
	asm mov ah,function

	XMSdriverAdress();

	asm mov xmsdx,dx
	asm mov xmscx,cx
	asm mov xmsbx,bx
	asm mov xmsax,ax

	return xmsax;
}      


int XMSinit(void)
{   
	{
   asm     mov ax, 4300h;
   asm     int 2fh;                 /*  XMS installation check */

   asm     cmp al, 80h;
   asm     jne not_detected;

   asm     mov ax, 4310h;           /*  XMS get driver address */
   asm     int 2fh;
        
   asm     mov word ptr XMSdriverAdress, bx;
   asm     mov word ptr XMSdriverAdress+2, es;

	} 

	if (XMSdriverAdress == NULL)
		return 0;

	if (!xmscall(3) )				/* enable A20 */
		return 0;

	{ 						
	int i;
	for (i = 0; i < 0xf0; i++)
		{
		if (!xmscall(3) )				/* enable A20 */
			return 0;
		if (!xmscall(5) )				/* enable A20 */
			return 0; 
		}			
	}


	return 1;	


not_detected:
cant_enable:
	return 0;
	
}

/*
	allocate memory from XMS
	find highest memory address
	determine monitor load address (must currently be <= 15MB

	this code uses only old functions (<64MB);
	EMM386 seems not yet to be prepared to handle >64MB
	

*/

XMSallocAndInitMem(uint kbneeded, uint kbwanted)
{   
	ushort xmslargest;
	ushort xmstotal;
	ushort xmshandle;


	xmsbx = 0;
	if (!xmscall(8))			/* get extended memory information */
		{
		printf("can't get XMS information\n");
		return 0;
		}                     
	xmslargest = xmsax;
	xmstotal   = xmsdx;
	

	if (startup_verbose)	
		printf("XMSlargest block 0x%x(%u), XMStotal mem 0x%x(%u)\n",
					xmslargest,xmslargest,xmstotal,xmstotal);


						/* allocate memory from XMS */

	for ( ; ; kbwanted /= 2)
		{
        xmsdx = kbneeded + kbwanted;
        if (xmscall(9))
        	{
        	xmshandle = xmsdx;
        	break;
        	}
		if (kbwanted == 0)
			{
			printf("can't allocate enough XMS memory(%uKB)\n", kbneeded);
			return 0;
			}		
		}


	if (startup_verbose)	
		printf("  allocated %ukb from XMS\n", kbneeded + kbwanted);

						/* lock handle to make a linear adress */	
	
	xmsdx = xmshandle;
	if (!xmscall(0x0c))
		{
		printf("can't lock XMS memory ???\n");
		return 0;
		}		

	XmsAllocatedBytes =  ((ulong)(kbwanted+kbneeded) * 1024);
	
	XmsLinearAdress	     = 	((ulong)xmsdx << 16) | xmsbx;

	XmsHighestMemoryByte =  (ulong)xmstotal * 1024 +
							 0x110000l;					/* DOS + HMA */




/*	printf("xms locked memory at %lx, top of mem %lx(%luMB) alloc bytes %lx(%luKB)\n", 
				XmsLinearAdress,
				XmsHighestMemoryByte,XmsHighestMemoryByte/(1024*1024l),
				XmsAllocatedBytes,XmsAllocatedBytes/(1024));
*/


	return 1;	
	
}   


/*
	we implement a dull (and thus small) UMB handler 
	sufficient for DOS=HIGH, but nothing else :-))

	we will manage 4 different UMB segment/size
	
	to make DOS happier, we never return A000, but always A001
*/

struct xmschain {
	uchar opcode;
	struct xmschain far *next;
	};
	
struct verify_alignment { char x[ sizeof(struct xmschain) == 5 ? 1 : -1]; };	



extern char far * far UMBOldhandler;
extern struct xmschain far UMBhandler; 

extern ulong far int4b_oldhandler;
extern int  far  int4b_handler; 

void InstallUMBhandler(void)
{

							/*  allocate memory block -
								should return NOT_IMPLEMENTED */
	struct xmschain far *pchain;								
	ushort mem,size,index;



    xmsdx = 0xffff;			/* this should fail with error 0x80 */
    xmscall(0x10);
    
    if ((xmsbx & 0xff) != 0x80)
    	{
    	printf("UMB handler already installed, not installing another one\n");
    	return;
    	}

	pchain = (struct xmschain far *) XMSdriverAdress;
	
	for (;;)
		{
		switch(pchain->opcode)
			{
			case  0xeb: 		/* jmp short, end reached */
				goto foundend;

			case  0xea:			/* jmp far xxxx:yyyy */
				pchain = pchain->next;
				break;
				
			default:
				printf("illegal opcode %02x in XMSchain detected - breal\n",pchain->opcode);								
				return;
			}
		}
    

foundend:


								/* now prepare UMB segments to be used later */
	index = 0;
	for (mem = 0xa0; mem < 0xf0; )
		if (!isUMBMemory(mem))
			mem += 4;
		else			
			{
			for (size = 4; ; size+=4)
				if (!isUMBMemory(mem+size))
					break;

			UMBsegments[index].segment = mem  << 8;
			UMBsegments[index].size    = size << 8;			
                                            
                                           /* this could cause weird bugs 
                                              if upper memory a000 would ever
                                              be merged with 9fff:0        */ 	
			if (UMBsegments[index].segment == 0xa000)
				{			
				UMBsegments[index].segment++;
				UMBsegments[index].size   --;			
				}


			if (startup_verbose) 
				printf(" UMB block %d at %x:0000, size = 0x%x paragraphs (%uKb)\n", 
					index,
					UMBsegments[index].segment,
					UMBsegments[index].size,
					UMBsegments[index].size / (1024/16)
					);
			index++;
			if (index >= 4)
				break;

			mem += size;				
			}

	if (UMBsegments[0].segment == 0)
		{
		printf("no suitable UMB memory block found\n");
		return;                                        
		}


								/* now patch us on the end of chain */
	UMBOldhandler  = (char far *)pchain + 5;

	pchain->opcode = 0xea;		/* jmp far	*/
	pchain->next   = &UMBhandler; 

	
}




/*
void Pause()
{
	printf("Any key please");
	asm mov ax,0;
	asm int 0x16;
	
	printf("\n");
}	
*/
/* called on startup.
	handle commandline "/IB800-BFFF /XE000-EFFF" ...
	search for EPROMS+adapters (network cards)
	determine frame address
	...
	mode = 0 if called as driver
	mode = 1 if called as EXE
	
	return: 0         - everything fine
	        errorcode - exit code/abort driver
*/ 

int TheRealMain(int mode, char far *commandline)
{
	char far *found;
	

	printf("FreeDOS " PROGRAM " 0.6 [" __DATE__ "]"
	       " (c) tom ehlert 2001,2002 c't/H. Albrecht 1990 \n");
/*	printf("        DMA-support for \"die Wilde Dreizehn\" V1.0,%d kBytes DMA-Buffer.\n",
						DMA_BUFFER_SIZE);
*/

	fmemset(SystemMemory,'U',sizeof(SystemMemory));


	/******* commandline handling **********/

	if (FindCommand(commandline, "/VERBOSE", &found) ||
	    FindCommand(commandline, "/V",       &found) )
		{ 
		startup_verbose = 1;
		}


	if (FindCommand(commandline, "NOEMS", &found) )
		{
		if (startup_verbose)	
			printf("NOEMS: disable EMS handling (mostly :-)\n");
		FlagNOEMS = TRUE;
		FlagEMSwanted = 0;
		}

	if (FindCommand(commandline, "VDS", &found) )
		{
		if (startup_verbose)	
			printf("VDS enabled\n");
		VDS_enabled = 0;
		}


	if (FindCommand(commandline, "FRAME=", &found) ||
	    FindCommand(commandline, "/P",     &found) )
		{ 
		FlagFRAMEwanted = GetValue(found,16);
		printf("selected FRAMEwanted=0x%x\n",FRAME);
		}

	if (FindCommand(commandline, "EMM=", &found) )
		{ 
		FlagEMSwanted = GetValue(found,10);
		printf("wanted EMS memory %u\n",FlagEMSwanted);
		}


					/* "I=a000-afff"  "X=d000-dfff" */
		
	for (;;)
		{
		ushort rangestart,rangestop;
		char memtype;
		
		memtype = 'I';
		
		if (FindCommand(commandline, "I=", &found) )
			;
		else {
			memtype = 'X';
			if (FindCommand(commandline, "X=", &found) )
				;
			else
				break;
			}

		rangestart =  GetValue(found,16);

		if (*found == '-')		
			{
			fmemcpy( found, found+1, 
								fstrlen(found+1) +1); 

		
			rangestop  =  GetValue(found,16);
		
			printf("%c=%x..%x\n",memtype, rangestart,rangestop);
			
			if (rangestart && rangestop && rangestart<=rangestop && rangestop < 0xffff)
				for ( ; rangestart < rangestop; rangestart++)
					SetMemoryType(rangestart,memtype);
				
			}
		
		}

	/******* commandline handling done, are there remainders **********/

	commandline = skipWhite(commandline);

	if (*commandline)
		printf("ignored commandline  <%Fs>\n", commandline);



	if (mode == EXECMODE_EXE)
		{
							/* called as exe from commandline 
								do :
									usage info
									status report
									show memory statistic
									...
							*/
							
		printf("\n"
				"please load " PROGRAM " as DEVICE=" PROGRAM ".EXE in config.sys\n\n");

		printf("commandline options available for driver\n"
				" NOEMS      - disable EMS handling\n"
				" VDS        - enable VDS - experimental feature\n"
				" FRAME=E000 - select wanted pageframe\n"
				" EMM=8192   - 8192 KB EMS memory wanted-if possible\n"
				" X=D000-D800 - to make memory mapped devices work\n"
				" I=A000-AFFF - IF YOU REALLY KNOW WHAT YOU DO (VGA graphics)\n"
				" I=B000-B7FF - IF YOU REALLY KNOW WHAT YOU DO (Hercules)\n"
				" /VERBOSE    - give some more details\n"
				);				
				
		return 1;
		}											

	/******* options set, now process **********/
	

	if (!IS386())	
			{ 
			printf(PROGRAM " requires at least a 80386 to run\n"); 
			return 1;
			}

	if (ISPROTECTEDMODE())
			{ 
			printf(PROGRAM ":already in protected mode, can't continue\n"); 
			return 1;
			}

	if (!XMSinit())
			{ 
			printf(PROGRAM ":no XMS handler found, required\n"); 
			return 1;
			}


	ScanSystemMemory();			/* build up system memory map */

	if (!FlagNOEMS)
		{

		FRAME = LocatePageFrame();	/* find a contiguos area of 64 KB */	
	
		if (startup_verbose)	
			printf("  choosen FRAME address %x\n",FRAME);
	
	                   				/* some error checks, return != 0 --> exit */
		if (FRAME == 0)
			return 1;
		}

							/* 
								allocate from XMS the memory we need 

								this is memory for UMB's
								
								+ 96KB for the monitor,...
								+ 64KB for DMA buffering
								
								+ what the user wants for EMS
							*/

	if (!XMSallocAndInitMem(UMBpageswanted() * 16 + 64 + 96, FlagEMSwanted))
		{
		return 1;
		}


	MONITOR_ADDR   = XmsLinearAdress;
	EMM_MEMORY_END = XmsLinearAdress + XmsAllocatedBytes;
	TOTAL_MEMORY   = XmsHighestMemoryByte;  

	if (startup_verbose)	
		printf("  MONITOR_ADDR  %lx EMM_MEMORY_END %lx TOTAL_MEMORY  %lx\n",
			MONITOR_ADDR,EMM_MEMORY_END, TOTAL_MEMORY);


	/* InstallUMBhandler();		/* as long as we can debug it */
			
			




/*	Pause(); */

	return 0;				/* OK so far , continue */		
}



/* called just before we go resident
*/ 
void MyFunnyMain(void);
 
void far finishing_touches()
{ 
	char far *p;


	if (startup_verbose) 
	 	printf("  total available EMS %d pages = %lu kByte\n", MAXPAGES, (ulong)MAXPAGES*16);



				/* correct int67 offset. this is a bug in fdemm */    
				/* is it really ?? */
	
	p = *(char far *far*)MK_FP(0,4*0x67);

	if (p == NULL) {printf("no int67");return;}


	if (fmemcmp(p+10, "EMMXXXXX0",3) != 0) 
		{
		if (fmemcmp(MK_FP(FP_SEG(p),10), "EMMXXXX0",8) == 0) 
			{ 
/*			printf("correcting int67 offset\n"); 
			
			*(ushort far*)MK_FP(0,4*0x67) = 0;			*/
			}
		else
			hexd("Int67 offset %p is somehow wrong\n",p,16);
		}			


	*(ulong far *)MK_FP(0,6*4) = (ulong) &IllegalOpcodeHandler;



				/* now do the fun stuff */

	MyFunnyMain(); 
}



ushort emmfunction,emmax,emmbx,emmcx,emmdx;

int emmcall(uint function)
{
	emmfunction = function;
	
	emmax = (emmax & 0xff ) | (function << 8);

/*	printf("%25s in  %04x %04x %04x %04x -", "",emmax,emmbx,emmcx,emmdx);
*/
	asm mov dx,emmdx
	asm mov cx,emmcx
	asm mov bx,emmbx
	asm mov ax,emmax

	asm int 0x67

	asm mov emmdx,dx
	asm mov emmcx,cx
	asm mov emmbx,bx
	asm mov emmax,ax

/*	printf("%1s out %04x %04x %04x %04x \n", "",emmax,emmbx,emmcx,emmdx);
*/
	return emmax >>8;
	
}      
void emmerror(char *s)
{
	printf("EMM failed: %s\n",s);
	
	printf("func %02x, out %04x %04x %04x %04x \n",emmfunction, emmax,emmbx,emmcx,emmdx);
}




/*  
	post processing:
	
	here some magic happens:
	we use (mostly) standard EMS functionality to map some memory
	at the UMB locations + do some more cleanup
*/





void MyFunnyMain()
{   
	int i;
	ushort pageswanted; 
	ushort emmhandle;
	ushort logicalpage; 
#ifdef VDS	
	int    VDS_index = 0;
#endif	

	INIT_DONE	= 0;
	
	
	/* check install state */
/*	
	emmcall(0x46);
	printf("version %x\n",emmax);

	emmcall(0x41);
	printf("page frame at %x\n",emmbx);
	
	emmcall(0x42);
	printf("total pages %x(%dMB), free %x(%dMB)\n",emmdx,emmdx/(1024/16),emmbx,emmbx/(1024/16));

	emmcall(0x4b);
	printf("emm handles %x\n",emmbx);
*/
/*
	for (mem =0xa0; mem < 0xf0; mem+=4)
		printf("mem %x %c - %d\n",mem,SystemMemory[mem], isUMBMemory(mem));
*/

	pageswanted = UMBpageswanted();

	/* allocate a handle + some memory */

	if (startup_verbose)                                                 
		printf("  allocating %u pages = %uKByte for UMB's\n", 
									pageswanted,pageswanted*16); 

	emmbx = pageswanted;
	if (emmcall(0x43) != 0)
		{
		printf("  allocating %dKByte for UMB's:",pageswanted*16);
		emmerror("");
		return;
		}

    emmhandle = emmdx;


	/*  here comes the funny part:
		during initialization phase, calling EMM_MAP_PAGE (0x44)
		with pysical page (AL) > 3 is possible.
		meaning:
		
		AL = highest 8 bits of logical adress, AL=E4 --> address E4000

		initialization phase is terminated with AL=FF
		
	*/	

								/* map pages in to the UMB area */

	if (startup_verbose)	
		printf(" mapping UMBs (16K each) at:");     

	logicalpage = 0;
	

	for (i = 0xa0; i < 0xf0; i+=4)
		if (isUMBMemory(i))
			{
			if (startup_verbose)	
				printf("%x00 ",i);     
		
			emmax = i;
			emmbx = logicalpage;
			emmdx = emmhandle;
		
			if (emmcall(0x44))
				{
				emmerror("mapping UMB page !!");
				goto dont_install_umbhandler;
				}   

#ifdef VDS
									/* stuff for VDS service */
			                                   
			if (VDS_enabled)
				{	
				ulong physical_address;		                                   
										/* this crazy call returns physical address in DX:BX	*/
										
				physical_address = ((ulong)emmdx <<16) | (ushort)(emmbx & ~7);
				/* printf("mapped linear address %02x --> %lx\n", i, physical_address); */


				if (i != 0xa0 && isUMBMemory(i-4))	/* merge with previous */
					{
					UMBsegments[VDS_index].linearaddress_top += 0x4000;
					}
				else {          
					
					UMBsegments[VDS_index].linearaddress_bottom = ((ulong)i) << 12;
					UMBsegments[VDS_index].linearaddress_top    = 
							UMBsegments[VDS_index].linearaddress_bottom + 0x4000;	
					UMBsegments[VDS_index].physical_offset      = physical_address
													- UMBsegments[VDS_index].linearaddress_bottom;	
					}

				if (!isUMBMemory(i+4) || i == 0xf0-4)
					{              
					VDS_index++;
					}
				
				}
#endif				
				
			logicalpage++;
			}
			
#ifdef VDS
	if (VDS_enabled)
		{
		if (startup_verbose)	
			for (i = 0; i < VDS_index; i++)
				{
				printf("VDS region %lx..%lx += %lx\n",
						UMBsegments[i].linearaddress_bottom,
						UMBsegments[i].linearaddress_top   ,
						UMBsegments[i].physical_offset     
						);
				}
		int4b_oldhandler = 	*(ulong far *)MK_FP(0,0x4b*4);
		*(ulong far *)MK_FP(0,0x4b*4) = (ulong)&int4b_handler;
		*(uchar far *)MK_FP(0,0x47b)  |= 0x20;
		}
#endif				


			
			
	if (startup_verbose)	
		printf("\n");

							/* finish our funny 'enhanced' EMM_MAP_HANDLE behaviour */
	emmax = 0xff;
	emmdx = emmhandle;
		
	if (emmcall(0x44))
			{
			emmerror("finish fun part");
			return;
			}

							/* verify the fun part really finished */
	emmax = 0xff;
	emmdx = emmhandle;
		
	if (!emmcall(0x44))
			{
			emmerror("mapping UMB memory");
			}


	InstallUMBhandler();		/* as long as we can debug it */
 
dont_install_umbhandler:

	if (FlagNOEMS)
		{       
						/* disable EMM completely. hack. */
		*(ulong far *)MK_FP(0,4*0x67) = 0;						
		}

	return;


}

 
