/* ----------- keys.h ------------ */

#ifndef KEYS_H
#define KEYS_H

#define OFFSET 0x1000

#define BELL          7
#define RUBOUT        8
#define TAB          15
#define ESC          27
#define ALT_BS      (197+OFFSET)
#define ALT_DEL     (184+OFFSET)
#define SHIFT_DEL   (198+OFFSET)
#define CTRL_INS    (186+OFFSET)
#define SHIFT_INS   (185+OFFSET)
#define SHIFT_F8    (219+OFFSET)
#define F1          (187+OFFSET)
#define F2          (188+OFFSET)
#define F3          (189+OFFSET)
#define F4          (190+OFFSET)
#define F5          (191+OFFSET)
#define F6          (192+OFFSET)
#define F7          (193+OFFSET)
#define F8          (194+OFFSET)
#define F9          (195+OFFSET)
#define F10         (196+OFFSET)
#define CTRL_F1     (222+OFFSET)
#define CTRL_F2     (223+OFFSET)
#define CTRL_F3     (224+OFFSET)
#define CTRL_F4     (225+OFFSET)
#define CTRL_F5     (226+OFFSET)
#define CTRL_F6     (227+OFFSET)
#define CTRL_F7     (228+OFFSET)
#define CTRL_F8     (229+OFFSET)
#define CTRL_F9     (230+OFFSET)
#define CTRL_F10    (231+OFFSET)
#define ALT_F1      (232+OFFSET)
#define ALT_F2      (233+OFFSET)
#define ALT_F3      (234+OFFSET)
#define ALT_F4      (235+OFFSET)
#define ALT_F5      (236+OFFSET)
#define ALT_F6      (237+OFFSET)
#define ALT_F7      (238+OFFSET)
#define ALT_F8      (239+OFFSET)
#define ALT_F9      (240+OFFSET)
#define ALT_F10     (241+OFFSET)
#define HOME        (199+OFFSET)
#define UP          (200+OFFSET)
#define PGUP        (201+OFFSET)
#define BS          (203+OFFSET)
#define FWD         (205+OFFSET)
#define END         (207+OFFSET)
#define DN          (208+OFFSET)
#define PGDN        (209+OFFSET)
#define INS         (210+OFFSET)
#define DEL         (211+OFFSET)
#define CTRL_HOME   (247+OFFSET)
#define CTRL_PGUP   (132+OFFSET)
#define CTRL_BS     (243+OFFSET)
#define CTRL_FIVE   (143+OFFSET)
#define CTRL_FWD    (244+OFFSET)
#define CTRL_END    (245+OFFSET)
#define CTRL_PGDN   (246+OFFSET)
#define SHIFT_HT    (143+OFFSET)
#define ALT_A       (158+OFFSET)
#define ALT_B       (176+OFFSET)
#define ALT_C       (174+OFFSET)
#define ALT_D       (160+OFFSET)
#define ALT_E       (146+OFFSET)
#define ALT_F       (161+OFFSET)
#define ALT_G       (162+OFFSET)
#define ALT_H       (163+OFFSET)
#define ALT_I       (151+OFFSET)
#define ALT_J       (164+OFFSET)
#define ALT_K       (165+OFFSET)
#define ALT_L       (166+OFFSET)
#define ALT_M       (178+OFFSET)
#define ALT_N       (177+OFFSET)
#define ALT_O       (152+OFFSET)
#define ALT_P       (153+OFFSET)
#define ALT_Q       (144+OFFSET)
#define ALT_R       (147+OFFSET)
#define ALT_S       (159+OFFSET)
#define ALT_T       (148+OFFSET)
#define ALT_U       (150+OFFSET)
#define ALT_V       (175+OFFSET)
#define ALT_W       (145+OFFSET)
#define ALT_X       (173+OFFSET)
#define ALT_Y       (149+OFFSET)
#define ALT_Z       (172+OFFSET)
#define ALT_1      (0xf8+OFFSET)
#define ALT_2      (0xf9+OFFSET)
#define ALT_3      (0xfa+OFFSET)
#define ALT_4      (0xfb+OFFSET)
#define ALT_5      (0xfc+OFFSET)
#define ALT_6      (0xfd+OFFSET)
#define ALT_7      (0xfe+OFFSET)
#define ALT_8      (0xff+OFFSET)
#define ALT_9      (0x80+OFFSET)
#define ALT_0      (0x81+OFFSET)
#define ALT_HYPHEN  (130+OFFSET)

#define RIGHTSHIFT 0x01
#define LEFTSHIFT  0x02
#define CTRLKEY    0x04
#define ALTKEY     0x08
#define SCROLLLOCK 0x10
#define NUMLOCK    0x20
#define CAPSLOCK   0x40 /* caps lock BEING on */
#define INSERTKEY  0x80

/* Following is new by Eric 11/2002, but see CONSOLE.C */
#define SYSRQKEY   0x8000
#define CAPSLKEY   0x4000 /* PRESSING caps lock */
#define NUMLKEY    0x2000
#define SCROLLLKEY 0x1000
/* Especially the L/R distinction is important - Eric */
#define RALTKEY    0x800 /* treat this als AltGr, which is NOT Alt */
#define RCTRLKEY   0x400
#define LALTKEY    0x200
#define LCTRLKEY   0x100

#define CTRL_A 1
#define CTRL_B 2
#define CTRL_C 3
#define CTRL_D 4
#define CTRL_E 5
#define CTRL_F 6
#define CTRL_G 7
#define CTRL_H 8
#define CTRL_I 9
#define CTRL_J 10
#define CTRL_K 11
#define CTRL_L 12
#define CTRL_M 13
#define CTRL_N 14
#define CTRL_O 15
#define CTRL_P 16
#define CTRL_Q 17
#define CTRL_R 18
#define CTRL_S 19
#define CTRL_T 20
#define CTRL_U 21
#define CTRL_V 22
#define CTRL_W 23
#define CTRL_X 24
#define CTRL_Y 25
#define CTRL_Z 26

struct keys {
    int keycode;
    char *keylabel;
};
extern struct keys keys[];

#endif
