/*----------------------------------------------------------------------*/
/* Declare types:							*/
/*	count, ulong, FPROC;						*/
/*	STATE, VERSION, SYSINFO;					*/
/*	MEM_TYPE, MCBINFO, MEMINFO;					*/
/*	EXTINFO, XMSINFO, EMSINFO					*/

typedef unsigned int	count;
typedef unsigned long	ulong;
typedef const char	CStr[], *PCStr;
typedef char		Str[], *PStr;
typedef void far (far *FPROC)(void);

typedef enum { NONE, DONE, ERROR } STATE;

typedef union{
	struct { byte minor, major; } h;
	word x;
} VERSION;

typedef struct{
	count	CPU;
    struct{
	int	pause;
	count	last_row,
		fill;
    } screen;
    struct{
	VERSION	ver;
	byte	OEM, flags;
	DOSLoL	*LoL;
	DEVICE	*first_device;
    } OS;
} SYSINFO;

typedef enum{
	MT_SYSCODE	= 0x01,
	MT_SYSDATA	= 0x02,
	MT_SUBSEG	= 0x04,
	MT_CODE		= 0x08,
	MT_DATA		= 0x10,
	MT_ENV		= 0x20,
	MT_FREE		= 0x40
} MEM_TYPE;

typedef struct mcbinfo{
	MEM_TYPE type;
	SEGMENT	seg,
		next_seg,
		owner;
	char	name[16];	/* "DEVICE=STACHIGH" */
	struct	mcbinfo *next;
} MCBINFO;

typedef struct{
	MCBINFO	*root, *last;
    struct{
	count	total_K,
		free,
		largest;
	SEGMENT	last_seg;
    } BASE;
    struct{
	STATE	state;
	count	total,
		free,
		largest;
    } UMB;
} MEMINFO;

typedef struct{
	ulong	total;
	count	free_K;
} EXTINFO;

typedef struct{
	STATE	state;
	FPROC	handler;
	count	free_K,
		largest_K;
    struct{
	count	free,
		largest;
    } UMB;
    struct{
	STATE	state;
	ulong	free_K,
		largest_K;
    } XMS32;
} XMSINFO;

typedef struct{
	STATE	state;
	count	verBCD;
	SEGMENT	frameseg;
	count	pages_total,   pages_free;
} EMSINFO;

typedef struct{
	byte	ID;
	PCStr	str;
} MAP;
