static PCStr	STACK_	DEV_make_name(SEGMENT, OFFSET);
static PCStr	FAST_	DEV_find_name(const MCBINFO*);
static void	FAST_	device_list(void);


/*----------------------------------------------------------------------*/
static PCStr STACK_ DEV_make_name(SEGMENT seg, OFFSET off){
	if(is_CHAR_DEV(FP_DEV(seg, off)->attr)){
		/* assert(sizeof(name) > sizeof(dev->u.char_dev_name)); */
		canonize_name(name, FP_DEV(seg, off)->u.char_dev_name,
				sizeof(FP_DEV(seg, off)->u.char_dev_name));
	}else{
		char first = 0;
		DPB *dpb = SYS.OS.LoL->first_DPB;
		for(; FP_OFF(dpb) != 0xFFFF; dpb = dpb->u.DOS4.next){
			if(FP_DEV(seg, off) == dpb->u.DOS4.dev_addr){
				char drv = dpb->drive_no + 'A';
				if(first == 0) first = drv;
				name[5] = drv;
		}	}
		name[0] = first;
		SetChar2(&name[1], ':', 0);
		if(name[5] != first){
			SetChar2(&name[2], ' ', '-'), name[4] = ' ',
			SetChar2(&name[6], ':', 0);
	}	}
	return name;
}

static PCStr FAST_ DEV_find_name(const MCBINFO *p){
	register SEGMENT dev_seg = FP_SEG(SYS.OS.first_device);
	register OFFSET  dev_off = FP_OFF(SYS.OS.first_device);
	do{	SEGMENT seg = (dev_off >> 4) + dev_seg;
		if(seg >= p->seg && seg < p->next_seg)
			return DEV_make_name(dev_seg, dev_off);
		seg = dev_seg,
		dev_seg = FP_SEG(FP_DEV(seg, dev_off)->next),
		dev_off = FP_OFF(FP_DEV(seg, dev_off)->next);
	}while(dev_off != 0xFFFF);
	return "";
}

static void FAST_ device_list(void){
	SEGMENT dev_seg = FP_SEG(SYS.OS.first_device), seg;
	OFFSET  dev_off = FP_OFF(SYS.OS.first_device);
	header(2, 1,
		"  Address    Attr  Driver    Program\n"
		"-----------  ----  --------  -----------------\n");

	do{	printf(" %Fp   %04X  %-10s",
			FP_DEV(dev_seg, dev_off),
			FP_DEV(dev_seg, dev_off)->attr.x,
			DEV_make_name(dev_seg, dev_off));

	    {	const MCBINFO *p = MCB_find(dev_seg, dev_off);
		if(p && (p->type & ~(MT_SYSCODE | MT_SYSDATA)))
			say(p->name);
	    }	new_line();

		seg = dev_seg,
		dev_seg = FP_SEG(FP_DEV(seg, dev_off)->next),
		dev_off = FP_OFF(FP_DEV(seg, dev_off)->next);
	}while(dev_off != 0xFFFF);
}
