static ulong	FAST_	EXT_E820(void);
static void	FAST_	EXT_get(void);


/*----------------------------------------------------------------------*/
#ifdef ASM386
# pragma option -3 /* enable 80386 instructions */
static ulong FAST_ EXT_E820(void){
# define SMAP 0x534D4150ul		/* ='SMAP'			*/
	_EBX = 0, _ESI = 0;		/* continuation and total value	*/
	do{	struct{
		    union{
			dword	based[2];
			word	basew[4];
		    } u;
			dword	size[2];
			dword	type;
		} map; /* sizeof(map) == 20 */

		_ES = FP_SEG(&map),
		_DI = FP_OFF(&map),		/* pointer to and	*/
		_ECX = sizeof(map),		/*   buffer size	*/
		_EDX = SMAP, _EAX = 0xE820;	/* upper word zeroed	*/
		geninterrupt(0x15);	/* get system memory map	*/
					/* CF -> fail or end of list	*/
		if(_FLAGS & 1 || _EAX != SMAP) break;

		/* check if memory is available/ACPI			*/
		_EAX = map.type - 1; if(_EAX > 3 || _AL == 1) continue;

		/* exclude memory portion below 1M			*/
		_EDX = map.size[1], _EAX = map.size[0];
		if(map.u.based[1] == 0 && map.u.basew[3] < 1024ul/64ul){
			_ECX = 1024ul*1024ul, _ECX -= map.u.based[0];
			if(_EAX < _ECX){
				if(_EDX == 0) continue; /* base+size < 1M */
				_EDX--;
			}
			_EAX -= _ECX; /* base + size - 1M */
		}

		/* exit if size > 4G or summary exceed 4G		*/
		_ESI += _EAX; if(_EDX || _ESI < _EAX) return ULONG_MAX;
	}while(_EBX);
/*!*/	_EAX = 0, _EAX += _ESI;
	return _EAX;
}
# pragma option -3. /* return default CPU mode code generation */
#else
static ulong FAST_ EXT_E820(void) { return 0; }
#endif

static void FAST_ EXT_get(void){
	/* extended memory present on 286+ only */
	if(SYS.CPU < 2) return;

	AH = 0x88; callint(0x15);	/* get extended memory size	*/
	if(AX-1 > 0x7FFFu) AX = 0;	/* AH=80h,86h,88h or AX=	*/
	EXT.free_K = AX;		/* ...number of K above 1M	*/

	/* scan system memory map */
	if(SYS.CPU > 2 && (EXT.total = EXT_E820()) != 0) return;

	BX = 0, AX = 0xE801;		/* PhoenixBIOS: get memory size	*/
	callint(0x15);			/*  for >64M configurations	*/
    {	count size_64K = BX;
	if(CFLAG || size_64K == 0){
		outportb(0x70, 0x18); AH = inportb(0x71); /* read CMOS	*/
		outportb(0x70, 0x17); AL = inportb(0x71);
		size_64K = 0;
	}
	EXT.total = AX * 1024ul + size_64K * (64u * 1024ul);
}   }
