static MCBINFO*	STACK_	MCB_add(SEGMENT, count sz);
static void	STACK_	MCB_make_SYSDATA_list(SEGMENT, SEGMENT);
static byte	FAST_	MCB_make_list(SEGMENT);
static void	FAST_	MEM_get(void);
static const MCBINFO*
		FAST_	MCB_find(SEGMENT, OFFSET);
static void	FAST_	memory_list(void);


/*----------------------------------------------------------------------*/
static MCBINFO *STACK_ MCB_add(SEGMENT sg, count sz){
	MCBINFO *p = MEM_ADD("MCB list", MCBINFO);
/*!*/	SEGMENT seg = sg;
	p->seg = seg, seg += sz, p->next_seg = seg,
	p->owner = 0, p->next = NULL;
	return MEM.last = MEM.last->next = p;
}

static void STACK_ MCB_make_SYSDATA_list(SEGMENT sd, SEGMENT next_seg){
    while(sd < next_seg && FP_SDMCB(sd)->start > sd){
	register MCBINFO *p = MCB_add(FP_SDMCB(sd)->start, FP_SDMCB(sd)->size);
	static MAP SEG_type[] = {
		{'C', "EMS BUFFERS="},	/* /X EMS workspace area	*/
		{'B', "BUFFERS="},	/* storage area			*/
		{'D', "DEVICE=*"},	/* device driver		*/
		{'E', "DEVICE="},	/* device driver appendage	*/
		{'F', "FILES="},	/* storage area (for FILES>5)	*/
		{'I', "IFS=*"},		/* IFS driver			*/
		{'L', "LASTDRIVE="},	/* CDS array storage		*/
		{'S', "STACKS="},	/* code and data area		*/
		{'T', "INSTALL="},	/* transient code		*/
		{'X', "FCBS="},		/* storage area			*/
		{  0, "<unknown>"}
	};
	PStr pn;
	copy_name(p->name, MAP_GET(SEG_type, FP_SDMCB(sd)->ID), sizeof(p->name)-1);
			pn   = &p->name[4];		/* IFS=		*/
	if(*pn != '*')	pn /*= &p->name[7]*/ += 3;	/* DEVICE=	*/
	if(*pn == '*'){
		/* assert(sizeof(p->name) > sizeof(FP_SDMCB(sd)->name)+7); */
		canonize_name(pn, FP_SDMCB(sd)->name, sizeof(FP_SDMCB(sd)->name));
	}
	p->type = MT_SUBSEG, sd = p->next_seg;
}   }

static MCBINFO	/* type       seg next_seg owner    name     next */
	MCB70 = {MT_SYSCODE, 0x70,   0x70,    0, "<system>", NULL},
	MCB50 = {MT_DATA,    0x50,   0x70,    0, "<DOS>",    &MCB70},
	MCB40 = {MT_DATA,    0x40,   0x50,    0, "<BIOS>",   &MCB50},
	MCB00 = {MT_DATA,    0x00,   0x40,    0, "<IVT>",    &MCB40};

static byte FAST_ MCB_make_list(SEGMENT mcb){
    byte ID; MCBINFO *p = &MCB70;
    p->next_seg = mcb, MEM.root = &MCB00, MEM.last = p;
    do{	SEGMENT owner, mcb_data; count size;
	SEGMENT mcb = p->next_seg; ID = FP_MCB(mcb)->ID;
	if(ID != 'M' && ID != 'Z') return ID;

	owner = FP_MCB(mcb)->owner, size = FP_MCB(mcb)->size + 1;
	if(owner == _psp) owner = 0;
	if(owner == 0 && p->type == MT_FREE){
		/*--- MCB is free, MEM itself or slave to MEM...	*/
		/*--- ...and follows free MCB...			*/
		p->next_seg += size,	/* ...merge free blocks	*/
/*!*/		ID = FP_MCB(mcb)->ID; continue;
	}
	p = MCB_add(mcb, size);
/*!*/	mcb = p->seg, mcb_data = mcb + 1;
	if(owner == 0){
		p->type = MT_FREE,
		copy_name(p->name, "--free--", sizeof(FP_MCB(0)->name));
	}elif(owner <= 8){
		word SYSID = *(word far*)FP_MCB(mcb)->name;
		p->type = MT_SYSCODE;
		if(SYSID != 0x4353){		/* 'SC' - system code	*/
		    p->type = MT_SYSDATA;
		    if(SYSID == 0x4453){	/* 'SD' - system data	*/
			MCB_make_SYSDATA_list(mcb_data, p->next_seg);
		}   }
		copy_name(p->name, "<system>", sizeof(FP_MCB(0)->name));
	}elif(owner == mcb_data){		/* MCB owns itself	*/
		p->type = MT_CODE,
		canonize_name(p->name, FP_MCB(mcb)->name,
						sizeof(FP_MCB(mcb)->name));
	}else{					/* slave MCB		*/
//*...dump OWNER as <%04X> into p->name...*/
		p->type = MT_DATA, p->owner = owner,
		copy_name(p->name, "<---->", sizeof(FP_MCB(0)->name));
	}

/*!*/	ID = FP_MCB(p->seg)->ID;
    }while(ID != 'Z');
    return ID;
}

static void FAST_ MEM_get(void){
	/*--- size of conventional memory in Kb */
	MEM.BASE.last_seg =
		(MEM.BASE.total_K = callint(0x12)) * (1024u/16u) - 1;

	/*--- check UMB presence */
    {	register word oldlink = DOS_getUMBlink(),
		      errcode = DOS_setUMBlink(1);
	if(errcode > 1){ /* unknown error */
		say_error("UMB", MSG_chain_bad);
		abort(); return;
	}
	MEM.UMB.state = errcode ? NONE : DONE;

	/*--- make internal list of MCBs */
	if(MCB_make_list(SYS.OS.LoL->first_MCB) != 'Z'){
		say_error("MCB", MSG_chain_bad);
		abort(); return;
	}
	DOS_setUMBlink(oldlink);
    }
	/*--- process internal list of MCBs */
	MEM.BASE.free = MEM.BASE.largest =
	MEM.UMB. free = MEM.UMB. largest = MEM.UMB.total = 0;
    {	MCBINFO *p = MEM.root;
	do{ /*--- compute used/free space and largest free block	*/
	    count size = p->next_seg - p->seg;
	    if(p->seg <= MEM.BASE.last_seg){		/* conventional	*/
		if(p->type == MT_FREE){
			MEM.BASE.free += size;
			if(MEM.BASE.largest < size)
				MEM.BASE.largest = size;
		}
	    }else{					/* UMB		*/
		if((p->type & (MT_SYSCODE | MT_SUBSEG)) == 0)
			MEM.UMB.total += size;
		if(p->type == MT_FREE){
			MEM.UMB.free += size;
			if(MEM.UMB.largest < size)
				MEM.UMB.largest = size;
	    }	}
	    /*--- find slave MCBs and environments			*/
	    if(p->type == MT_CODE){
		MCBINFO *q = MEM.root;
		do{ SEGMENT psp_seg = p->seg + 1;
		    if(q->owner == psp_seg && q != p){
			/* check if p contains PSP and			*/
			/* q is environment for p			*/
			if(FP_PSP(psp_seg)->DOS_exit == 0x20CD &&
			   FP_PSP(psp_seg)->env_seg == q->seg + 1)
				q->type = MT_ENV;
			copy_name(q->name, p->name, sizeof(p->name) - 1);
		    }
		    q = q->next;
		}while(q);
	    }
	    p = p->next;
	}while(p);
}   }

static const MCBINFO *FAST_ MCB_find(SEGMENT seg, OFFSET off){
	off >>= 4, seg += off;
    {	const MCBINFO *p = MEM.root, *found = NULL;
	SEGMENT found_seg = 0;
	do{	if(seg >= p->seg && seg < p->next_seg && p->seg >= found_seg)
			found = p, found_seg = p->seg;
		p = p->next;
	}while(p);
	return found;
}   }

static void FAST_ memory_list(void){
    const MCBINFO *p = MEM.root;
    header(2, 1, "Memory area     Size    Owner       Type\n"
		 "-----------   -------   ---------   -----------------\n");
    do{	printf("%04X0-%04X0%9lu    ",
			p->seg, p->next_seg, (p->next_seg - p->seg) * 16ul);

	  if(p->type & (MT_SYSDATA
		      | MT_DATA
		      | MT_ENV))	printf("%-12s", p->name);
	elif(p->type &  MT_SUBSEG)	printf("  %-10s", DEV_find_name(p));
	elif(p->type &  MT_FREE)	printf("%-12s", "");

	  if(p->seg == 0)		say("INT vectors table");
	elif(p->type & (MT_SYSCODE
		      | MT_CODE
		      | MT_SUBSEG
		      | MT_FREE))	say(p->name);
	elif(p->type & (MT_SYSDATA
		      | MT_DATA))	say("data area");
	/*elif(p->type & MT_ENV)*/
		else			say("environment");
	new_line(); p = p->next;
    }while(p);
}
