static count	FAST_	CPU_type(void);
static CVFP	FAST_	DOS_getvect(byte);
static word	FAST_	DOS_getUMBlink(void);
static word	FAST_	DOS_setUMBlink(word);
static word	FAST_	inkey(void);
static void	FAST_	SYS_get(void);


/*----------------------------------------------------------------------*/
static count FAST_ CPU_type(void){
	count type;

	/* try to change bits 12-15 (0xF000) in the FLAGS register...	*/
	__emit__(0x9C,0x9C,0x58);		/* pushf/pushf/pop ax	*/
	_AH ^= 0xF0;
	__emit__(0x50,0x9D,0x9C,0x5B,0x9D);	/* push ax/popf		*/
						/* pushf/pop bx/popf	*/
	/* ...then check whether any bit was changed */
	type = 3; if(_AH ^ _BH) return type;
	type = 2; if(_BH & 0xF0) type = 0;
	return type;
}

static CVFP FAST_ DOS_getvect(byte no){
/*!*/	no = no, AL = no, AH = 0x35; callint(0x21);
	return MK_FP(ES, BX);
}

static word FAST_ DOS_getUMBlink(void){
	AX = 0x5802; return (byte)callint(0x21);
}

static word FAST_ DOS_setUMBlink(word link){
/*!*/	link = link, BX = link, AX = 0x5803; callint(0x21);
	if(!CFLAG) AX = 0;	/* success or... */
	return AX;		/* ...error code */
}

static word FAST_ inkey(void) { AH = 0; return callint(0x16); }

static void FAST_ SYS_get(void){
	byte last_row = *(CBFP)MK_FP(0, 0x484);
	if(last_row == 0) last_row = 24;
	SYS.screen.last_row = last_row;

	SYS.CPU = CPU_type();

	/* get DOS version, OEM code and load flags */
	AX = 0x3000; callint(0x21);
	SYS.OS.OEM = BH, DH = 0;
	if(AL >= 5) { AX = 0x3306; callint(0x21); AX = BX; }
	SYS.OS.flags = DH,
	SYS.OS.ver.h.major = AL, SYS.OS.ver.h.minor = AH;

	/* get list of lists and start of device drivers chain */
	AH = 0x52; callint(0x21);
	SYS.OS.first_device =
		&(SYS.OS.LoL = (DOSLoL*)MK_FP(ES, BX-2))
		 ->u.x.DOS3.NUL_device;
}

/*----------------------------------------------------------------------*/
#ifdef NONBUFFEREDSTDIO
/* This code replaces setupio.c from BC++ 3.1 RTL and may be added for	*/
/* any program, which doesn't require buffered stdin and stdout - here	*/
/* removed buffers allocation from heap for both. This decreases	*/
/* programs, which don't use heap and fopen().				*/

#include <io.h>
#include <stdio.h>

/* "Check for stack overflow" off for BC++ 3.1				*/
/* "Suppress redundant load" on for BC++ 3.1				*/
#pragma option -N- -Z

extern unsigned _Cdecl _openfd[];

static void FAST_ near setnobuf(FILE *f){
	f->curp = f->buffer = &f->hold;
	if(!isatty(f->fd)) f->flags &= ~_F_TERM;
}

#ifdef __cplusplus
extern "C"
#endif
void near cdecl _setupio(void){
	int i; FILE *f;
	setnobuf(stdin); setnobuf(stdout);
	for(i = 5, f = &_streams[5]; i < _nfile; i++, f++){
		_openfd[i] = 0,
		f->fd = -1, f->token = (short)f;
}	}

#pragma startup _setupio 2

#pragma option -N. -Z.

#endif
