static void	FAST_	XMS32_get(void);
static STATE	FAST_	XMS_get(void);
static void	FAST_	XMS_list_handles(void);
static void	FAST_	XMS_list(void);


/*----------------------------------------------------------------------*/
#ifdef ASM86
#  define XMS_call(func) (AH = func, XMS.handler(), AX)
#else
   static word FAST_ XMS_call_(void){
	_DX = DX, _BX = BX;
	XMS.handler();
	BX = _BX, DX = _DX, AX = _AX; return _AX;
   }
#  define XMS_call(func) (_AH = func, XMS_call_())
#endif

#ifdef ASM386
# pragma option -3 /* enable 80386 instructions */
#endif
static void FAST_ XMS32_get(void){
	XMS.XMS32.state = NONE;
	if(SYS.CPU < 3) return;
	/* query free extended memory */
	BL = 0, XMS_call(0x88); if(BL) return;
#ifdef ASM386
	XMS.XMS32.largest_K = _EAX, XMS.XMS32.free_K = _EDX;
#else
	/*asm mov dword ptr [XMS.XMS32.largest_K],eax;*/
	__emit__(0x66,0xA3,&XMS.XMS32.largest_K);
	/*asm mov dword ptr [XMS.XMS32.free_K],edx;*/
	__emit__(0x66,0x89,0x16,&XMS.XMS32.free_K);
#endif
	XMS.XMS32.state = DONE;
}
#ifdef ASM386
# pragma option -3. /* return default CPU mode code generation */
#endif

static STATE FAST_ XMS_get(void){
	/* check XMS presence */
	AX = 0x4300; if((byte)callint(0x2F) != 0x80) return NONE;

	/* get XMS handler address */
	/*ES = BX = 0,*/ AX = 0x4310; callint(0x2F);
/* Additional check:
 *	if((ES | BX) == 0) return NONE;
 */
/* Alternate check:
 *	byte jmp = *(CBFP)MK_FP(ES, BX);
 *	if(jmp != 0xEB && jmp != 0xEA) return NONE;
 */
	XMS.handler = (FPROC)MK_FP(ES, BX);

	/* query free extended memory */
	BL = 0, XMS.largest_K = XMS_call(8), XMS.free_K = DX;
	if(BL) { say_error(MSG_XMS_call, "08h"); return ERROR; }

	/* count free UMBs size */
    {	word lastseg = 0;
	for(XMS.UMB.free = XMS.UMB.largest = 0;;){
		/* query largest UMB size, then allocate this UMB	*/
		DX = 0xFFFF, XMS_call(0x10);
		/*BX = 0;*/ if(XMS_call(0x10) == 0
			/*|| BX == 0 || DX == 0*/) break;
		XMS.UMB.free += DX;
		if(DX > XMS.UMB.largest)
			XMS.UMB.largest = DX;
		*(word far*)MK_FP(BX, 0) = lastseg, lastseg = BX;
	}
	while(lastseg){
		/* release UMB */
		DX = lastseg, lastseg = *(word far*)MK_FP(lastseg, 0);
		XMS_call(0x11);
    }	}

	XMS32_get();
	return DONE;
}

static void FAST_ XMS_list_handles(void){
	header(2, 1,
		"\t  Handle     Size     Locks     Memory area\n"
		"\t  ------  ----------  -----  -----------------\n");

	do{	XMS_TABLE *tbl;
		/* get XMS handle table */
		/*ES = BX = 0,*/ AX = 0x4309;
		if((byte)callint(0x2F) != 0x43 /*|| (ES | BX) == 0*/) break;
		tbl = (XMS_TABLE*)MK_FP(ES, BX);
		if(tbl->handle_sz != sizeof(XMS_BLOCK)) break;

	    {	count i = tbl->handle_cnt + 1; XMS_BLOCK *pb = tbl->pb;
		for(; --(int)i; pb++){
		    if(pb->flag == 2){ /* used */
			count locks = pb->locks;
			printf("\t%7u%12luK%6u",
				FP_OFF(pb), pb->size_K, locks);
			if(locks)
				printf("   %06lX00-%06lX00",
					pb->offset_K << 2,
					(pb->offset_K + pb->size_K) << 2);
			new_line();
	    }	}    }
		return;
	}while(0);

	/* query all handles in WORD range */
    {	word i = 0;
	do{ DX = i; if(XMS_call(0xE)){		/* get handle info	*/
		count locks = BH, size = DX;
		printf("\t%7u%12uK%6u", i, DX, locks);
		if(locks){
			union{ word w[2]; ulong l; } address;
			DX = i; XMS_call(0xC);	/* lock EMB		*/
			address.w[0] = BX, address.w[1] = DX;
			printf("   %08lX-%08lX",
				address.l, size * 1024ul + address.l);
			DX = i; XMS_call(0xD);	/* unlock EMB		*/
		}
		new_line();
	    }
/*!*/	}while(++(int)i /*&& i <= 0xFFFF*/);
}   }

static void FAST_ XMS_list(void){
	if(XMS.state == ERROR) return;
	header(1, 2, "     XMS version: ");
	if(XMS.state != DONE) { say("none\n"); return; }

    {	register count verBCD = XMS_call(0),	/* get XMS version	*/
			/*drv_verBCD = BX,*/ HMA = DX;
	printf(			  "%X.%02X\t\tLine A20: %s\n"
		" Driver revision: %u.%02X\t\t     HMA: ",
		verBCD >> 8, verBCD & 0xFF,
		(XMS_call(7) == 0 || BL)	/* query A20 state	*/
			? "disabled" : "enabled",
/*!*/		/*drv_verBCD >> 8*/BH, /*drv_verBCD & 0xFF*/BL);

	if(HMA){
		DX = 0xFFFF; if(XMS_call(1)){	/* request HMA		*/
			XMS_call(2);		/* release HMA		*/
			say("available");
		}else	say("allocated");
	}else		say("none");
    }	new_line();

	DX = 0; if(XMS_call(9)){		/* allocate EMB		*/
		register word handle = DX;
		if(XMS_call(0xE))		/* get handle info	*/
			sayv("    Free handles: %u", BL + 1);
		DX = handle; XMS_call(0xA);	/* free EMB		*/
		new_line();
	}

	XMS_list_handles();
}
