/*----------------------------------------------------------------------*/
/* Declare types:							*/
/*	byte, word, dword, OFFSET, SEGMENT, CVFP, CBFP;			*/
/*	MCB, UMB_MCB, HMA_MCB, SYSDATA_MCB, PSP,			*/
/*	DEVICE_ATTR, DEVICE, DPB, STACKS, DOSLoL;			*/
/*	XMS_BLOCK, XMS_TABLE, EMS_HANDLE, EMS_MPA			*/
/* Declare macroses:							*/
/*	FP_MCB(), FP_PSP(), FP_SDMCB(), FP_DEV(), SetChar2()		*/

#ifdef __TURBOC__
# pragma option -a- /* force byte alignment */
#endif

typedef unsigned char	byte;
typedef unsigned int	word;
typedef unsigned long	dword;
typedef word		OFFSET;
typedef word		SEGMENT;
typedef const void far	*CVFP;
typedef const byte far	*CBFP;

#ifdef __TURBOC__
# if sizeof(byte) != 1
#  error Wrong "byte" type definition!
# endif
# if sizeof(word) != 2
#  error Wrong "word" type definition!
# endif
# if sizeof(dword) != 4
#  error Wrong "dword" type definition!
# endif
# if sizeof(OFFSET) != 2
#  error Wrong "OFFSET" type definition!
# endif
# if sizeof(SEGMENT) != 2
#  error Wrong "SEGMENT" type definition!
# endif
# if sizeof(CVFP) != 4
#  error Wrong "CVFP" type definition!
# endif
# if sizeof(CBFP) != 4
#  error Wrong "CBFP" type definition!
# endif
#endif

typedef SYSSTRUCT{
	byte	ID;		/* 'M'=valid, 'Z'=last block		*/
	SEGMENT	owner;		/* PSP segment of owner			*/
	word	size;		/* size in paragraphs			*/
	byte	unused[3];
	byte	name[8];	/* owner name (DOS 4.0+)		*/
} far MCB;	/* sizeof(MCB) == 16 */

#ifdef __TURBOC__
# if sizeof(MCB) != 16
#  error Wrong "MCB" type definition!
# endif
#endif

typedef SYSSTRUCT{
	byte	ID;		/* 'M'=valid, 'Z'=last block		*/
	SEGMENT	first_free;	/* 0xA for last block			*/
	word	size;		/* size in paragraphs			*/
	byte	unused[3];
	byte	name[8];	/* "UMB"=first block, "SM"=last block	*/
} far UMB_MCB;	/* sizeof(UMB_MCB) == 16 */

#ifdef __TURBOC__
# if sizeof(UMB_MCB) != 16
#  error Wrong "UMB_MCB" type definition!
# endif
#endif

typedef SYSSTRUCT{
	word	ID;		/* ="MS"				*/
	word	free;		/* 0=free				*/
	word	size;		/* size in bytes			*/
	OFFSET	next_off;	/* offset of next block in HMA or 0	*/
	byte	unused[8];
} far HMA_MCB;	/* sizeof(HMA_MCB) == 16 */

#ifdef __TURBOC__
# if sizeof(HMA_MCB) != 16
#  error Wrong "HMA_MCB" type definition!
# endif
#endif

typedef SYSSTRUCT{
	byte	ID;
	SEGMENT	start;
	word	size;		/* size in paragraphs			*/
	byte	unused[3];
	byte	name[8];	/* name for ID='D' and 'I'		*/
} far SYSDATA_MCB; /* sizeof(SYSDATA_MCB) == 16 */

#ifdef __TURBOC__
# if sizeof(SYSDATA_MCB) != 16
#  error Wrong "SYSDATA_MCB" type definition!
# endif
#endif

typedef SYSSTRUCT{
	word	DOS_exit;	/* =INT20 instruction (0x20CD)		*/
	word	next_seg;	/* segment beyond program memory	*/
	byte	unused04;
	byte	CPM_call[5];	/* =CALL FAR to DOS (obsolete)		*/
	CVFP	INT22,		/* on exit this copied to INT22		*/
		INT23,		/* Ctrl-Break handler			*/
		INT24;		/* DOS1.1+ Critical Error handler	*/
	SEGMENT	parent;		/* PSP segment of parent		*/
	byte	default_JFT[20];/* DOS2+ file handles, 0xFF=closed	*/
	SEGMENT	env_seg;	/* DOS2+ environment segment		*/
	CVFP	SS_SP;		/* DOS2+ SS:SP at last INT21 call	*/
	word	JFT_size;	/* DOS3+ number of entries in JFT	*/
	CBFP	JFT;		/* DOS3+ default is PSP:18h (defaultJFT)*/
	CVFP	prev;		/* DOS3+ default is FFFF:FFFFh		*/
	byte	console,	/* DOS4+ (DBCS) interim console flag	*/
		truename;	/* (APPEND) TrueName flag		*/
	byte	unused3E[2];	/* (OS/2, Novell NetWare)		*/
	byte	vermajor,
		verminor;	/* DOS5+ version to return by INT21/30	*/
	byte	unused42[14],	/* (Windows3)				*/
		DOS_call[3],	/* DOS2+ =INT21/RETF instructions	*/
		unused53[9],	/* can be used to FCB1->extended FCB	*/
		FCB1[16],	/* unopened FCB for 1st cmd argument	*/
		FCB2[16],	/* unopened FCB for 2nd cmd argument	*/
		unused7C[4];
	byte	cmd_line_len;
	byte	cmd_line[127];
} far PSP;	/* sizeof(PSP) == 256 */

#ifdef __TURBOC__
# if sizeof(PSP) != 256
#  error Wrong "PSP" type definition!
# endif
#endif

typedef union{
    struct{ unsigned
	is_stdin	:1,
	is_stdout	:1,
	is_stdnul	:1,	/* NUL device				*/
	is_clock	:1,	/* CLOCK$ device			*/
	special		:1,	/* INT29 "fast console output"		*/
			:1,
	IOCTL_generic	:1,	/* DOS32+ Generic IOCTL call supported	*/
	IOCTL_query	:1,	/* DOS5+ Generic IOCTL check supported	*/
			:3,
	open_close	:1,	/* DOS3+ OPEN/CLOSE calls supported	*/
			:1,
	out_till_busy	:1,	/* DOS3+ output until busy supported	*/
	IOCTL		:1,	/* IOCTL supported			*/
	is_char_dev	:1;	/* =1					*/
    } char_dev;
    struct{ unsigned
			:1,
	big_disk	:1,	/* DOS331+ 32-bit sectors addressing	*/
			:4,
	IOCTL_generic	:1,	/* DOS32+ Generic IOCTL call supported	*/
	IOCTL_query	:1,	/* DOS5+ Generic IOCTL check supported	*/
			:3,
	open_close	:1,	/* DOS3+ OPEN/CLOSE calls supported	*/
	is_remote	:1,	/* device is remote			*/
	nonFAT		:1,	/* not need FAT+BPB (non-IBM format)	*/
	IOCTL		:1,	/* IOCTL supported			*/
	is_char_dev	:1;	/* =0					*/
    } block_dev;
	word	x;
	byte	b[2];
} DEVICE_ATTR;	/* sizeof(DEVICE_ATTR) == 2 */

#ifdef __TURBOC__
# if sizeof(DEVICE_ATTR) != 2
#  error Wrong "DEVICE_ATTR" type definition!
# endif
#endif

				/* = (attr).char_dev.is_char_dev	*/
				/* = (attr).x & 0x8000			*/
#define is_CHAR_DEV(attr)	((attr).b[1] & 0x80)

typedef SYSSTRUCT device{
	struct	device far *next;	/* FP_OFF(next)==0xFFFF if last	*/
	DEVICE_ATTR attr;
	OFFSET	strategy_entry,
		interrupt_entry;
	union{
		byte	char_dev_name[8];
	    struct{
		byte	unit_cnt;
		byte	signature[7];	/* normally unused		*/
	    } block_dev;
	} u;
} far DEVICE;	/* sizeof(DEVICE) == 18 */

#ifdef __TURBOC__
# if sizeof(DEVICE) != 18
#  error Wrong "DEVICE" type definition!
# endif
#endif

typedef SYSSTRUCT dpb{
	byte	drive_no,		/* drive # (0=A, 1=B ...)	*/
		unit_no;		/* sub-unit #			*/
	word	bytes_in_sector;
	byte	last_sector_in_cluster,
		cluster_to_sector_shift;
	word	reserved_sectors;
	byte	FAT_count;
	word	rootentry_count,
		first_data_sector,	/* sector # of cluster #2	*/
		total_clusters_1;	/* number of clusters + 1	*/
    union{ struct{
	byte	sectors_in_FAT;
	word	first_root_sector;
	DEVICE	*dev_addr;
	byte	media_ID,
		access_flag;		/* 0=disk accessed, 0xFF=not	*/
	struct	dpb far *next;
      } DOS2; /* DOS 2.x-3.x */
      struct{
	word	sectors_in_FAT;
	word	first_root_sector;
	DEVICE	*dev_addr;
	byte	media_ID,
		access_flag;		/* 0=disk accessed, 0xFF=not	*/
	struct	dpb far *next;
	word	next_search,
		free_clusters;		/* 0xFFFF=unknown yet		*/
      } DOS4; /* DOS 4.x-6.x */
    } u;
} far DPB;	/* offsetof(DPB, DOS2) == 15 */
		/* sizeof(((DPB*)0)->DOS2) == 13 */
		/* sizeof(((DPB*)0)->DOS4) == 18 */

#ifdef __TURBOC__
# if sizeof(DPB) != 33
#  error Wrong "DPB" type definition!
# endif
#endif

typedef SYSSTRUCT{
	word	unknown;
	word	cnt,		/* x from CONFIG.SYS STACKS=x,y		*/
		control_size,	/* size of control block array		*/
		size;		/* y from CONFIG.SYS STACKS=x,y		*/
	CVFP	data;
	OFFSET	control_off,	/* offset of control block array	*/
		last_off,	/* offset of last element		*/
		next_off;	/* next entry to allocate		*/
} far STACKS;	/* sizeof(STACKS) == 18 */

#ifdef __TURBOC__
# if sizeof(STACKS) != 18
#  error Wrong "STACKS" type definition!
# endif
#endif

typedef SYSSTRUCT{
	SEGMENT	first_MCB;	/* -2: segment of first MCB		*/
	DPB	*first_DPB;
	CVFP	first_SFT;
	DEVICE	*active_CLOCK_dev;
	DEVICE	*active_CON_dev;
  union{ struct{
	byte	drive_count;	/* number of logical drives		*/
	word	max_block_sz;	/* max block size of any block device	*/
	CVFP	first_buffer;
	DEVICE	NUL_device;	/* NUL device header (first in chain)	*/
    } DOS2; /* DOS 2.x */
    struct{
	byte	drive_count;	/* number of block devices		*/
	word	max_block_sz;	/* max block size of any block device	*/
	CVFP	first_buffer;
	CVFP	CDS_table;	/* pointer to CDS[lastdrive] array	*/
	byte	lastdrive;	/* CONFIG.SYS LASTDRIVE= value		*/
	CVFP	workspace;	/* pointer to STRING= workspace area	*/
	word	wspace_sz;	/* CONFIG.SYS STRING= value		*/
	CVFP	FCB_table;	/* pointer to FCB table (SFT)		*/
	word	protected_FCBs;	/* y from CONFIG.SYS FCBS=x,y		*/
	DEVICE	NUL_device;	/* NUL device header (first in chain)	*/
    } DOS30; /* DOS 3.0 */
    struct{
      struct{
	word	max_sector_sz;	/* max sector size for any block device	*/
	CVFP	first_buffer;
	CVFP	CDS_table;	/* pointer to CDS[lastdrive] array	*/
	CVFP	FCB_table;	/* pointer to FCB table (SFT)		*/
	word	protected_FCBs;	/* y from CONFIG.SYS FCBS=x,y		*/
	byte	drive_count,	/* number of block devices		*/
		lastdrive;	/* max from 5, number of block devices	*/
				/*  and CONFIG.SYS LASTDRIVE= value	*/
	DEVICE	NUL_device;	/* NUL device header (first in chain)	*/
	byte	join_count;	/* number of JOIN'ed drives		*/
      } DOS3; /* DOS 3.1-3.3 */
      struct{
	OFFSET	special_names;	/* always 0 for DOS 5.0			*/
	  union{ struct{
	CVFP	IFS_default,	/* default handler for any IFS		*/
		IFS_chain;
	    } DOS4;
	    struct{
	CVFP	setver_list;	/* pointer to SETVER program list or 0	*/
	OFFSET	A20_fix;	/* [DOS=HIGH] offset of A20 fix code	*/
	SEGMENT	last_PSP;	/* PSP of last EXECed program if DOS	*/
				/*  in HMA, 0=low			*/
	    } DOS5;
	  } u;
	word	buffers,	/* x from CONFIG.SYS BUFFERS=x,y	*/
				/*  (rounded up to 30x if in EMS)	*/
		ahead;		/* y from CONFIG.SYS BUFFERS=x,y	*/
	byte	boot_drive;	/* 1=A:					*/
	byte	DWORD_moves;	/* 1=use DWORD moves (80386+)		*/
	word	ext_mem_K;	/* extended memory size in Kb		*/
      } DOS4; /* DOS 4.0+ */
    } x; /* DOS 3.1+ */
    struct{
	byte	unused10[6];
	CVFP	CDS_table;	/* pointer to CDS[lastdrive] array	*/
	byte	unused1A[6];
	byte	drive_count,	/* number of block devices		*/
		lastdrive;	/* number of local deive letters	*/
	DEVICE	NUL_device;	/* NUL device header (first in chain)	*/
    } NT; /* Windows NT DOS Box */
  } u;
} far DOSLoL;	/* offsetof(DOSLoL, DOS2)	  == 0x10-(-2)		*/
		/* sizeof(((DOSLoL*)0)->u.DOS2)   == 0x17+18-0x10	*/
		/* sizeof(((DOSLoL*)0)->u.DOS30)  == 0x28+18-0x10	*/
		/* sizeof(((DOSLoL*)0)->u.x.DOS3) == 0x35-0x10		*/
		/* sizeof(((DOSLoL*)0)->u.x.DOS4) == 0x47-0x35		*/
		/* sizeof(((DOSLoL*)0)->u.x)	  == 0x47-0x10		*/
		/* sizeof(((DOSLoL*)0)->u.NT)	  == 0x34-0x10		*/

#ifdef __TURBOC__
# if sizeof(DOSLoL) != 0x10-(-2)+0x47-0x10
#  error Wrong "DOSLoL" type definition!
# endif
#endif

typedef SYSSTRUCT{
	byte	flag,
		locks;
	dword	offset_K,
		size_K;
} far XMS_BLOCK; /* sizeof(XMS_BLOCK) == 10; for INT2F/4309 */

#ifdef __TURBOC__
# if sizeof(XMS_BLOCK) != 10
#  error Wrong "XMS_BLOCK" type definition!
# endif
#endif

typedef SYSSTRUCT{
	byte	check,
		handle_sz;
	word	handle_cnt;
	XMS_BLOCK *pb;
} far XMS_TABLE; /* sizeof(XMS_TABLE) == 8; for INT2F/4309 */

#ifdef __TURBOC__
# if sizeof(XMS_TABLE) != 8
#  error Wrong "XMS_TABLE" type definition!
# endif
#endif

typedef struct{
	word	handle;
	word	pages;
} EMS_HANDLE;	/* sizeof(EMS_HANDLE) == 4; for INT67/4D */

#ifdef __TURBOC__
# if sizeof(EMS_HANDLE) != 4
#  error Wrong "EMS_HANDLE" type definition!
# endif
#endif

typedef struct{
	SEGMENT	seg;
	word	page;
} EMS_MPA;	/* sizeof(EMS_MPA) == 4; for INT 67/5800 */

#ifdef __TURBOC__
# if sizeof(EMS_MPA) != 4
#  error Wrong "EMS_MPA" type definition!
# endif
#endif

#define FP_MCB(seg)	((MCB*)MK_FP(seg, 0))
#define FP_PSP(seg)	((PSP*)MK_FP(seg, 0))
#define FP_SDMCB(seg)	((SYSDATA_MCB*)MK_FP(seg, 0))
#define FP_DEV(seg,off)	((DEVICE*)MK_FP(seg, off))

#if defined(__MSDOS__) || defined(__WINDOWS__) || defined(__OS2__)
# define SetChar2(p, c1, c2) (*((word*)(p)) = \
				((word)(((byte)(c2) << 8) | (byte)(c1))))
#else
# define SetChar2(p, c1, c2) ((p)[0] = (c1), (p)[1] = (c2))
#endif

#ifdef __TURBOC__
# pragma option -a. /* restore byte alignment */
#endif
