@echo off

@echo off
echo MIRRTREE helper for UNDELETE, mirrors directory metadata of a subtree
echo written by Eric Auer, eric@coli.uni-sb.de, this file is public domain
echo ------

if x%1==x goto help
if x%1==x/? goto help
if x%1==x/h goto help
if x%1==x-h goto help
if x%1==x--help goto help
if x%1==x/help goto help
if x%1==xhelp goto help
if x%1==x/H goto help
if x%1==x? goto help

which /? > nul
if x%ERRORLEVEL%==x echo I need FreeCOM command.com 0.83 beta 50 or newer
if x%ERRORLEVEL%==x goto help

which undelete
if x%ERRORLEVEL%==x1 echo undelete not found in path
if x%ERRORLEVEL%==x1 goto help
which count
if x%ERRORLEVEL%==x1 echo count not found in path
if x%ERRORLEVEL%==x1 goto help

if not exist %1\nul goto help

rem ****************************

echo ------
echo MIRROR will now save some meta information of the current drive
echo to %1\ - current drive/directory is %_CWD%\.
echo ------

echo Starting MIRROR to %1\ on %_CWD%\ >> %1\mirror.log
date /d >> %1\mirror.log
time /t >> %1\mirror.log

set COUNT=0000
goto check
:incr
rem echo %1\????%COUNT%.bin already exists, counting up...
count > nul
:check
if exist %1\root%COUNT%.bin goto incr
if exist %1\boot%COUNT%.txt goto incr
if exist %1\fat1%COUNT%.bin goto incr
if exist %1\fat2%COUNT%.txt goto incr

echo [undelete syssave boot %1\root%COUNT%.bin]
undelete syssave boot %1\boot%COUNT%.bin >> %1\mirror.log
if x%ERRORLEVEL%==x255 echo UNDELETE reported an error
if x%ERRORLEVEL%==x255 goto :err
echo stored (%ERRORLEVEL%) boot sector in %1\root%COUNT%.bin

echo [undelete syssave root %1\root%COUNT%.bin]
undelete syssave root %1\root%COUNT%.bin >> %1\mirror.log
if x%ERRORLEVEL%==x255 echo UNDELETE reported an error
if x%ERRORLEVEL%==x255 goto :err
echo stored (%ERRORLEVEL%) root directory binary in %1\root%COUNT%.bin

echo [undelete syssave fat1 %1\root%COUNT%.bin]
undelete syssave fat1 %1\fat1%COUNT%.bin >> %1\mirror.log
if x%ERRORLEVEL%==x255 echo UNDELETE reported an error
if x%ERRORLEVEL%==x255 goto :err
echo stored (%ERRORLEVEL%) first FAT copy in %1\fat1%COUNT%.bin

echo [undelete syssave fat2 %1\root%COUNT%.bin]
undelete syssave fat2 %1\fat2%COUNT%.bin >> %1\mirror.log
if x%ERRORLEVEL%==x255 echo UNDELETE reported an error
if x%ERRORLEVEL%==x255 goto :err
echo stored (%ERRORLEVEL%) second FAT copy in %1\fat2%COUNT%.bin

echo ROOT, BOOT, FAT1 and FAT2 all processed. MIRROR done. >>%1\mirror.log

goto leave

rem ****************************

:help
echo MIRROR DRIVE - yet another UNDELETE helper
echo Usage: %0 x:\target
echo ------
echo Will backup some metadata of the CURRENT drive to x:\target\root1234.bin
echo x:\target\boot1234.bin, x:\target\fat11234.bin and x:\target\fat21234.bin
echo and append stuff to a logfile x:\target\mirror.log ...
echo 1234 is a number chosen so that no old files are overwritten.
echo x: may NOT be the current drive, otherwise NOTHING will be backed up.
echo Uses COUNT (public domain) and UNDELETE (GNU) by eric@coli.uni-sb.de.

goto leave

rem ****************************
:err

echo -
echo UNDELETE reported an error: Probably you were trying to mirror
echo a network drive or tried to use the current drive or a not writeable
echo drive/directory as target. Cancelling MIRROR.
echo -

rem ****************************

:leave
