/*
  FreeDOS special UNDELETE tool (and mirror, kind of)
  Copyright (C) 2001, 2002  Eric Auer <eric@CoLi.Uni-SB.DE>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, 
  USA. Or check http://www.gnu.org/licenses/gpl.txt on the internet.
*/


#include "dir16.h"
#include "fatio.h"	/* readfat */

/* if printdirents knows the DPB, it checks un-delete-ability */

void printdirents(Byte * buffer, struct DPB * dpb)
{
  int i,j,state;
  char x;
  Word fatchain, unichar;
  struct dirent * DE;
  char * DEarray;
  int lfnwhere [13] = { 1,3,5,7,9, 14,16,18,20,22,24, 28,30 };

  j = 0;
  for (i=1;i<512;i++) {
    if (buffer[i] == buffer[i-1]) { j++; }
  }
  if (j>500) {
    printf("printdirents: empty sector\n");
    return;
  }

  for (i=0;i<512;i+=32) {
    if (buffer[i] != 0) {
      printf("\n");
      DE = (struct dirent *)(buffer+i);
      if (DE->f_name[0] == D_DELCHAR) {
        if (dpb != (struct DPB *) 0) {
          state = readfat(dpb->drive,DE->cluster,&fatchain,dpb);
          if ((state<0) || (fatchain!=0)) {
            printf("Del/Lost:  ");	/* first cluster reused */
          } else {
            printf("UnDelAble: ");	/* undelete possible */
          }
        } else {
          printf(  "Deleted:   ");	/* deleted, did not check */
        }
      } else {
          if ((DE->f_attrib & D_LONG) == D_LONG) {
            printf("LFNpseudo: ");	/* part of a LFN -> meaning of */
            				/* most fields is void/changed */
          } else {
            printf("           ");	/* normal file */
          }
      }

      for (j=0;j<8;j++) {
        x = DE->f_name[j];
        if (x<32) { x = '?'; }
        if (x>126) { x = '?'; }
        printf("%c",x);
      }
      printf(".");
      for (j=0;j<3;j++) {
        x = DE->f_ext[j];
        if (x<32) { x = '?'; }
        if (x>126) { x = '?'; }
        printf("%c",x);
      }
      printf(" %2.2d:%2.2d:%2.2d",HofTime(DE->f_time),
        MofTime(DE->f_time), SofTime(DE->f_time));
      printf(" %2.2d.%2.2d.%d", DofDate(DE->f_date),
        MofDate(DE->f_date), YofDate(DE->f_date));
      printf(" @%5.5d, size %10.10ld",DE->cluster,DE->f_size);

      if ((DE->f_attrib & D_LONG) == D_LONG) {
        printf(" <LONG>\nPartial name: <");
        /* *** Better LFN display added 11/2002 *** */
        /* See table 01355 of RBIL (intlist) for more. */
        DEarray = (char *)DE;
        for (j=0;j<13;j++) {
          x = DEarray[lfnwhere[j]+1];
          unichar = x;
          x = DEarray[lfnwhere[j]];
          unichar = (unichar << 8) + x;
          if (unichar<32)      { x = '?'; }
          if (unichar>126)     { x = '?'; }
          if (unichar>255)     { x = '*'; }
          if (unichar==0xffff) { x = ' '; }
          printf("%c",x);
        }
        x = DEarray[0];
        printf("> Part=%2.2d (%s,%s) ", x & 0x3f,
               ((x & 0x40) != 0) ? "EOF" : "---",
               ((x & 0x80) != 0) ? "DEL" : "---");
        printf("Shortname checksum=0x%hX", DEarray[0x0d]);
      } else {
        if (DE->f_attrib & D_RO) { printf(" ro"); }
        if (DE->f_attrib & D_HIDE) { printf(" hide"); }
        if (DE->f_attrib & D_SYS) { printf(" sys"); }
        if (DE->f_attrib & D_VOL) { printf(" label"); }
      }
      if (DE->f_attrib & D_DIR) { printf(" dir"); }
      if (DE->f_attrib & D_ARCH) { printf(" a"); }
      if (DE->cluster_hi) {
        if ((DE->f_attrib & D_LONG) != D_LONG)
          printf("Warning: ClusterHI=%x ", DE->cluster_hi);
      }
    } else {
      printf("<eof>");
    }
  }
  printf("\n");
}

