/*
 * LLVID.C - low-level video primitives for bwBASIC/FD
 * Copyright (C) 2003, Stephen V. Nickolas <steve@dosius.zzn.com>
 *
 * This file is part of Bywater BASIC 2.20 for FreeDOS, version 0.01
 * Bywater BASIC for FreeDOS is free software; you may redistribute it
 * and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 */

#include <conio.h>
#include "ll.h"

/* SCREEN() function - default mode to 0 if not supplied */
byte llvid_screen_func (byte y, byte x, byte mode)
{
 int tmp_bp;
 int tmp_si;
 int tmp_di;
 int tmp_x, tmp_y;

 _AH=0x08;
 _BH=0x00; /* page 0; Borland conio doesn't support any other mode */

 tmp_x=wherex();
 tmp_y=wherey();
 gotoxy(x,y);

 /* work around possible BIOS bugs by saving these regs -uso. */
 tmp_bp=_BP;
 tmp_si=_SI;
 tmp_di=_DI;
 geninterrupt(0x10);
 _BP=tmp_bp;
 _SI=tmp_si;
 _DI=tmp_di;

 gotoxy(tmp_x,tmp_y);

 if (!mode) return _AL; /* character */ else return _AH; /* attribute */
}

/* PALETTE command - only for PCjr/Tandy and EGA/VGA */
void llvid_palette (byte col, byte attr)
{
 _AX=0x1000;
 _BL=col;
 _BH=attr;
 geninterrupt(0x10);
}

/* Sets CGA mode 1 palette, for COLOR command.  This is not a complete
   command intrinsic implementation -uso. */
void llvid_cga1_setfg (byte mode)
{
 _AH=0x0B;
 _BH=0x01;
 _BL=mode;
 geninterrupt(0x10);
}

/* PSET() function - default c to no_colors-1 if not supplied */
/* Bonus feature: if the BIOS supports it (it should!) a color value >127
   will XOR the pixel onto the screen (RBIL) -uso. */
void llvid_pset (word x, word y, byte c)
{
 _AH=0x0C;
 _BH=0x00; /* page 0 */
 _CX=x;
 _DX=y;
 _AL=c;
 geninterrupt(0x10);
}

/* And this version for SCREEN 13 */
void llvid_mcga_pset (word x, word y, byte c)
{
 static char far *screen=MK_FP(0xA000, 0x0000);

 if (x<0 || x>319 || y<0 || y>199) return; /* documented -uso. */
 screen[x+(y*320)]=c;
}

/* POINT() function */
byte llvid_point (word x, word y)
{
 _AH=0x0D;
 _BH=0x00; /* page 0 */
 _CX=x;
 _DX=y;
 geninterrupt(0x10);
 return _AL;
}

/* And this version for SCREEN 13 */
byte llvid_mcga_point (word x, word y)
{
 static char far *screen=MK_FP(0xA000, 0x0000);

 if (x<0 || x>319 || y<0 || y>199) return 0; /* off-screen */
 return screen[x+(y*320)];
}
