/*
// Program:  Format
// Version:  0.90
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  main.c
// Module Description:  Main Module
*/

#define MAIN


#include <dir.h>
#include <stdio.h>
#include <ctype.h>			/* (jh) for isalpha, ... */

#include "format.h"
#include "hdisk.h"

#include "getopt.h"			/* (jh) support for getopt */

#include "init.h"
#include "userint.h"
#include "createfs.h"
#include "uformat.h"
#include "btstrct.h"
#include "savefs.h"

/* Check to see if the media is formatted.  */
/* Returns TRUE if formatted and FALSE if it is not formatted. */
char Check_For_Format()
{
/* Code needs added.  We'll set this to TRUE for now. */
  return TRUE;
}

/* Write System Files */
void Write_System_Files()
{
  int sys_found = FALSE;
  char sys[9] = {'s','y','s',' ','x',':',13,0,0};

  /* Check for the sys command. */
  if(NULL!=searchpath("sys.com") ) sys_found = TRUE;
  if(NULL!=searchpath("sys.exe") ) sys_found = TRUE;

  if(sys_found==TRUE)
    {
    /* Issue the command to write system files. */
    sys[4]=param.drive_letter[0];
    printf("\n ");
    system(sys);
    }
  else printf("\n Error:  The SYS command has not been located.\n         System files have not be written to the disk.\n");
}


/*
/////////////////////////////////////////////////////////////////////////////
//  MAIN ROUTINE
/////////////////////////////////////////////////////////////////////////////
*/
void main(int argc, char *argv[])
{
  int ch;
  int index;
  int n;

  int drive_letter_found;

  Initialization();


  /* if FORMAT is typed without any options */

  if (argc == 1)
    {
    Display_Help_Screen();
    exit(1);
    }

  /* (jh) check command line */

  while (  (index = getopt (argc, argv, "V:v:QqUuBbSsYy148F:f:T:t:N:n:/")) != EOF)
    {
      switch(index)
	{
	case 'V':
	case 'v':
	  param.v=TRUE;
	  /* avoid overflow of param.volume_label (12 chars) */
	  /* need to skip over first character (':') */

	  strncpy (param.volume_label, optarg+1, 11);
	  param.volume_label[11] = '\0';

	  for (n = 0; param.volume_label[n] != '\0'; n++)
	    {
	      ch = param.volume_label[n];
	      param.volume_label[n] = toupper (ch);
	    }
	  break;
	case 'Q':
	case 'q':
	  param.q =TRUE;
	  break;
	case 'U':
	case 'u':
	  param.u=TRUE;
	  break;
	case 'B':
	case 'b':
	  param.b=TRUE;
	  break;
	case 'S':
	case 's':
	  param.s=TRUE;
	  break;
	case 'Y':
	case 'y':
	  param.force_yes=TRUE;
	  break;
	case '1':
	  param.one=TRUE;
	  break;
	case '4':
	  param.four=TRUE;
	  break;
	case '8':
	  param.eight=TRUE;
	  break;

	case 'F':           /* /F:size */
	case 'f':           /* /F:size */
	  param.f=TRUE;
	  n = atoi (optarg + 1);

	  if ((n == 160) || (n == 180) || (n == 320) || (n == 360) ||
	      (n == 720) || (n == 1200) || (n == 1440) || (n == 2880))
	    {
	    param.size = n;
	    }
	  else
	    {
	    IllegalArg("/F",optarg);
	    }
	  break;

	case 'T':
	  param.t=TRUE;
	  n = atoi (optarg + 1);

	  if ((n == 40) || (n == 80))
	    {
	    param.cylinders = n;
	    }
	  else
	    {
	    IllegalArg("/T",optarg);
	    }
	  break;

	case 'N':
	  param.n=TRUE;
	  n = atoi (optarg + 1);

	  if ((n == 8) || (n == 9) || (n == 15) || (n == 18) || (n == 36))
	    {
	    param.sectors = n;
	    }
	  else
	    {
	    IllegalArg("/N",optarg);
	    }
	  break;

	case '~':
	  param.drive_letter[0] = toupper (optarg[0]);
	  param.drive_number = param.drive_letter[0] - 'A';
	  param.drive_letter[1] = ':';
	  drive_letter_found = TRUE;
	  break;

	default:
	  Display_Help_Screen();
	  exit(1);
	case '/':			/* Ignore '/' in middle of option */
	  break;
	}       /* switch (index) */
    }         /* for all args (getopt) */


  if ( (argc > optind) && (isalpha (argv[optind][0])) &&
       (argv[optind][1] == ':') && (argv[optind][2] == '\0') &&
       (drive_letter_found == FALSE) )
    {
    param.drive_letter[0] = toupper (argv[optind][0]);
    param.drive_number = param.drive_letter[0] - 'A';
    param.drive_letter[1] = ':';
    }
  else
    if (drive_letter_found == FALSE)
      {
      printf("Required parameter missing -\n");
      exit(1);
      }

  /* (jh) done with parsing command line */

  /*if FORMAT is typed with a drive letter */

  if(debug_prog==TRUE) printf("\n[DEBUG]  Drive To Format->  %s \n\n",param.drive_letter);

  /* Set the type of disk */
  if(param.drive_number>1) param.drive_type=HARD;
  else param.drive_type=FLOPPY;

  /* Ensure that valid switch combinations were entered */
  if( (param.b==TRUE) && (param.s==TRUE) ) Display_Invalid_Combination();
  if( (param.v==TRUE) && (param.eight==TRUE) ) Display_Invalid_Combination();
  if( ( (param.one==TRUE) || (param.four==TRUE) ) && ( (param.f==TRUE) || (param.t==TRUE) || (param.n==TRUE) ) ) Display_Invalid_Combination();
  if( ( (param.t==TRUE) && (param.n!=TRUE) ) || ( (param.n==TRUE) && (param.t!=TRUE) ) ) Display_Invalid_Combination();
  if( (param.f==TRUE) && ( (param.t==TRUE) || (param.n==TRUE) ) )Display_Invalid_Combination();
  if( ( (param.one==TRUE) || (param.four==TRUE) ) && (param.eight==TRUE) )Display_Invalid_Combination();
  if( ( (param.four==TRUE) || (param.eight==TRUE) ) && (param.one==TRUE) )Display_Invalid_Combination();
  if( ( (param.eight==TRUE) || (param.one==TRUE) ) && (param.four==TRUE) )Display_Invalid_Combination();

  /* Make sure that a floppy disk is unconditionally formatted if /f /t */
  /* or /n are selected.                                                */
  if( (param.f==TRUE) || (param.t==TRUE) || (param.n==TRUE) )
    {
    param.u=TRUE;
    param.q=FALSE;
    }

  /* User interaction. */
  if(param.drive_type==FLOPPY && param.force_yes==FALSE)
   Ask_User_To_Insert_Disk();

  if(param.drive_type==HARD && param.force_yes==FALSE)
   Confirm_Hard_Drive_Formatting();

  /* Check to see if the media is currently formatted. */
  param.existing_format=Check_For_Format();

  /* Determine and set media parameters */
  if(param.drive_type==FLOPPY)
    {
    Set_Floppy_Media_Type();
    }
  else
    {
    Set_Hard_Drive_Media_Parameters();
    Enable_Disk_Access();
    }

  /* Format Drive */
  if( (param.u==TRUE) && (param.q==FALSE) )
    {
    /* Unconditional Format */
    Unconditional_Format();
    Create_File_System();
    }

  if( (param.u==FALSE) && (param.q==TRUE) )
    {
    /* Quick Format */
// TEMPORARILY DISABLED FOR FAT32
    if((param.drive_type==HARD) && (param.fat_type!=FAT32)) Save_File_System();
    Create_File_System();
    }

  if( (param.u==TRUE) && (param.q==TRUE) )
    {
    /* Quick Unconditional format */
    printf(" QuickFormatting \n");
    Create_File_System();
    }

  if( (param.u==FALSE) && (param.q==FALSE) )
    {
    /* Safe Format */
// TEMPORARILY DISABLED FOR FAT32
    if((param.drive_type==HARD) && (param.fat_type!=FAT32))Save_File_System();
    Create_File_System();
    }

  if(param.drive_type==HARD) Set_DPB_Access_Flag();

// TEMPORARILY DISABLED FOR FAT32
  if((bad_sector_map[0]>0) && (param.fat_type!=FAT32)) Record_Bad_Clusters();

  printf(" Format complete.          \n");

  if(param.s==TRUE) Write_System_Files();

  Display_Drive_Statistics();

  exit(0);
}

