/*  Express HTML Help

    Copyright (c) Express Software 1998-2002
    All Rights Reserved.

    Created by: Joseph Cosentino.

    Changes to this file
    ====================
    The command-line parser can now be used to display html and text files
    using the /O or /o command. For instance, the license for HTML Help.exe
    can be viewed using:

          help /Olicense

    and

          help /Omyfile
          help /Omyfile.htm
          help /Oc:\foo\myfile
          help /Oc:\foo\myfile.htm

    all would load the files as you expect
    - RP 26th September
*/

/* D E F I N E S ***********************************************************/

/* This directive is here so that only this file will declare certain
 variables in help.h. Other files that include help.h will extern those
 variables. Hence this is defined before including help.h */
#define HTML_HELP

/* Version: Use this to keep the /? command's display of the version up to
            date. Enclose within double-quotes. */
#define HTML_HELP_VERSION "5.1.0 BETA"

/* I N C L U D E S *********************************************************/

/* includes */
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "help_gui.h"
#include "conio.h"
#include "help.h"

/* M A I N   M O D U L E ***************************************************/

int main (int argc, char *argv[])
{
  char *showcommand = 0, *oldscreen;
  int i; /* counter for loop */
  int forcemono = 0;

  get_base_dir (argv[0]);

  for (i = 1; i < argc; i++) {
    if (argv[i][0] == '/') {
      switch (argv[i][1]) {

        default:
        printf ("Invalid argument -- %c\n", argv[i][1]);
        case '?':
        show_usage();             
        return;

        case 'm':
        case 'M':
        forcemono = 1;
        break;

        case 'h':
        case 'H':
        if (argv[i][2] == 0) /* Only put /h or /H */
        {
           show_usage();
           return;
        }
        else
        {
           help_page[0] = '#';
           help_page[1] = 0;
           strcat(help_page, argv[i] + 2);
        }
        break;

        case 'o': /* Specify a file location */
        case 'O':
        strcpy(base_dir, argv[i] + 2);
        if (fclose(fopen(base_dir, "r")) == -1) {
          /* Could not open as a file */
          /* Try with .htm on end */
          strcat(base_dir, ".htm");
          if (fclose(fopen(base_dir, "r")) == -1) {
            /* This simply can't be opened as a file */
            strcpy(home_page, "index.htm");
            strcpy(base_dir, argv[i] + 2);
            /* So treat it as a directory */
            /* Add a \ if necessary, unless it is the current directory */
            if (base_dir[strlen(base_dir)-1] != '\\' && base_dir[0] != 0)
            strcat(base_dir, "\\");
          }
          else
          { /* is a file */
            get_home_page(base_dir);            
            get_base_dir(argv[i] + 2);            
          }
        }
        else
        { /* is a file */
          get_home_page(argv[i] + 2);
          get_base_dir(argv[i] + 2);
        }    
      }
    }
    else {
      if (showcommand == 0) {
	showcommand = malloc (strlen (argv[i]) + 11);
	sprintf (showcommand, "#%s", argv[i]);
      }
      else {
        printf ("Please specify only one topic\n");
        show_usage();
        return;
      }
    }
  }

  conio_init (forcemono);
  if (forcemono == 0)
  {
     oldscreen = malloc(W*H*2);
     if (oldscreen)
        save_window(X, Y, W, H, oldscreen);
  }
  interactive = 1;
  if (MonoOrColor == COLOR_MODE)
  {
        TEXT_COLOR = C_TEXT_COLOR;
        BOLD_COLOR = C_BOLD_COLOR;
        ITALIC_COLOR = C_ITALIC_COLOR;
        BORDER_BOX_COLOR = C_BORDER_COLOR;
        BORDER_TEXT_COLOR = C_BORDER_TEXT_COLOR;
        LINK_COLOR = C_LINK_COLOR;
        LINK_HIGHLIGHTED_COLOR = C_LINK_HIGHLIGHTED_COLOR;
  }
  else
  {
        TEXT_COLOR = M_TEXT_COLOR;
        BOLD_COLOR = M_BOLD_COLOR;
        ITALIC_COLOR = M_ITALIC_COLOR;
        BORDER_BOX_COLOR = M_BORDER_COLOR;
        BORDER_TEXT_COLOR = M_BORDER_TEXT_COLOR;
        LINK_COLOR = M_LINK_COLOR;
        LINK_HIGHLIGHTED_COLOR = M_LINK_HIGHLIGHTED_COLOR;
  }
  show_mouse ();
  move_mouse (80, 25);
  html_view (showcommand);
  free (showcommand);
  hide_mouse ();
  if ((oldscreen != 0) && (forcemono == 0))
  {
     load_window(X, Y, W, H, oldscreen);
     free(oldscreen);
  }
  conio_exit ();

  return;
}

void get_home_page (char *path)
{
  char *p;

  if (path != 0)
    if (path[0] != 0)
    {  
      p = path + strlen(path) - 1;

      while (p != path && *p != '\\' && *p != '/')
        --p;

      if (p[0] == '\\' || p[0] == '/') /* Went a bit too far back */
       ++p;

      strncpy(home_page, p, 12);
      home_page[13] = '\0';
    }
}

void get_base_dir(char *path)
{
    char *p;

    if (path != 0)
      if (path[0] != 0)
      {   
         p=path+strlen(path)-1;
         while (p != path && *p != '\\' && *p != '/')
           p--;

        if (*p == '\\' || *p == '/')
        {
          strncpy(base_dir,path, p-path+1);
          base_dir[p-path+1] = 0;
        }
        else
          base_dir[0]=0;
      }
}

void show_usage (void)
{
     printf ("FreeDOS HTML Help " HTML_HELP_VERSION "\n"
             "Browses the HTML help topics, which describe the FreeDOS commands\n\n"

             "Basic Syntax:    HELP [/?] [/m] [topic]\n\n"

             "  topic            Show help on this topic\n"
             "  /?               Displays this help message\n"
             "  /m               Force monochrome display\n\n\n"

             "Advanced Syntax: HELP [/?] [/m] [/O[pathorfile]] [/Htopic] [topic]\n\n"
             
             "  /O[pathorfile]   Select an external text or help file\n"
             "                    (if no file is specified, it assumes index.htm)\n"
             "  /Htopic          When the user presses f1 or clicks on \"help on help\"\n"
             "                   help will search for this topic. Default topic is 'help'\n"
             );
}

