/*  HTML Stuff

    Copyright (c) Express Software 1998-2002
    All Rights Reserved.

    Created by: Joseph Cosentino.

    21st May 2000 - Forward only keyboard selection of links - BS
    11th Sep 2002 - Changes to improve memory usage, and code clarity - PH
                    (comment by RP: PH's changes solved a problem where
                     recursion crashed the stack)                    
    11th Sep 2002 - Scroll bar area can be used to page up and down - RP
    13th Sep 2002 - & character code support added - PH
    16th Sep 2002 - HTML does not have to be preformatted now - RP
    17th Sep 2002 - Multiple spaces are ignored - as per normal HTML - RP
    25th Sep 2002 - Recursion is no longer used to navigate links. A
                    resizeable array (not a linked list - faster than this)
                    is implemented in pes.c. It allows navigation back
                    and forth - RP.
    23rd Oct 2002 - Dramatically altered, see HISTORY for description of
                    Help 5.0.0B - RP
*/

/* I N C L U D E S ---------------------------------------------------------- */

#include <stdio.h>
#include <string.h>
#include "conio.h"
#include "help.h"
#include "help_htm.h"
#include "help_gui.h"
#include "parse.h"


/* D E F I N E S ------------------------------------------------------------ */

/* Define this to show what scan codes are being used as each key is pressed.
   useful for adding new keyboard functions: */
/* #define SHOW_SCAN_CODES */


/* F U N C T I O N S -------------------------------------------------------- */

int processEvents (struct eventState * pes) {
static struct event ev;
#ifdef SHOW_SCAN_CODES
char showscancode[256];
#endif

    if (pes == 0) return -1;

    if (pes->enable_timer) {
	ev.timer = 1;
	get_event (&ev, EV_KEY | EV_MOUSE | EV_TIMER);
	pes->enable_timer = 0;
    } else {
	get_event (&ev, EV_KEY | EV_MOUSE);
    }

#ifdef SHOW_SCAN_CODES
    if (ev.ev_type == EV_KEY)
    {
      sprintf (showscancode, "key = %i, scan = %x", ev.key, ev.scan);
      show_error(showscancode);
    }
#endif

    /* Tab? */

    if (ev.ev_type == EV_KEY && ev.key == 9)
    {
        if (!pes->clink)
           pes->clink = pes->top;
	pes->clink = strstr (pes->clink, "<a href=");
	if (!pes->clink) {
	    pes->clink = pes->top;
	    pes->clink = strstr (pes->clink, "<a href=");
	}

	if (!pes->clink)
            pes->clink = 0;
	else
	    pes->clink += 8;

        if (pes->clink)
        {
            if (*pes->clink == '\"')
               pes->clink++;

            if (pes->clink - pes->top > pes->bottom - pes->top)
            {
               pes->seek_base = pes->clink;
               pes->seek_cnt = -1;
            }

            pes->force_redraw = 1;
       }
    }

    /* Shift-Tab? - RP */
    if (ev.ev_type == EV_KEY && ev.scan == 0xf00)
    {
        if (pes->clink)
          if (pes->clink-6 >= pes->body_start)
          {
              char tempchar;
              char *newclink, *searchfromhere = pes->body_start;

              tempchar = *(pes->clink-6);
              *(pes->clink-6) = 0;

              while ((newclink = strstr(searchfromhere, "<a href=")) != 0)
                 searchfromhere = newclink+1;

              *(pes->clink-6) = tempchar;

              if (searchfromhere != pes->body_start)
                 pes->clink = searchfromhere;
              else
                 pes->clink = 0;
          }
          else
             pes->clink = 0;

	if (!pes->clink) {
            pes->clink = pes->body_start;
	    pes->clink = strstr (pes->clink, "<a href=");
	}

	if (!pes->clink)
            pes->clink = 0;
	else
	    pes->clink += 8;

        if (pes->clink)
        {
            if (*pes->clink == '\"')
               pes->clink++;

            if (pes->clink < pes->top)
            {
               pes->seek_base = pes->clink;
               pes->seek_cnt = -1;
            }

            pes->force_redraw = 1;
        }
    }

    /* Enter? */

    if (ev.ev_type == EV_KEY && ev.key == 13 && pes->clink) {
	pes->link_text = pes->clink;
	pes->force_redraw = 1;
    }

    /* Escape? */

    if (ev.ev_type == EV_KEY && ev.key == 27)
     return NAVIGATE_BACK;

    /* Some mouse event? */

    if (ev.ev_type & (EV_MOUSE | EV_TIMER)) {
	if (((ev.ev_type & EV_TIMER) || pes->left_was_pressed == 0) && ev.left == 1) {

            if (ev.x >= X+3 && ev.x < X+3+8 && ev.y == H)
                return NAVIGATE_BACK;
            else if (ev.x >= X+17 && ev.x < X+17+15 && ev.y == H)
                return NAVIGATE_FORWARD;
            else if (ev.x >= X+37 && ev.x < X+37+16 && ev.y == H)
                return NAVIGATE_HOME;
            else if (ev.x >= X+LEN-17 && ev.x < X+LEN && ev.y == H)
                return NAVIGATE_HELP;
            else if (ev.x >= X+2 && ev.x < X+2+12 && ev.y == Y)
                return NAVIGATE_EXIT;
            else if (pes->link_under_mouse != 0) {
		pes->p = pes->link_under_mouse;
		if (*pes->p == '\"')
		    pes->p++;
		pes->link_text = pes->p;
	    } else if (ev.x == BARX && ev.y >= BARY-1 && ev.y <= BARY+BARLEN) {
		if (ev.y == BARY-1) { /* Up. */
		    if (pes->top != pes->body_start) {
			pes->seek_base = pes->top;
			pes->seek_cnt = -1;
                        pes->clink = 0;
		    }
		    pes->enable_timer = 1;
		} else if (ev.y == BARY + BARLEN) { /* Down. */
		    if (pes->bottom != pes->body_end) {
			pes->seek_base = pes->top;
			pes->seek_cnt = +1;
                        pes->clink = 0;
		    }
		    pes->enable_timer = 1;
		} else if (ev.y == BARY + pes->barpos) {
			pes->bar_hooked = 1;
		}
		else if (ev.y < BARY + pes->barpos) {
		    /* Page Up with mouse on scroll bar */
		    if (pes->top != pes->body_start) {
			pes->seek_base = pes->top;
			pes->seek_cnt = 1-N;
                        pes->clink = 0;
		    }
		    /* This makes timing too fast: */
		    /* pes->enable_timer = 1; */
		} else {
		    /* Page Down with mouse on scroll bar */
		    if (pes->bottom != pes->body_end) {
			pes->seek_base = pes->top;
			pes->seek_cnt = N-1;
                        pes->clink = 0;
		    }
		    /* This makes timing too fast: */
		    /* pes->enable_timer = 1; */
		} /* end else. */
	    }
	}

	if (ev.x > X+1 && ev.x < X+LEN+2 && ev.y > Y && ev.y < Y+N+1) {
	    pes->check_mouse = 1;
	    pes->mline = ev.y - Y - 1;
	    pes->mpos  = ev.x - X - 2;
	} else {
	    pes->check_mouse = 0;
	    pes->link_under_mouse = 0;
	}

	pes->left_was_pressed = ev.left;
	if (ev.left == 0)
	    pes->bar_hooked = 0;

	if (pes->bar_hooked) {
	    if (ev.y <= BARY)
		pes->forced_barpos = 0;
	    else if (ev.y < BARY + BARLEN)
		pes->forced_barpos = ev.y - BARY;
	    else
		pes->forced_barpos = BARLEN - 1;
	}

    /* Some other keypress? */

    } else if (ev.key == 8 || ev.scan == 0x9B00)
        return NAVIGATE_BACK;
      else if (ev.scan == 0x3000) /* Some users might prefer Alt+B */
        return NAVIGATE_BACK;
      else if (ev.scan == 0x2d00)
        return NAVIGATE_EXIT;
      else if (ev.scan == 0x2e00)
        return NAVIGATE_HOME;
      else if (ev.scan == 0x2100)
        return NAVIGATE_FORWARD;
      else if (ev.scan == 0x3b00)
        return NAVIGATE_HELP;
      else if (ev.scan == 0x47E0 || ev.scan == 0x4700)  /* Home. */
      {
	pes->top = pes->body_start;
        pes->clink = 0;
      }
      else if (ev.scan == 0x48E0 || ev.scan == 0x4800) { /* Up. */
	if (pes->top != pes->body_start) {
	    pes->seek_base = pes->top;
	    pes->seek_cnt  = -1;
            pes->clink = 0;
	}
    } else if (ev.scan == 0x49E0 || ev.scan == 0x4900) { /* PgUp. */
	if (pes->top != pes->body_start) {
	    pes->seek_base = pes->top;
	    pes->seek_cnt  = 1 - N;
            pes->clink = 0;
	}
    } else if (ev.scan == 0x4FE0 || ev.scan == 0x4F00) { /* End. */
	if (pes->bottom != pes->body_end) {
	    pes->seek_base = pes->body_end;
	    pes->seek_cnt  = -N;
            pes->clink = 0;
	}
    } else if (ev.scan == 0x50E0 || ev.scan == 0x5000) { /* Down. */
	if (pes->bottom != pes->body_end) {
	    pes->seek_base = pes->top;
	    pes->seek_cnt  = +1;
            pes->clink = 0;
	}
    } else if (ev.scan == 0x51E0 || ev.scan == 0x5100) { /* PgDn. */
	if (pes->bottom != pes->body_end) {
	    pes->seek_base = pes->top;
	    pes->seek_cnt  = N - 1;
            pes->clink = 0;
	}
    }

    return NAVIGATE_DONT;
}


void displayProcess (struct eventState * pes) {
long i, k, ch, line, len;
char link_started, bold_started, it_started;
char *link_reference;

    if (pes->force_redraw == 1 || pes->check_mouse == 1) {

	pes->p = pes->top;
	k = 0;
	len = 0;
	line = 0;
	link_started = 0;
	pes->link_under_mouse = 0;
	bold_started = 0;
	it_started = 0;

	while (1) {
	    if (*pes->p =='\n' || len == LEN || pes->p == pes->body_end) {
		if (*pes->p != '\n' && pes->p != pes->body_end)
		    while (*pes->p!='\n' && pes->p!=pes->body_end)
			pes->p++;

		if (*pes->p == '\n' && pes->p != pes->body_end)
		    pes->p++;

		while (len != LEN) {
		    pes->tmp[(size_t)len] = ' ';
		    pes->col[(size_t)len] = TEXT_COLOR;
		    len++;
		}

		if (pes->force_redraw == 1) {
		    int j;
		    for (i = 0, j = 0; i < LEN; i++) {
			pes->str[j++] = pes->tmp[i];
			pes->str[j++] = pes->col[i];
		    }
                    load_window (X+2, Y+1+line, LEN, 1, pes->str);
		}

		line++;
		len = 0;
                if (pes->p == pes->body_end || line == N) {
		    if (line != N)
			clear_window (TEXT_COLOR, X+2, Y+1+line, LEN, N-line);

		    break;
		}
		continue;
	    }

	    if (*pes->p == '\r') {
		pes->p++;
		continue;
	    }

	    if (*pes->p =='<' && (pes->p[1]>='A' && pes->p[1]<='Z' || pes->p[1]=='/' || pes->p[1]>='a' && pes->p[1]<='z' || pes->p[1]=='!')) {
                if (link_started == 0 && (pes->p[1] == 'a' || pes->p[1] == 'A'))
                {
                    /* modified for help 5.0.2 so that links without href= in them
                       e.g <A NAME="..."> are not accidentally loaded. - RP */
                    char *closearrow = strchr(pes->p, '>');
                    *closearrow = 0;                       
		    link_reference = strstr(pes->p, "href=");
                    *closearrow = '>';
                    if (link_reference)
                    {
                       link_reference += 5;
                       if (*link_reference =='\"')
                          link_reference++;

                       link_started = 1;
                    }
                } else if (link_started == 1 && strncmp (pes->p, "</a>", 4) == 0) {
		    link_started = 0;
                } else if (bold_started == 0 && strncmp (pes->p, "<b>", 3) == 0) {
		    bold_started = 1;
                } else if (bold_started == 1 && strncmp (pes->p, "</b>", 4) == 0) {
		    bold_started = 0;
                } else if (it_started == 0 && strncmp (pes->p, "<i>", 3) == 0) {
		    it_started = 1;
                } else if (it_started == 1 && strncmp (pes->p, "</i>", 4) == 0) {
		    it_started = 0;
                }

		while (*pes->p != '>' && pes->p != pes->body_end)
		    pes->p++;

		if (*pes->p == '>')
		    pes->p++;
	    }
            else
            {
               /* Translate some &-escape codes. */
               ch = *pes->p;
               if (*pes->p == '&') {
                   ch = ampSubs (pes);
               }
         
               pes->tmp[len] = (ch != '\t') ? ch : ' ';

               pes->col[len] = link_started ? LINK_COLOR : TEXT_COLOR && bold_started ? BOLD_COLOR : TEXT_COLOR && it_started ? ITALIC_COLOR : TEXT_COLOR;
               if (link_started && link_reference == pes->clink)
                   pes->col[len] = LINK_HIGHLIGHTED_COLOR;
          
               if (pes->check_mouse && line == pes->mline && len == pes->mpos && link_started)
                   pes->link_under_mouse = link_reference;

               len++;
               if (ch != '\t' || len % 8 == 0)
                   pes->p++;
            }
	}

	if (pes->force_redraw == 1) {
	    pes->bottom = pes->p;
	    for (i = 0; i < BARLEN; i++) {
                write_char (BORDER_BOX_COLOR,
			    BARX, BARY + i,
                            ((i != pes->barpos) &&
                             (pes->maxtop!=0)) ? 176 : 178); /* modified RP */
            }                                         
            pes->old_top = pes->top;
	    pes->force_redraw = 0;
	}
    }

    /* The following has lines of code in this function were modified
       to show the link selected by the tab key for those users without
       mice - RP */
    if (pes->clink)
       pes->p = pes->clink;

    if (pes->link_under_mouse != 0)
	pes->p = pes->link_under_mouse;

    if (pes->clink || pes->link_under_mouse != 0) {
	k = strchr (pes->p, '\"') - pes->p;
	if (k < 0 || k > LEN - 12)
	    k = LEN - 12;

	sprintf (pes->tmp, "%.*s", (int)k, pes->p);
	if (pes->mesg == 0)
	    pes->mesg = pes->tmp;

    }

    clear_window (TEXT_COLOR, X+2, TY, LEN, 1);
    if (pes->mesg != 0) {
	write_string (TEXT_COLOR, X+2, TY, pes->mesg);
	pes->mesg = 0;
    }
} /* end displayProcess. */


void html_view (const char *target) {
struct eventState *pes = 0;
char *p, *q;
char fullpath[257];
char target_name[257];
char *after_base_dir;
int i;
int pleaseLoad = 1;

    if (pesListInitialise() == FAIL)
      return;

    if (target == 0)
       *target_name = 0;
    else
       strcpy (target_name, target);

    strcpy (fullpath, base_dir);

    while (1) {
      if (pleaseLoad)
      {
        if (*target_name == 0 || *target_name =='#')
        {
            strcpy (fullpath, base_dir);
            after_base_dir = fullpath + strlen (fullpath);
	    strcat (after_base_dir, home_page);
	    q = target_name;

	}
        else
        {
          after_base_dir = fullpath + strlen (fullpath);

	  for (q = target_name, p = after_base_dir;
	       (*q != 0) && (*q != '#'); q++, p++)
	    *p = *q;

	  *p = 0;

	}

	if (pes)
	  if (pes->hidden)
	     pes = pesListBackward();

	/* The following strange combination of an if and a ? is there
	   to compare pes->filename and fullpath, so as not to create the pes
	   if the desired file is already the current page.
           But if pes is 0, then it can't be the current page, and also
           there is nothing to compare. So if pes is 0, we wish to
	   create the pes for sure - hence the ': 1' condition. -RP */
	if (pes ? stricmp(pes->filename, fullpath) : 1)
	{
	/* Attempt to create a new pes in the list */
	if ((pes = pesListAdd(fullpath)) != 0)
	{
	  /* Initialise the pes variables */
	  pes->hidden = 0;
	  pes->old_top = 0;
	  pes->seek_base = 0;
	  pes->forced_barpos = 0;
	  pes->mline = 0;
	  pes->mpos = 0;
	  pes->left_was_pressed = 0;


          tags2lwr(pes->text_buf);
          preformatTrim (pes->text_buf);
          simpleTagSubstitutions (pes, tagSubsTable1);
          headerTagSubstitution (pes);
          simpleTagSubstitutions (pes, tagSubsTable2);
          wordwrap (pes->text_buf);
          sensiblebreaks(pes->text_buf);

          pes->tmp = pes->screen_buf + H*W*2;
	  pes->col = pes->tmp + LEN + 1;
	  pes->str = pes->col + LEN + 1;

	  if ((pes->body_start = strstr (pes->text_buf, "<body>"))== 0
	       || (pes->body_end = strstr (pes->body_start += 6, "</body>")) == 0) {
	  pes->body_start = pes->text_buf;
	  pes->body_end = pes->body_start + strlen (pes->text_buf);
	  }

	  while (*pes->body_start == '\r' || *pes->body_start == '\n')
	    pes->body_start++;

	  if (pes->body_start >= pes->body_end) {
	    pes->body_start = "\nDocument is empty.\n";
	  pes->body_end = pes->body_start + strlen (pes->body_start);
	  }

	  i = N;
	  pes->p = pes->body_end - 1;
	  if (*pes->p == '\n')
	    pes->p--;

	  for (; (pes->p != pes->body_start); pes->p--)
	    if (*pes->p =='\n') {
	      i--;
	      if (i == 0) {
		  pes->p++;
		  break;
	      }
	  }

	  pes->maxtop = pes->p - pes->body_start;
	  pes->mesg = 0;
	  pes->top = pes->body_start;
	  pes->seek_cnt = 0;
	  pes->bar_hooked = 0;
	  pes->check_mouse = 0;
	  pes->force_redraw = 1;
	  pes->enable_timer = 0;
          pes->clink = 0; /* No link selected! make = 0 for autoselect 1st. */

	  pes->first_time = 1;

	  if (pes->maxtop != 0)
	    pes->barpos = ((pes->top - pes->body_start) * BARLEN) / pes->maxtop;
	  else
	    pes->barpos = BARLEN - 1;

	  if (pes->barpos >= BARLEN)
	    pes->barpos = BARLEN - 1;

	}
	else if ((pes = pesListCurrent()) == 0)
	  return;
	}

	if (q != 0)
	   pes->link_text = (*q != 0) ? q : 0;
	else
	   pes->link_text = 0;
      }

      *after_base_dir = 0; /* Truncate fullpath to just base_dir */

      switch (html_view_internal(pes))
      {
	case NAVIGATE_BACK:
        save_window(X, Y, W, H-3, pes->screen_buf);
        if ((pes = pesListBackward()) == 0)
	{
	  pesListDestroy();
	  return;
	}
        load_window (X, Y, W, H-3, pes->screen_buf);
	pleaseLoad = 0;
	break;

        case NAVIGATE_LINK:
        save_window(X, Y, W, H-3, pes->screen_buf);

        if (pes->tmp != 0)
        {
          /* Start the target_name off with the current files' path */
          char *forwardslash, *backwardslash;
	  strcpy(target_name, pes->filename);

	  /* Find the last / or \ and truncate the string */
	  forwardslash = strrchr(target_name, '/');
	  backwardslash = strrchr(target_name, '\\');
	  p = (forwardslash > backwardslash) ? forwardslash : backwardslash;

	  if (p != NULL)
	     *p = 0;
	  else
	     *target_name = 0;

	  /* Clip off directories, if the target goes 'up' the
	     directory tree with ".."s. */
          while ((strncmp(pes->tmp, "..", 2) == 0) &&
                   (p != NULL))
	  {
	     forwardslash = strrchr(target_name, '/');
	     backwardslash = strrchr(target_name, '\\');
	     p = (forwardslash > backwardslash) ?
                  forwardslash : backwardslash;

             /* Cut out the .. by copying backwards */
             if (p != NULL)
             {
                *p = 0;
                /* make sure string isn't just ".." */
                if (strcmp(pes->tmp, ".."))
                {     
                   p = pes->tmp;
                   while (p[3] != 0)
                      *(p++) = p[3];
                }
                else /* treat ".." as "..\index.htm
		    Remeber the .. has been taken into account already. */
                   strcpy(pes->tmp, "index.htm");
             }
          }

	  if (((*(pes->tmp) != '/') || (*(pes->tmp) != '\\'))
		&& (target_name[strlen(target_name)] != '/')
		&& (target_name[strlen(target_name)] != '\\')
		&& *target_name != 0)
	     strcat(target_name, "\\");

	  strcat(target_name, pes->tmp);
	  /* Since the target link is relative to the present link,
             there is no need for the fullpath to contain the base
             directory: */
          *fullpath = 0;
        }
	else
          *target_name = 0;

	pleaseLoad = 1;
	break;

        case NAVIGATE_FORWARD:
        save_window(X, Y, W, H-3, pes->screen_buf);
	if ((pes = pesListForward()) != 0)
          load_window (X, Y, W, H-3, pes->screen_buf);
	else
	  pes = pesListCurrent();
	pleaseLoad = 0;
	break;

	case NAVIGATE_HOME:
        save_window(X, Y, W, H-3, pes->screen_buf);
	*target_name = 0;
	pleaseLoad = 1;
	break;

	case NAVIGATE_HELP:
        save_window(X, Y, W, H-3, pes->screen_buf);
	strcpy(target_name, help_page);
	pleaseLoad = 1;
	break;

	case NAVIGATE_EXIT:
	pesListDestroy();
	return;

	default:
	pleaseLoad = 0;
      }
  }
}


int html_view_internal(struct eventState * pes) {
int i;

    if (pes->link_text != 0)
    {
       clear_window (TEXT_COLOR, X+2, TY, LEN, 1);
       write_string (TEXT_COLOR, X+2, TY, "Searching...");
       if (*pes->link_text == '#')
       {
          sprintf (pes->tmp, "<a name=\"%.*s\"",
                   link_length(pes->link_text+1),
                   pes->link_text+1);
	  pes->p = strstr (pes->body_start, pes->tmp);
          if (pes->p != 0 && pes->p < pes->body_end)
          {
	     while (pes->p != pes->body_start && *pes->p != '\n')
		pes->p--;

	     if (*pes->p == '\n')
		 pes->p++;

	     pes->top = pes->p;
             pes->link_text = 0;
             clear_window (TEXT_COLOR, X+2, TY, LEN, 1);
             return NAVIGATE_DONT;
	  }
          else
          {
             sprintf (pes->tmp, "%.*s",
                      link_length(pes->link_text+1),
                      pes->link_text+1);
             strlwr(pes->tmp);
             do
             {
                pes->p = pes->body_start;
                while ((pes->p = strstr (pes->p, "<a")) != 0)
                {
                  pes->p = strchr (pes->p, '>');
                  if (pes->p)
                  {
                     ++(pes->p);
                     if (strnicmp(pes->p, pes->tmp, strlen(pes->tmp)) == 0)
                     {
                        while (pes->p != pes->body_start &&
                               strncmp(pes->p, "<a", 2))
			  pes->p--;

                        pes->p = strstr(pes->p, "href=");
                        if (pes->p != 0)
                        {
                           pes->p += 6;
                           if (*pes->p == '\"')
                              pes->p++;

                           if (*pes->p == '#')
                              break;

                           if (strncmp (pes->p, "http://", 7) != 0 &&
                               strncmp (pes->p, "ftp://", 6) != 0 &&
                               strncmp (pes->p, "mailto:", 7) != 0)
                           {
                              sprintf (pes->tmp, "%.*s",
                                 link_length(pes->p),
                                 pes->p);

                              pes->link_text = 0;
                              if (pes->first_time)
                                pes->hidden = 1;
                              clear_window (TEXT_COLOR, X+2, TY, LEN, 1);
                              return NAVIGATE_LINK;
                           }
                        }
                     }
                  }
             }
             pes->p = pes->tmp + strlen(pes->tmp) - 1;
             if (*pes->p > 'a')
               --(*pes->p);
             else
                *pes->p = 0;
           }
           while (*(pes->tmp) != 0);
	  }
          clear_window (TEXT_COLOR, X+2, TY, LEN, 1);
          sprintf(pes->tmp, "Could not find topic '%.*s'",
                             link_length(pes->link_text+1),
                             pes->link_text+1);
          show_error(pes->tmp);
          pes->link_text = 0;
          *(pes->tmp) = 0;
	  return NAVIGATE_DONT;
       }
       else {
	  sprintf (pes->tmp, "%.*s", link_length(pes->link_text), pes->p);
          if (strncmp (pes->tmp, "http://", 7) != 0 &&
              strncmp (pes->tmp, "ftp://", 6) != 0 &&
              strncmp (pes->tmp, "mailto:", 7) != 0)
	  {
	     pes->link_text = 0;
             if (pes->first_time)
               pes->hidden = 1;
             clear_window (TEXT_COLOR, X+2, TY, LEN, 1);
	     return NAVIGATE_LINK;
	  }
	}
        pes->link_text = 0;
    }

    if (pes->first_time)
    {
       border_window (BORDER_BOX_COLOR, X, Y, W, H, Border22f);
       border_window (BORDER_BOX_COLOR, X, Y + H - 3, W, 3, Border22if);
       write_char (BORDER_BOX_COLOR, BARX, BARY - 1, '');
       write_char (BORDER_BOX_COLOR, BARX, BARY + BARLEN, '');
       /* Top of screen menu: */
       write_string (BORDER_TEXT_COLOR, X+2, Y,  " Alt+X Exit ");
       /* Bottom of screen menu: */
       write_string (BORDER_TEXT_COLOR, X+3, H,  " \x1B Back ");
       write_string (BORDER_TEXT_COLOR, X+17, H, " Alt+F Forward ");
       write_string (BORDER_TEXT_COLOR, X+37, H, " Alt+C Contents ");
       write_string (BORDER_TEXT_COLOR, X + LEN - 17, H, " F1 Help on Help ");
       save_window(X, Y, W, H, pes->screen_buf);
    }

    pes->first_time = 0;
    if (pes->seek_cnt != 0) {
    if (pes->seek_cnt <= 0) {
       i = -pes->seek_cnt;
       pes->p = pes->seek_base - 1;
           if (*pes->p == '\n')
              pes->p--;

       for (; (pes->p != pes->body_start); pes->p--)
          if (*pes->p == '\n') {
              i--;
	      if (i == 0) {
                  pes->p++;
                  break;
	      }
          }
	  pes->top = pes->p;
       }
       else if (pes->seek_cnt > 0) {
         i = pes->seek_cnt;
	 pes->p = pes->seek_base;
         for (;pes->p != pes->body_end; pes->p++)
             if (*pes->p == '\n') {
		 i--;
                 if (i == 0) {
                    pes->p++;
		    break;
                 }
	     }

             if (pes->p == pes->body_end) {
                pes->seek_base = pes->body_end - 1;
                pes->seek_cnt = -1;
		return NAVIGATE_DONT;
             }

	     pes->top   = pes->p;
         }

         pes->seek_cnt = 0;
     }

     if (pes->maxtop != 0)
         pes->barpos = ((pes->top - pes->body_start) * BARLEN) / pes->maxtop;
     else
	 pes->barpos = BARLEN - 1;
     if (pes->barpos >= BARLEN)
         pes->barpos = BARLEN - 1;

     if (pes->bar_hooked) {
         pes->seek_base = pes->top;
	 if (pes->forced_barpos == 0) {
             pes->top = pes->body_start;
	     pes->barpos = 0;
         } else if (pes->forced_barpos == BARLEN - 1 && pes->barpos != pes->forced_barpos) {
             pes->old_barpos = pes->barpos;
             pes->seek_base = pes->body_end;
             pes->seek_cnt = -N;
	     return NAVIGATE_DONT;
         } else if (pes->forced_barpos < pes->barpos && pes->forced_barpos < pes->old_barpos) {
             pes->old_barpos = pes->barpos;
	     pes->seek_cnt = -1;
             return NAVIGATE_DONT;
         } else if (pes->forced_barpos > pes->barpos && pes->forced_barpos > pes->old_barpos) {
	     pes->old_barpos = pes->barpos;
             pes->seek_cnt = +1;
	     return NAVIGATE_DONT;
         }
     }
  
     pes->old_barpos = pes->barpos;
     if (pes->top != pes->old_top)
         pes->force_redraw = 1;

      /* ------ Display processing ------------------------------------ */
      displayProcess (pes);

      /* ------ Event processing -------------------------------------- */
      return processEvents (pes);
}
