/*  memory management for HTML Help Browser

    Copyright (c) Express Software 2002
    All Rights Reserved.

    This file created by: Robert Platt.
*/

#ifndef PES_H_INCLUDED
#define PES_H_INCLUDED

struct eventState {

    /* -- File ---- */
    char *filename;
    char * text_buf;

    /* -- Event --- */

    long enable_timer;

    char * top;
    char * bottom;
    char * clink; /* BS */

    char * seek_base;
    long seek_cnt;

    char force_redraw;

    char * p;
    char * body_start;
    char * body_end;

    char * link_under_mouse;

    char barpos;
    char forced_barpos;
    char old_barpos;
    char bar_hooked;

    char check_mouse;
    char left_was_pressed;
    char mline;
    char mpos;

    /* --- Display --- */

    char * screen_buf;
    char * tmp;
    char * col;
    char * str;
    char * mesg;

    char * old_top;
    long maxtop;

    /* Process and navigation */
    char * link_text;
    int first_time;
    char hidden;
};

int pesListInitialise(void);
struct eventState * pesListAdd(char *name);
struct eventState * pesListBackward(void);
struct eventState * pesListForward(void);
struct eventState * pesListCurrent(void);
struct eventState * pesResizeCurrentTextbuf(long newSize);
void pesListDestroy(void);

/* Used internally by pes.c: */
void pesListDeleteForwards (void);
int pesListDeleteOldest (void);
void pesDelete (struct eventState *pes);

#define FAIL 1
#define SUCCESS 0

#endif
