#ifndef CHECKS_H_
#define CHECKS_H_

#include "boot\bootchk.h"
#include "dirs\dirschk.h"
#include "fat\fatchks.h"

/* This file is to be included in the main chkdsk file only. */

struct CheckAndFix TheChecks[] =
{
   /* The first label of the FAT does not contain the media descriptor.
      The first label in the FAT is adjusted. */
   {CheckDescriptorInFat, PlaceDescriptorInFat},

   /* The string that gives an indication of the kind of file system
      is wrong, the right string is put in the place. */
   {CheckFSString, CorrectFSString},

   /* FAT contains invalid cluster numbers. Cluster is changed to EOF. */
   {CheckFatLabelValidity, MakeFatLabelsValid},

   /* Wrong valid in entries, the entries are filled with valid data. */
   {CheckDirectoryEntries, FixDirectoryEntries},

   /* Wrong LFN entries, the LFN entries are removed (only the SFN is
      kept). */
   {CheckLFNs, EraseInvalidLFNs},

   /* File's cluster chain contains a loop. The loop is broken. */
   {CheckFilesForLoops, TruncateLoopingFiles},

   /* Directories . and .. in root directory. They are dropped. */
   {RootDirDOTFinder, DropRootDirDOTs},

   /* Duplicate directory entries. They are renamed. */
   {FindDoubleFiles, RenameDoubleFiles},

   /* Directory .. does not point to parent of parent directory. The start
      pointer is adjusted. */
   {CheckDotDotPointer, AdjustDotDotPointer},

   /* Lost clusters, they are converted to files. */
   {FindLostClusters, ConvertLostClustersToFiles},

   /* Cross linked files, all the files get a copy of the cross linked
      clusters. */
   {FindCrossLinkedFiles, SplitCrossLinkedFiles}
};

#define AMOFCHECKS (sizeof(TheChecks)/sizeof(*TheChecks))

#endif