/*
   ChkFClrt.c - first cluster checking.
   Copyright (C) 2002 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/

#include <stdio.h>

#include "fte.h"
#include "..\chkdrvr.h"
#include "..\struct\FstTrMap.h"

static BOOL FirstClusterChecker(RDWRHandle handle,
                                struct DirectoryPosition* pos,
				struct DirectoryEntry* entry,
                                void** structure);
                                
static BOOL InvalidClusterDeleter(RDWRHandle handle,
                                  struct DirectoryPosition* pos,
				  struct DirectoryEntry* entry,
                                  void** structure);

/* Checking */

RETVAL CheckFirstClusters(RDWRHandle handle)
{
   BOOL invalid = FALSE, *pinvalid = &invalid;

   if (!FastWalkDirectoryTree(handle, FirstClusterChecker, (void**) pinvalid))
      return ERROR;

   return (invalid) ? FAILED : SUCCESS;
}

static BOOL FirstClusterChecker(RDWRHandle handle,
                                struct DirectoryPosition* pos,
				struct DirectoryEntry* entry,
                                void** structure)
{
   CLUSTER firstcluster;
   unsigned long labelsinfat;
   
   BOOL *invalid = *((BOOL**) structure);

   pos = pos;

   if (entry->attribute & FA_LABEL) return TRUE;
   if (IsLFNEntry(entry))           return TRUE;
   if (IsDeletedLabel(*entry))      return TRUE;

   firstcluster = GetFirstCluster(entry);

   labelsinfat = GetLabelsInFat(handle);

   if (((firstcluster < 2)                    ||
	(firstcluster >= labelsinfat)) &&
       (!((firstcluster == 0) &&
		  (IsPreviousDir(*entry) || entry->filesize == 0))))
   {
      printf("An entry has been found with an invalid first cluster\n");
      *invalid = TRUE;
   }

   return TRUE;
}

/* Fixing */

RETVAL DeleteInvalidFirstClusters(RDWRHandle handle)
{
   return (FastWalkDirectoryTree(handle, InvalidClusterDeleter, NULL)) ?
          SUCCESS : ERROR;
}

static BOOL InvalidClusterDeleter(RDWRHandle handle,
                                  struct DirectoryPosition* pos,
				  struct DirectoryEntry* entry,
                                  void** structure)
{
   CLUSTER firstcluster;
   unsigned long labelsinfat;
   
   structure = structure;

   if (!GetDirectory(handle, pos, entry))
      return FAIL;

   if (entry->attribute & FA_LABEL) return TRUE;
   if (IsLFNEntry(entry))           return TRUE;
   if (IsDeletedLabel(*entry))      return TRUE;

   firstcluster = GetFirstCluster(entry);

   labelsinfat = GetLabelsInFat(handle);

   if (((firstcluster < 2)                    ||
	(firstcluster >= labelsinfat)) &&
       (!((firstcluster == 0) &&
		  (IsPreviousDir(*entry) || entry->filesize == 0))))
   {
      MarkEntryAsDeleted(*entry);
      printf("An entry has been found with an invalid first cluster\n");
      if (!WriteDirectory(handle, pos, entry))
         return FAIL;
   }

   return TRUE;
}

