/*
   dirs0.c - directory size checking.
   Copyright (C) 2002 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/

#include <stdio.h>

#include "fte.h"
#include "..\chkdrvr.h"
#include "..\struct\FstTrMap.h"

static BOOL Non0Finder(RDWRHandle handle, struct DirectoryPosition* pos,
		       struct DirectoryEntry* entry, void** structure);

static BOOL DirSizeTo0Setter(RDWRHandle handle, struct DirectoryPosition* pos,
			     struct DirectoryEntry* entry, void** structure);

/* Checking */

RETVAL FindNon0Dirs(RDWRHandle handle)
{
     BOOL invalid = FALSE, *pinvalid = &invalid;

     if (!FastWalkDirectoryTree(handle, Non0Finder, (void**) &pinvalid))
        return ERROR;

     return (invalid) ? FAILED : SUCCESS;
}

static BOOL Non0Finder(RDWRHandle handle, struct DirectoryPosition* pos,
		       struct DirectoryEntry* entry, void** structure)
{
     BOOL *invalid = *((BOOL**) structure);

     handle = handle, pos = pos;

     if (IsLFNEntry(entry))
	return TRUE;

     if ((entry->attribute & FA_DIREC) && (entry->filesize != 0))
     {
        printf("A directory has been found with a non zero length\n");
        *invalid = TRUE;
     }
     
     return TRUE;
}

/* Fixing */

RETVAL SetDirSizeTo0(RDWRHandle handle)
{
    return (FastWalkDirectoryTree(handle, DirSizeTo0Setter, NULL)) ?
           SUCCESS : ERROR;
}

static BOOL DirSizeTo0Setter(RDWRHandle handle, struct DirectoryPosition* pos,
			     struct DirectoryEntry* entry, void** structure)
{
     structure = structure;

     if (IsLFNEntry(entry))
	return TRUE;

     if ((entry->attribute & FA_DIREC) && (entry->filesize != 0))
     {
        printf("A directory has been found with a non zero length\n");
        entry->filesize = 0;
        if (!WriteDirectory(handle, pos, entry))
           return FAIL;
     }
     
     return TRUE;
}
