/*
   RtDots.c - root dots checking.
   Copyright (C) 2002 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/

#include <stdio.h>

#include "fte.h"
#include "..\chkdrvr.h"
#include "..\struct\FstTrMap.h"

static BOOL DOTFinder(RDWRHandle handle, struct DirectoryPosition* pos,
                      void** structure);
static BOOL RootDirDropper(RDWRHandle handle,
                           struct DirectoryPosition* pos,
                           void** structure);

/* Checking */

RETVAL RootDirDOTFinder(RDWRHandle handle)
{
    BOOL invalid = FALSE, *pinvalid = &invalid;

    if (!TraverseRootDir(handle, DOTFinder, (void**)&pinvalid, TRUE))
       return ERROR;

    return (invalid) ? FAILED : SUCCESS;
}

static BOOL DOTFinder(RDWRHandle handle, struct DirectoryPosition* pos,
                      void** structure)
{
    BOOL *invalid = *((BOOL**) structure);
    struct DirectoryEntry entry;

    if (!GetDirectory(handle, pos, &entry))
       return FAIL;

    if (IsCurrentDir(entry))
    {
       printf(". found in root directory");
       *invalid = TRUE;
    }

    if (IsPreviousDir(entry))
    {
       printf(".. found in root directory");
       *invalid = TRUE;
    }
    
    return TRUE;
}

/* Fixing */

RETVAL DropRootDirDOTs(RDWRHandle handle)
{
    return (TraverseRootDir(handle, RootDirDropper, NULL, TRUE)) ?
           SUCCESS : ERROR;
}

static BOOL RootDirDropper(RDWRHandle handle,
                           struct DirectoryPosition* pos,
                           void** structure)
{
    struct DirectoryEntry entry;

    structure = structure;

    if (!GetDirectory(handle, pos, &entry))
       return FAIL;

    if (IsCurrentDir(entry))
    {
       printf(". found in root directory");
       MarkEntryAsDeleted(entry);
       if (!WriteDirectory(handle, pos, &entry))
          return FAIL;
    }

    if (IsPreviousDir(entry))
    {
       printf(".. found in root directory");
       MarkEntryAsDeleted(entry);
       if (!WriteDirectory(handle, pos, &entry))
          return FAIL;
    }
    
    return TRUE;
}
