/***
*data.c - text data
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Place for major text.
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
******************************************************************************/

/*
   Versions:

   1.5   02-Jul-1998    updated signon text
   1.4   07-Mar-1997    change dir command change
   1.3   21-Feb-1997    command_text2[] rewrite
   1.2   16-Sep-1994    CUG reference
   1.1   04-Sep-1994    '\' and '^F' descriptions

   Release Notes:

   Just a more common place...

   Programming Notes:

   There's a function somewhere to display these.

*/

/* NO globals referenced here */

/* ALL definitions here ARE global */

#include <stdio.h>            /* NULL */

char *com_line_text[] = {
"\nDISKED [-|+hft] [/f{text}] [/s{B|F|n|file}] [/5] [d:]\n",
"options: - off  + on",
"\t  h home",
"\t  f files",
"\t  t translate\n",
"\t  /f{text} find text",
"\t  /s{B|F|n|file} set to BOOT, FAT, sector n, or file",
"\t  /5 screen is 50 lines",
"\t  d: drive",
NULL
};

char *signon_text[] = {
"\n                                   DISKED",
"                              The DISK EDitor\n",
"          This program is still being improved and feedback from",
"     users is extremely essential. Anyone sending me their name and",
"     address will get notices of updates and support.\n",
"          The source code for this program is freely available; see",
"     the file SOURCE.TXT for more information.\n",
"          NOTE: It is okay to give this program away.\n",
"          ALSO: Please read the documentation that should come with",
"     this program for distribution and modification information.  If",
"     the documentation is missing, please write me for a copy.\n",
"          AND: This version LETS YOU WRITE to the disk.  NO WARRANTY",
"     is made, expressed or implied.\n",
"          See DISKED.TXT for how to get rid of this message.\n",
"          THANK YOU",
"                     http://www.diskwarez.com/disked.htm\n",
   NULL
};


char *command_text1[] = {
" Commands:\n",
"         Drive:                  Movement:                 File Buffer:",
"    'ld' log disk d          'n' next sector           'a' append sector",
"    '^L' re-log drive        'b' back sector           'u' unappend sector",
"    'fs' find string s       'h' next head             'A' append cluster",
"     BS  display stats       'N' next cluster          'U' unappend cluster",
"                             'B' back cluster        '^An' append n bytes",
"         Sector Buffer:     '^N' next track          '^Un' unappend n bytes",
"    'cn' change from n      '^B' back track           'gn' get n sectors",
"    '^D' change as dir  'sn,n,n' set position        '^Gn' get n sectors & move",
"     'k' kill changes       'Sn' set to cluster n     'dn' display from n",
"     '<' store             '^Sn' set to sector n      'vn' view from n",
"     '>' retrieve            'r' range                 'e' empty",
"     'w' write             HOME  home                 '^E' empty no ask",
"  SPACE  display top        END  end                  'ps' put to file s",
"     CR  display rest      F10s  goto file s         '^Ps' put no options",
"    'tn' tag sector        ^END  end of file          'is' insert file s",
"   '1-9' goto tag         ^HOME  start of file       '^Is' insert no options",
"                         ^RIGHT  next file cluster     'I' insert current file",
"     'q' quit             ^LEFT  back file cluster    'Cn' change from n",
"     '?' more commands      '^Q' go back              'Fs' find string s",
   NULL
};

char *command_text2[] = {
" More Commands:\n",
"         Drive:                  Sector Buffer:            File Buffer:",
"     '\\' find ignore case    F5  re-read sector        F6  append w/strip",
"  '^Fsn' find s @ offset n  SF1  display partial       F7  append w/convert",
"'Pn,n,s' put sectors to s   SF2  display full          F8  append w/mask",
"     F1  directory          SF3  display ascii         F9  append w/options",
"     F2  list files         SF4  display dir          '^\\' find ignore case",
"     F3  number of files   SF8s  dump to file s      SF7s  dump to file s",
"    F4s  change directory   '^V' view",
"                                                           Movement:",
"     'x' view INI file           Files:                'H' start sector",
"     'z' set keywords       '^T' track file           '+n' plus n sectors",
"     'Z' display keywords    'm' map file             '-n' minus n sectors",
"     ',' toggle radix        'M' map free space    SRIGHT  next free cluster",
"     '!' shell to DOS                               SLEFT  back free cluster",
"     ''' display parameters",
"Alt-F10  extra help",
   NULL
};

char *keywords_help[] = {
"\n\nKeyword      Change Key    Action if ON",
"",
"ascii        (Alt-A)       display sector contents as ASCII",
"display      (Alt-D)       display command information",
"files        (Alt-F)       index files when logging in a disk",
"get          (Alt-G)       move after getting sectors",
"heapcheck    (Alt-K)       perform C library heap checking",
"home         (Alt-H)       set to root sector when logging in a disk",
"ignorecase   (Alt-I)       ignore case during finds",
"logical      (Alt-L)       do not display physical sector position",
"partial      (Alt-P)       display first 128 bytes of sector contents",
"translate    (Alt-T)       display directory sectors in directory format",
"verify       (Alt-V)       confirm most commands",
"write        (Alt-W)       enable sector writing",
"Debug        (Alt-Z)       display debugging information for errors",
NULL
};

char *translate_help[] = {
"\n\nTranslate    Toggle Key    Values",
"",
"bufmask      (Alt-M)       mask non-ascii characters in file I/O",
"                           0 = no translations",
"                           1 = ignore non-ASCII",
"                           2 = mask off hi-bit",
"                           3 = convert non-ASCII <XX>",
"",
"filter       (Alt-E)       mask non-ascii characters in dumps",
"                           0 = display all charcaters",
"                           1 = display all characters except control characters",
"                           2 = display only ASCII charcaters",
NULL
};

char *io_help[]= {
"\n\nConsole I/O                Values",
"",
"term                       terminal type",
"                           0 = standard I/O",
"                           1 = BDOS",
"                           2 = BIOS",
"                           3 = BIOS w/ extended keyboard",
"",
"radix                      default numerical display and input",
"                           10 = decimal",
"                           16 = hexadecimal",
"",
"DISK I/O                   Action if non-zero",
"",
"ioctl                      read floppy disks with DOS IOCTL",
"int13                      read floppy disks with BIOS INT 13h",
"nopartitions               read hard drives with BIOS INT 13h",
"dskretrychan               retry \"disk changed\" errors",
"dskretries                 number of times to retry sector I/O failures",
NULL
};

char *dir_help[] = {
   "\n\n\tDirectory Entry:\n",
   "\t00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F",
   "\t|     filename         |  ext   |at| reserved |",
   "\n\t10 11 12 13 14 15 16 17 18 19 1A 1B 1C 1D 1E 1F",
   "\t|    reserved    |time |date |start|file size |\n",
   "\tnote: DRDOS uses the reserved area for deleted",
   "\t      file first char and password info.",
   NULL
};


char *debug_h[] = {
"\n\n'h'\tDisplays current memory status:",
"\n\tHeap: near heap size, largest near block.",
"\tAlloc/Free calls: huge,far,near/huge,far,near.",
"\tUsed/Free blocks: far/near.",
"\nNote:\tThe number of blocks may differ from the",
"\tnumber of calls due to the C libary's internal",
"\tmemory management which DISKED is unable to track.",
NULL
};

char *debug_d[] = {
"\n\n'h'\tDisplays current heap status, for example:",
"\nFar Heap:",
"\tUSED block at 329f:0026 of size 65026",
"\tFREE block at 329f:fe28 of size 468",
"\tUSED block at 42a0:0016 of size 514",
"\tStatus: end of heap",
#ifndef __BORLANDC__
"\nNear Heap:",
"\tUSED block at 229e:3db6 of size 12",
"\tFREE block at 229e:3f66 of size 49302",
"\tStatus: end of heap",
#endif
"\nStatus is one of:",
"\tempty heap, heap is fine, bad start of heap",
"\tbad node in heap, tend of heap, bad pointer to heap",
"\tbad heap",
"\nnormal the status is \"end of heap\"",
NULL
};
