/***
*int24.c -  DOS INT 24h (critical error) handler
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Versions:

   1.0   28-Nov-1997    created (moved from SETUP.c)

   Release Notes:

   Seperate the hardware, OS specifics!

   Programming Notes:

   Handler to deal with hard error codes. Since DOS is not reentrant,
   it is not safe to use most DOS calls for doing I/O within the DOS
   Critical Error Handler used by _harderr. What can be called:

      functions: 01-0c, 3300, 3301, 3305, 3306, 50, 51, 62 and 59

   The BIOS can be used of course.

   But the easiest way to handle critical errors is by making DOS
   fail the function call and have all functions check for and handle
   errors themselves. Duh!

   I just set the error structure data. The reason is that without
   this information, DOS (or the RTL function) may return an error
   value that is not extact. For example, a "disk not ready" error
   may cause an RTL function to return "file not found".

   P.S. I was tesing longjmp() and it worked fine in this handler.

*/

#include <stdio.h>
#include <dos.h>

#include "general.h"       /* UINT16 */
#include "error.h"         /* error */

const char *harderr_list[] = {
   "Disk is write-protected",
   "Unknown unit",
   "Drive not ready",
   "Unknown command",
   "CRC error in data",
   "Bad drive-request structure length",
   "Seek error",
   "Unknown media type",
   "Sector not found",
   "Printer out of paper",
   "Write fault",
   "Read fault",
   "General failure",
   "Sharing violation",
   "Lock violation",
   "Invalid disk change",
   "FCB unavailable",
   "Sharing buffer overflow",
   "Code page mismatch",
   "Out of input",
   "Insufficient disk space",
};


#if defined (_MSC_VER) && (_MSC_VER > 600)
#pragma warning (disable:4100)               /* unref params */
#endif

/***
*hhandler   -  INT 24 handler
*
* Called with AH:    bit 0 operation
*                             1 = write operation, 0 = read operation
*                        2-1 disk area of error
*                             00 = DOS area  01 = FAT
*                             10 = root dir  11 = data area
*                        3 fail allowed (DOS 3.0+)
*                        4 retry allowed (DOS 3.0+)
*                        5 ignore allowed (DOS 3.0+)
*                        6 reserved
*                        7 device type
*                             0 = block device
*                             1 = character device
*                                 or bad FAT image in memory if block device
*                                 indicated in device header attribute (see
*                                 BP:SI below)
*
*             AL:    drive number if block device
*
*             DI:    error code in low byte
*
*             BP:SI: pointer to device header
*
*  The device header would be:
*
*  struct {
*     UINT32 next;      // link to next device header (offset) or FFFFh
*     UINT16 attr;      // device attributes
*     UINT16 strat;     // strategy routine offset
*     UINT16 inter;     // interrupt routine offset
*     char namuni[8];   // name (char device), number of units (block device)
* };
*
*  Bit 15 of the device attributes is 0 for block device and 1 for
*  character device.
*
***/

extern int __far hhandler(UINT16 _ax, UINT16 _di, void __far *bpsi)
{
   _di &= 0xFF;
   if (_di <= 20)
      error.msg = harderr_list[_di];
   error.num = _di;
   error.mod = "harderr";
   return _HARDERR_FAIL;
}
