/*
 * ioctl.c     perform (some) DOS IOCTL calls with DJGPP
 *
 *	Copyright (C) 1998, Gregg Jennings
 *
 */

#include <stdlib.h>

#include "gcc_dpmi.h"
#include "dosio.h"

extern int exterror(void);

/*
 * dos_ioctl      perform DOS IOCTL call (INT 21h/440Dh)
 *
 */

extern int dosioctl(DOS_SUBFUNCTION func, DOS_MINOR_CODE code, int dev,
                    void *data)
{
static int seg = -1;
static int sel;
#define iobufsz 1024
__dpmi_regs regs;
int size = 0;

   /* get a block of memory, large enough for our needs, and use
      it for all subsequent calls */

   if (seg == -1 && (seg = dosmalloc(iobufsz,&sel)) == -1)
      abort();

   regs.x.ax = 0x4400 + func;
   regs.x.bx = dev;
   if (code != DOS_MINOR_NONE)
      regs.x.cx = 0x0800 + code;

   if (data)
   {
      switch (code) {
         case DOS_MINOR_GET_DEVICE:
            size = sizeof(struct _DPB);
            break;
         case DOS_MINOR_GET_MEDIA:
			size = sizeof(struct _MID);
            break;
         default:
            return 0;
            break;
      }
      if (size > iobufsz)
         return 0;
      regs.x.ds = seg;
      regs.x.dx = 0;
   }

   __dpmi_int(0x21,&regs);

   if (regs.x.flags & 1)
      return exterror();

   if (data) {
      if (size == 0)
         return 0;
      getdosmem(data,size,sel);
   }

   /* handle special cases */

   if (func == DOS_DEV_REMOVE)
      return regs.x.ax;

   if (func == DOS_DRV_REMOTE)
      return regs.x.dx;

   return 0;
}
