/***
*search.c - search functions
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Search disk for text.
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Versions:

   1.2   20-Feb-1997    fixed disk search buffer position display of
                        found text
   1.1   12-Sep-1996    "%r"
   1.0   18-Mar-1995    moved find() here from DISKLIB
   0.2   04-Sep-1994    removed some Output tests
   0.1   29-Mar-1994    Removed search backwards
   0.0   13-Mar-1994    Finds over sector boundries.

   Release Notes:

   Files get big... You create new modules...

   Programming Notes:

   Very ugly stuff. I swear that sometimes this stuff doesn't work,
   but when I try and double check it, it always does...

*/

#include <stdio.h>
#include <ctype.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <malloc.h>
#include <errno.h>

#include "disked.h"
#include "mylib.h"
#include "alloc.h"
#include "diskio.h"
#include "error.h"
#include "console.h"


/* globals defined here */

char findstr[SEARCH+1];          /* string to search disk for */
char tmpfstr[SEARCH+1];          /* plus a bunch extra */
unsigned int findlen=0;


/* globals referenced here

   data_buf, byte_cnt, Radix, Display, Debug
*/


/* static data */

/* static functions */

static int buf_search(BYTE *buf, unsigned int bufcnt, BYTE *str, int strcnt, \
                      int (func(BYTE*,BYTE*,UINT,UINT)));
static int dsk_search(BYTE *str, int strcnt, \
                      int (func(BYTE*,BYTE*,UINT,UINT)));
static int disk_search(BYTE *str, int strcnt, int ofs, \
                      int (func(BYTE*,BYTE*,UINT,UINT)));

/*
   Search for an ascii string (converted by convert()) on the disk,
   sector by sector, or in file buffer.

   findstr holds the "converted" string, tmpfstr holds the original string

   2.1   13-Mar-1994    sub-functions
   2.0   10-93          added case test

   returns: ERROR (-1) on error, stopped, or not found
            ABORT (-2) on user cancelled
            or the byte position of the string

   NOTE: 04-Sep-1994, I don't remember why I have the get argument...

   NOTE: 18-Jan-1998, and why I put in the offset...

         my god, I'm getting senile
*/

extern int find(int buf, int get, int kase)
{
int i;
unsigned ofs;                     /* return value, offset */
char str[SEARCH+1];              /* 4 times max string length */

   i = -1;
   str[0] = '\0';

   if (get)
   {
      if (getstr(str,SEARCH,_TEXT) == ABORT) /* get string */
         return(ABORT);                      /* return on ESC or ^C */
      if (str[0] == '\0' && findlen == 0)    /* is no string to search for */
         return(ABORT);                      /* then return ABORT */
      if (str[0])                            /* save the string in tempstr */
      {
         strcpy(findstr,str);                /* to search for the same string */
         strcpy(tmpfstr,str);                /* tmpfstr holds the un-converted */
         findlen = convert(findstr);         /* convert if needed */
      }
      else
         print(tmpfstr);
   }
   else
   {
      strcpy(tmpfstr,findstr);               /* tmpfstr holds the un-converted */
      findlen=convert(findstr);              /* convert if needed */
   }

   if (kase == 2)
   {
      ofs = 0;
      print(", offset ");
      if (getnumb(sec_size,&ofs) == ABORT)
         return ABORT;
      if (ofs > sec_size - findlen)
         return ABORT;
   }
   output(' ');

   if (buf == 0)                             /* search buffer */
   {
      if (byte_cnt < findlen)
         return ERROR;

      return buf_search(data_buf,byte_cnt,(BYTE *)findstr,findlen,
                        (kase) ? isearch : search);
   }

   if (Display)
      output('+');

   if (kase == 2)
   {
      i = disk_search((BYTE *)findstr, findlen, ofs, search);
      if (i != -1)
         i = ofs;
   }
   else
      i = dsk_search((BYTE *)findstr,findlen, (kase) ? isearch : search);

   if (Display)
   {
      output(8);
      clreol();
   }
   if (i == -1)
      print(" not found");

   return i;
}


/***
*  Buffer search
*
*  Search buffer for string (non nul-terminated); displays
*  all index number of matches.
*
****/

static int buf_search(BYTE *buf, unsigned int bufcnt, BYTE *str, int strcnt,
                        int (func(BYTE*,BYTE*,UINT,UINT)))
{
register UINT i;
register int j,k = -1;

   for (i = 0, j = 0; j >= 0 && i < bufcnt; i += (j+strcnt))
   {
      if ((j = func(buf+i,str,bufcnt-i,strcnt)) >= 0)
      {
         print(" %R ",j+i);
         k++;
         if (_kbhit())
            return ABORT;
      }
   }
   return k;
}

/***
*  Disk search
*
****/

/*
   Search disk, combining the sectors to catch strings accross
   sector boundries.

   algorithm:

  Ŀ
                             allocate sec_size
                                      + strcnt bytes for
                                      search buffer
                               
  
  

   v1.0  20-Feb-1997 fixed offest calculation after first sector

*/

static int dsk_search(BYTE *str, int strcnt, int (func(BYTE*,BYTE*,UINT,UINT)))
{
unsigned long ntimes;
register int io,i;
BYTE *xbuf,*lxbuf;
int bcnt,first;

   if ((xbuf = (BYTE *)alloc(1,sec_size+strcnt)) == NULL)
      return -1;

   i = -1;
   io = 0;
   ntimes = 0L;
   bcnt = sec_size - strcnt;
   first = 1;

   for (;;)
   {
      if (Display)
         put(print("%lr",ntimes),'\b');

      if ((io = diskio(DISK_INC,1L,xbuf+strcnt)) != DISK_OK)
      {
         if (Display)
            output('\b');           /* erase '+' displayed by caller */

         printerror(Debug);
         if (io == DOS_ENREADY && !getver("continue",CLR_ARG))
         {
            put(2,'\b');            /* move cursor back */
            break;
         }
         if (Display)
            output('+');            /* put '+' back */
      }

      if (first)
         i = func(lxbuf=xbuf+strcnt,str,sec_size-strcnt,strcnt);
      else
         i = func(lxbuf=xbuf,str,sec_size,strcnt);

      if (i != -1)                              /* found? */
      {
         if (first)
            break;
         if (i < strcnt)                        /* found at end of previous */
         {                                      /*  sector */
            movesector(-1);
            i = sec_size - (strcnt - i);
         }
         else if (i >= strcnt)                  /* found in current sector */
         {
            i -= strcnt;
         }
         break;
      }

      if (first) first = 0;

      if (++ntimes >= num_sectors)
      {
         if (Display)
            output(8);
         break;
      }
      /* copy end of sector */
      memcpy(xbuf,xbuf+bcnt+strcnt,strcnt);

      /* check for abort */
      if (_kbhit())
         break;
   }
   freep(xbuf);
   return i;
}

static int disk_search(BYTE *str, int strcnt, int ofs,
                        int (func(BYTE*,BYTE*,UINT,UINT)))
{
unsigned long ntimes;
register int io,i;
BYTE *xbuf;

   if ((xbuf = (BYTE *)alloc(1,sec_size)) == NULL)
      return -1;

   i = -1;
   io = 0;
   ntimes = 0L;

   for (;;)
   {
      if (Display)
         put(print("%lr",ntimes),'\b');

      if ((io = diskio(DISK_INC,1L,xbuf)) != DISK_OK)
      {
         if (Display)
            output('\b');           /* erase '+' displayed by caller */

         printerror(Debug);
         if (io == DOS_ENREADY && !getver("continue",CLR_ARG))
         {
            put(2,'\b');            /* move cursor back */
            break;
         }
         if (Display)
            output('+');            /* put '+' back */
      }

      i = func(xbuf+ofs,str,strcnt,strcnt);

      if (i != -1)                              /* found? */
         break;

      if (++ntimes >= num_sectors)
      {
         if (Display)
            output(8);
         break;
      }

      /* check for abort */
      if (_kbhit())
         break;
   }
   freep(xbuf);
   return i;
}
