/*
 * ERROR.C -- Error reporting functions
 *
 * 07/12/98 (Rob Lake) ------------------------------------------------------
 *      started
 *
 */

#include "command.h"
#include <stdio.h>

void 
invalid_switch(char c)
{
  fprintf(stderr, INVALID_SWITCH, c);
}

void 
too_many_parameters(char *s)
{
  fprintf(stderr, TOO_MANY_PARAMETERS, s);
}

void 
path_not_found(void)
{
  fprintf(stderr, PATH_NOT_FOUND);
}

void 
file_not_found(void)
{
  fprintf(stderr, FILE_NOT_FOUND);
  //fprintf(stderr, "\n");
}

void 
sfile_not_found(char *f)
{
  file_not_found();
  fprintf(stderr, " - %s\n", f);
}

void 
req_param_missing(void)
{
  fprintf(stderr, REQ_PARAM_MISSING);
}

void 
invalid_drive(void)
{
  fprintf(stderr, INVALID_DRIVE);
}

void 
badcommand(void)
{
  fprintf(stderr, BADCOMMAND);
}

void 
no_pipe(void)
{
  fprintf(stderr, CANNOTPIPE);
}
