/*
 * VER.C
 */

#include "command.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>

/*
 *  display shell version info internal command.
 *
 *
 */
#pragma argsused
int
ver(char *first, char *rest)
{
  int i;

  /* JPP 07/08/1998 clean up and shortened info. */

  printf("\n" SHELLINFO " " SHELLVER ", (C) 1994-1998 Tim Norman\n");
  /* Basic copyright notice */
  if (rest[0] == 0)
  {
    printf("\n"
           "%s comes with ABSOLUTELY NO WARRANTY; for details\n"
           "type: `ver /w'. This is free software, and you are welcome to redistribute\n"
           "it under certain conditions; type `ver /r' for details. Type `ver /c' for a\n"
           "listing of credits.\n"
           "\n", SHELLINFO);
    return 0;
  }

  /* MS-DOS ver prints just help if /? is alone or not */
  if (strstr(rest, "/?") != NULL)
  {
    printf("%s: %s\n", USAGE, VER_HELP);
    return 0;
  }

  for (i = 0; rest[i]; i++)
  {
    /* skip spaces */
    if (rest[i] == ' ')
      continue;
    if (rest[i] == '/')
    {
      /* is this a lone '/' ? */
      if (rest[i + 1] == 0)
      {
        //fprintf(stderr, INVALID_SWITCH, ' ');
        invalid_switch(' ');
        return 1;
      }
      continue;
    }
    if (toupper(rest[i]) == 'W')
    {                           /* Warranty notice */
      /* JPP 07/08/1998 removed extra printf calls */
      puts("\n This program is distributed in the hope that it will be useful,\n"
         " but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
           " MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
           " GNU General Public License for more details.");
    }
    else if (toupper(rest[i]) == 'R')
    {                           /* Redistribution notice */
      /* JPP 07/08/1998 removed extra printf calls */
      puts("\n This program is free software; you can redistribute it and/or modify\n"
           " it under the terms of the GNU General Public License as published by\n"
      " the Free Software Foundation; either version 2 of the License, or\n"
           " (at your option) any later version.");
    }
    else if (toupper(rest[i]) == 'C')
    {                           /* Developer listing */
      /* JPP 07/08/1998 removed extra printf calls; rearranged names */
      puts("\ndeveloped by:\n"
           "    Tim Norman      Matt Rains\n"
           "    Evan Jeffrey    Steffen Kaiser\n"
           "    Svante Frey     Oliver Mueller\n"
           "    Aaron Kaufman   Marc Desrochers\n"
           "    Rob Lake        John P. Price");
    }
    else
    {
      //fprintf(stderr, INVALID_SWITCH, toupper(rest[i]));
      invalid_switch(toupper(rest[i]));
      return 1;
    }
  }
  return 0;
}
