/* A structure to preserve the context of a batch file */

/* HBP_002 { FOR comamnd support */

#include <dir.h>

struct bcontext
{
  struct bcontext *prev;
  FILE *bfile;
  char *forproto;
  char *params;
  struct ffblk *ffind;
  int shiftlevel;
  int echo;                     /* Preserve echo flag across batch calls [HBP_001] */
  char forvar;
};

/* HBP_002 } */

/*  The stack of current batch contexts.
 * NULL when no batch is active
 */
extern struct bcontext *bc;

extern unsigned int echo;       /* The echo flag */

#define BUFFSIZE  512

extern char textline[BUFFSIZE]; /* Buffer for reading Batch file lines */

void exit_batch(char *msg);

/* HBP_002 { FOR comamnd support */

extern char *batch_params(char *s1, char *s2);

/* HBP_002 } */
