/*
 *  IF.C - if command.
 *
 *  Comments:
 *
 * 16 Jul 1998 (Hans B Pufal)
 *   started.
 *
 * 16 Jul 1998 (John P Price)
 *   Seperated commands into individual files.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 *
 */

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>

#include "command.h"
#include "batch.h"

int
cmd_if(char *cmd, char *param)
{
/*
 * Perform IF command.
 *
 */

#define X_EXEC 1
#define X_EMPTY 0x80

  int
    x_flag = 0;                 /* when set cuase 'then' clause to be executed */

  char
   *pp;

  dprintf(("CMD '%s' : '%s'\n", cmd, param));

  if (strcmp(param, "/?") == 0)
  {
    printf("%s :\n", cmd);
    return 0;
  }

  /* First check if param string begins with word 'not' */

  if ((strncmpi(param, "not", 3) == 0) && isspace(*(param + 3)))
  {
    x_flag = X_EXEC;            /* Remember 'NOT' */
    param += 3;                 /* Step over 'NOT' */
    while (isspace(*param))     /* And subsequent spaces */
      param++;
  }

  /* Check for 'exist' form */

  if ((strncmpi(param, "exist", 5) == 0) && isspace(*(param + 5)))
  {
    param += 5;
    while (isspace(*param))
      param++;

    pp = param;
    while (*pp && !isspace(*pp))
      pp++;

    if (*pp)
    {
      struct ffblk f;

      *pp++ = '\0';

      x_flag ^= findfirst(param, &f, FA_NORMAL) ? 0 : X_EXEC;
    }
    else
      return 0;
  }

  /* Check for 'errorlevel' form */

  else if ((strncmpi(param, "errorlevel", 10) == 0) && isspace(*(param + 10)))
  {
    int
      n = 0;

    pp = param + 10;
    while (isspace(*pp))
      pp++;

    while (isdigit(*pp))
      n = n * 10 + (*pp++ - '0');

    x_flag ^= (errorlevel < n) ? 0 : X_EXEC;

    x_flag |= X_EMPTY;          /* Syntax error if comd empty */
  }

  /* Check that '==' is present, syntax error if not */

  else if (NULL == (pp = strstr(param, "==")))
  {
    error_syntax(NULL);
    return 1;
  }

  else
  {
    /* Change first '='to space to terminate comparison loop */

    *pp = ' ';                  /* Need a space to terminate comparison loop */

    pp += 2;                    /* over '==' */

    while (isspace(*pp))        /* Skip subsequent spaces */
      pp++;

    strcat(pp, " ");            /* Add one space to ensure comparison ends */

    while (*param == *pp)       /* Comparison loop */
    {
      if (isspace(*param))      /* Terminates on space */
        break;

      param++, pp++;
    }

    if (x_flag ^= (*param != *pp) ? 0 : X_EXEC)
    {
      while (*pp && !isspace(*pp))  /* Find first space, */
        pp++;

      x_flag |= X_EMPTY;
    }
  }

  if (x_flag & X_EMPTY)
  {
    while (isspace(*pp))        /* Then skip spaces */
      pp++;

    if (*pp == '\0')            /* If nothing left then syntax err */
    {
      error_syntax(NULL);
      return 1;
    }
  }

  if (x_flag & X_EXEC)
    parsecommandline(pp);

  return 0;
}
