/***
*int13.h -  BIOS INT 13h definitions
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*

   Versions:

   1.0   28-Nov-1997    created

   Release Notes:

   To distinguish error numbers from the other DISK I/O functions
   (INT 25h/26h and IOCTL) an offest is added. This is done in
   DISKIO.C by use of a common error handler (returnerror()), not
   in the low level fucntions.

*/

#ifndef INT13_H
#define INT13_H

typedef enum {       /* this corresponds those similar in BIOS.H */
   BIOS_RESET,       /* (but typedef enums are nice inside a debugger) */
   BIOS_STATUS,
   BIOS_READ,
   BIOS_WRITE,
   BIOS_VERIFY,
   BIOS_FORMAT
} BIOS_FUNCTION;

typedef enum {
   BIOS_ERROR_OFFSET = 0x100,
   BIOS_ECHANGE = 0x106,            /* only these two are dealt with */
   BIOS_ETIMEOUT = 0x180
} BIOS_ERROR;

extern int int13(int cmd, int disk, int t, int s, int h, int n, char *buf);
extern int int13getparam(int disk, int *t, int *s, int *h);
extern const char *int13error(int error);

#endif
