/***
*limits.h - implementation dependent values
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Contains defines for a number of implementation dependent values
*   which are commonly used in C programs.
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/


#define SCHAR_MAX_DIG   4           /* maximum # decimal digits */
#define UCHAR_MAX_DIG   3           /* maximum unsigned char value */
#ifndef _CHAR_UNSIGNED
#define CHAR_MAX_DIG  SCHAR_MAX_DIG /* maximum char value */
#else
#define CHAR_MAX_DIG  UCHAR_MAX_DIG
#endif
#define SHRT_MAX_DIG    6           /* maximum (signed) short value */
#define USHRT_MAX_DIG   5           /* maximum unsigned short value */
#define INT_MAX_DIG     6           /* maximum (signed) int value */
#define UINT_MAX_DIG    5           /* maximum unsigned int value */
#define LONG_MAX_DIG    11          /* maximum (signed) long value */
#define ULONG_MAX_DIG   10          /* maximum unsigned long value */
