/*
 *  dos\edump.c     display DOS error information
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 *  23-Sep-1998 greggj  removed __GNUC__ stuff
 *
 */

#include <stdio.h>
#include <dos.h>

/*
 * err_dump     display DOS error information
 *
 */


#ifdef __WATCOMC__
#define _dosexterr  dosexterr
#endif
#ifdef __GNUC__
#define errclass class
#endif

extern void err_dump(const char *str)
{
struct _DOSERROR d;

    if (str)
        fprintf(stderr,"%s : ",str);
    _dosexterr(&d);
    fprintf(stderr,"error: %d, class: %d, action: %d, locus: %d\n",
            d.exterror,d.errclass,d.action,d.locus);
}
