/*
 *  win32\bios.c    INT 13h functions
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#include "win32.h"

static int adjdrv(int drv);

/*
 * disk_get_physical    get basic disk geometry (tracks, sectors, heads)
 *
 */

extern int disk_get_physical(int disk, int *t, int *s, int *h)
{
unsigned int tmp;
DIOC_REGISTERS regs DBG_0;

    regs.x.ax = 0x0800;
    regs.h.dl = (unsigned char)adjdrv(disk);

    if (win32_device_io(VWIN32_DIOC_DOS_INT13,&regs) == 0) {
        return 0;
    }

    if (regs.x.flags & 0x0001) {
        return (int)regs.h.al;
    }

    *h = regs.h.dh;
    *t = regs.h.ch;             /* low bits only */
    tmp = *s = regs.h.cl;       /* has high bits of track also */
    *s &= 0x3f;                 /* mask off track high bits */
    *t += (tmp >> 6) << 8;      /* shift and add track high bits */

    return 0;
}

/*
 * disk_read_p      read sector(s)
 *
 */

int diskioctl(DOS_FUNCTION cmd, int disk, int track, int sec,
              int head, void *buf);

extern int disk_read_p(int disk, unsigned trk, unsigned sec, unsigned head,
                       void *buf, int nsecs)
{
DIOC_REGISTERS regs DBG_0;

    // still testing
    //return diskioctl(1,disk,trk,sec,head,buf);

    regs.h.ah = 2;
    regs.h.al = (unsigned char)nsecs;
    regs.h.ch = (unsigned char)trk;
    regs.h.cl = (unsigned char)sec;
    if (disk > 1) {
        regs.h.cl += ((trk & 0x300) >> 2);
    }
    regs.h.dh = (unsigned char)head;
    regs.h.dl = (unsigned char)adjdrv(disk);

    regs.d.ebx = (DWORD)buf;

    DBG_reg_dump(&regs);

    if (win32_device_io(VWIN32_DIOC_DOS_INT13,&regs) == 0) {
        return 0;
    }

    DBG_reg_dump(&regs);

    if (regs.x.flags & 0x0001) {
        return regs.h.al;
    }

    return -1;
}

/*
 * disk_write_p     write sector(s)
 *
 */

extern int disk_write_p(int disk, unsigned trk, unsigned sec, unsigned head,
                        void *buf, int nsecs)
{
DIOC_REGISTERS regs;

    // still testing
    //return diskioctl(1,disk,trk,sec,head,buf);

    regs.h.ah = 3;
    regs.h.al = (unsigned char)nsecs;
    regs.h.ch = (unsigned char)trk;
    regs.h.cl = (unsigned char)sec;
    if (disk > 1) {
        regs.h.cl += ((trk & 0x300) >> 2);
    }
    regs.h.dh = (unsigned char)head;
    regs.h.dl = (unsigned char)adjdrv(disk);

    regs.d.ebx = (DWORD)buf;

    if (win32_device_io(VWIN32_DIOC_DOS_INT13,&regs) == 0) {
        return 0;
    }

    if (regs.x.flags & 0x0001) {
        return regs.h.al;
    }

    return -1;
}

/* floppys: 0 - 7Fh, hards: 80h - FFh */

static int adjdrv(int drv)
{
    if (drv > 1) {
        return drv + 0x80 - 2;
    }
    return drv;
}
