/*
 *	win32\read.c		absolute disk read
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#include "win32.h"
#include "dosio.h"

/*
 * disk_read		absolute disk read (INT 25h)
 *
 */

extern int disk_read(int disk, long sec, void *buf, unsigned int nsecs, int na)
{
DIOC_REGISTERS regs DBG_0;

	regs.d.eax = disk;
	regs.d.edx = sec;
	regs.d.ecx = nsecs;
	regs.d.ebx = (DWORD)buf;

	DBG_reg_dump(&regs);

	if (win32_device_io(VWIN32_DIOC_DOS_INT25,&regs) == 0) {
		return 0;
	}

	DBG_reg_dump(&regs);

	if (regs.x.flags & 0x0001) {
		return regs.h.al;
	}

	return -1;
}

/*
 * disk_read_ext	absolute disk read (INT 25h), > 32MB
 *
 */

extern int disk_read_ext(int disk, long sec, void *buf, unsigned int nsecs, int na)
{
DIOC_REGISTERS regs DBG_0;
struct DCB dcb DBG_0;

	dcb.sector = sec;
	dcb.number = (UINT16)nsecs;
	dcb.buffer = buf;
	regs.d.eax = disk;
	regs.d.ecx = 0xFFFF;
	regs.d.ebx = (DWORD)&dcb;

	DBG_reg_dump(&regs);

	if (win32_device_io(VWIN32_DIOC_DOS_INT25,&regs) == 0) {
		return 0;
	}

	DBG_reg_dump(&regs);

	if (regs.x.flags & 0x0001) {
		return regs.h.al;
	}

	return -1;
}
