/*
// Program:  Free FDISK
// Module:  CMD.C
// Module Description:  Command Line Switch Code Module
//                      All functions that process command line entry are
//                      here.
// Written By:  Brian E. Reifsnyder
// Version:  1.0 RC 1
// Copyright:  1998-2001 under the terms of the GNU GPL, Version 2
*/

/*
/////////////////////////////////////////////////////////////////////////////
//  DEFINES
/////////////////////////////////////////////////////////////////////////////
*/

#define CMD

/*
/////////////////////////////////////////////////////////////////////////////
//  INCLUDES
/////////////////////////////////////////////////////////////////////////////
*/

#include <conio.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cmd.h"
#include "fdiskio.h"
#include "main.h"
#include "pcompute.h"
#include "pdiskio.h"
#include "userint2.h"
#include "userint1.h"

/*
/////////////////////////////////////////////////////////////////////////////
//  PROTOTYPES
/////////////////////////////////////////////////////////////////////////////
*/

int Get_Options(char *arguments[],int number_of_arguments);

void Command_Line_Clear_Flag();
void Command_Line_Create_Extended_Partition();
void Command_Line_Create_Logical_DOS_Drive();
void Command_Line_Create_Primary_Partition();
void Command_Line_Delete();
void Command_Line_Info();
void Command_Line_Modify();
void Command_Line_Move();
void Command_Line_Set_Flag();
void Command_Line_Status();
void Command_Line_Swap();
void Command_Line_Test_Flag();
void Command_Line_X();
void Shift_Command_Line_Options(int number_of_places);

/*
/////////////////////////////////////////////////////////////////////////////
//  FUNCTIONS
/////////////////////////////////////////////////////////////////////////////
*/

/* /CLEARFLAG command line option */
void Command_Line_Clear_Flag()
{
  int option_count=1;

  if( (0==strcmp(arg[1].choice,"ALL")) && (arg[0].value!=0) )
    {
    printf("\nSyntax Error...Operation Terminated.\n");
    exit(1);
    }

  if(0==strcmp(arg[1].choice,"ALL"))
    {
    int index=1;

    option_count=2;

    do
      {
      Clear_Flag(index);

      index++;
      }while(index<=64);

    printf("\nAll flags have been cleared.\n");
    }
  else
    {
    Clear_Flag(arg[0].value);

    printf("\nFlag %d has been cleared.\n",arg[0].value);
    }

  Shift_Command_Line_Options(option_count);
}

/* /EXT command line options */
void Command_Line_Create_Extended_Partition()
{
  Determine_Free_Space();

  if(arg[0].extra_value==100)
    {
    /* Compute the partition size as a percentage. */

    arg[0].value=arg[0].value
     *((((part_table[(flags.drive_number-128)].pri_part_largest_free_space)
     *(part_table[(flags.drive_number-128)].total_head+1)
     *(part_table[(flags.drive_number-128)].total_sect))
     -part_table[(flags.drive_number-128)].total_sect)/2048)/100;
    }

  Create_Primary_Partition(5,arg[0].value);

  Shift_Command_Line_Options(1);
}

/* /LOG and /LOGO command line options */
void Command_Line_Create_Logical_DOS_Drive()
{
  int option_count=1;

  Determine_Free_Space();

  if(arg[0].extra_value==100)
    {
    /* Compute the partition size as a percentage. */

    arg[0].value=arg[0].value
     *((((part_table[(flags.drive_number-128)]
     .ext_part_largest_free_space+1)
     *(part_table[(flags.drive_number-128)].total_head+1)
     *(part_table[(flags.drive_number-128)].total_sect))/2048)/100);
    }

  if(0!=strcmp(arg[1].choice,"SPEC"))
    {
    /* If no special partition type is defined. */

    Create_Logical_Drive(
     Partition_Type_To_Create(arg[0].value),arg[0].value);
    }
  else
    {
    /* If a special partition type is defined. */
    option_count=2;

    Create_Logical_Drive(arg[1].value,arg[0].value);
    }

  Shift_Command_Line_Options(option_count);
}

/* /PRI and /PRIO command line options */
void Command_Line_Create_Primary_Partition()
{
  int option_count=1;

  Determine_Free_Space();

  if(arg[0].extra_value==100)
    {
    /* Compute the partition size as a percentage. */

    arg[0].value=arg[0].value
     *((((part_table[(flags.drive_number-128)].pri_part_largest_free_space)
     *(part_table[(flags.drive_number-128)].total_head+1)
     *(part_table[(flags.drive_number-128)].total_sect))
     -part_table[(flags.drive_number-128)].total_sect)/2048)/100;
    }

  if(0!=strcmp(arg[1].choice,"SPEC"))
    {
    /* If no special partition type is defined. */

    Set_Active_Partition(
     Create_Primary_Partition(
     Partition_Type_To_Create(arg[0].value),arg[0].value));
    }
  else
    {
    /* If a special partition type is defined. */
    option_count=2;

    Create_Primary_Partition(arg[1].value,arg[0].value);
    }

  Shift_Command_Line_Options(option_count);
}

/* /DELETE command line option */
void Command_Line_Delete()
{
  int error_found=TRUE;

  /* Delete the primary partition */
  if(0==strcmp(arg[1].choice,"PRI"))
    {
    int index=3;

    do
      {
      if( ( (flags.version==FOUR)
       || (flags.version==FIVE)
       || (flags.version==SIX) )
       && ( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==1)
       || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==4)
       || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==6) ) )
	{
	Delete_Primary_Partition(index);
	error_found=FALSE;
	break;
	}
      if( (flags.version==W95) &&
       (part_table[(flags.drive_number-128)].pri_part_num_type[index]==14) )
	{
	Delete_Primary_Partition(index);
	error_found=FALSE;
	break;
	}
      if( ( (flags.version==W95B) || (flags.version==W98) )
       && ( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==11)
       || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==12) ) )
	{
	Delete_Primary_Partition(index);
	error_found=FALSE;
	break;
	}

      index--;
      }while(index>=0);

    if(index<0)
      {
      printf("\nPrimary DOS Partition not found...no partition deleted.\n");
      exit(9);
      }
    }
  /* Delete the extended partition */
  if(0==strcmp(arg[1].choice,"EXT"))
    {
    int index=3;

    do
      {
      if( ( (flags.version==FOUR)
       || (flags.version==FIVE)
       || (flags.version==SIX) )
       && (part_table[(flags.drive_number-128)].pri_part_num_type[index]==5) )
	{
	Delete_Primary_Partition(index);
	error_found=FALSE;
	break;
	}
      if( ( (flags.version==W95)
       || (flags.version==W95B)
       || (flags.version==W98) )
       && ( (part_table[(flags.drive_number-128)].pri_part_num_type[index]==5)
       || (part_table[(flags.drive_number-128)].pri_part_num_type[index]==15) ) )
	{
	Delete_Primary_Partition(index);
	error_found=FALSE;
	break;
	}

      index--;
      }while(index>=0);

    if(index<0)
      {
      printf("\nExtended DOS Partition not found...no partition deleted.\n");
      exit(9);
      }
    }

  /* Delete a Logical DOS Drive */
  if(0==strcmp(arg[1].choice,"LOG"))
    {
    if( (arg[1].value>=1) && (arg[1].value<=24) )
      {
      Delete_Logical_Drive( (arg[1].value-1) );
      error_found=FALSE;
      }

    if(error_found==TRUE)
      {
      printf("\nLogical drive number is out of range...Operation Terminated\n");
      exit(9);
      }
    }

  /* Delete the partition by the number of the partition */
  if(0==strcmp(arg[1].choice,"NUM"))
    {
    if( (arg[1].value>=1) && (arg[1].value<=4) )
      {
      Delete_Primary_Partition( (arg[1].value-1) );
      error_found=FALSE;
      }

    if( (arg[1].value>=5) && (arg[1].value<=28) )
      {
      Delete_Logical_Drive( (arg[1].value-5) );
      error_found=FALSE;
      }

    if(error_found==TRUE)
      {
      printf("\nPartition number is out of range...Operation Terminated\n");
      exit(9);
      }
    }

  Shift_Command_Line_Options(2);
}

/* /INFO command line option */
void Command_Line_Info()
{
  int option_count=1;

  if(0==strcmp(arg[1].choice,"TECH"))
    {
    option_count=2;

    flags.extended_options_flag=TRUE;
    }

  Display_CL_Partition_Table();

  Shift_Command_Line_Options(option_count);
}

/* /MODIFY command line option */
void Command_Line_Modify()
{
  if((arg[0].value<1) || (arg[0].value>4))
    {
    printf("\nPrimary partition number is out of range...Operation Terminated.\n");
    exit(9);
    }

  if((arg[0].extra_value<=0) || (arg[0].extra_value>255))
    {
    printf("\nNew partition type is out of range...Operation Terminated.\n");
    exit(9);
    }

  Modify_Partition_Type((arg[0].value-1),arg[0].extra_value);

  Shift_Command_Line_Options(1);
}

/* /MOVE command line option */
void Command_Line_Move()
{
  if((arg[0].value<1) || (arg[0].value>4))
    {
    printf("\Source partition number is out of range...Operation Terminated.\n");
    exit(9);
    }

  if((arg[0].extra_value<1) || (arg[0].extra_value>4))
    {
    printf("\Destination partition number is out of range...Operation Terminated.\n");
    exit(9);
    }

  Primary_Partition_Slot_Transfer(MOVE,arg[0].value,arg[0].extra_value);

  Shift_Command_Line_Options(1);
}

/* /SETFLAG command line option */
void Command_Line_Set_Flag()
{
  if( (arg[0].value<1) || (arg[0].value>64) )
    {
    printf("\nInvalid flag number...Operation Terminated.\n");

    exit(9);
    }

  if(arg[0].extra_value==0) arg[0].extra_value=1;

  if( (arg[0].extra_value<1) || (arg[0].extra_value>64) )
    {
    printf("\nFlag value is out of range...Operation Terminated.\n");

    exit(9);
    }

  Set_Flag(arg[0].value,arg[0].extra_value);

  printf("\nFlag %d has been set to ",arg[0].value);
  printf("%d.\n",arg[0].extra_value);

  Shift_Command_Line_Options(1);
}

/* /STATUS command line option */
void Command_Line_Status()
{
  flags.monochrome=TRUE;
  textcolor(7);
  Clear_Screen(NULL);
  Print_Centered(1,"Fixed Disk Drive Status",0);
  Display_All_Drives();

  Shift_Command_Line_Options(1);
}

/* /SWAP command line option */
void Command_Line_Swap()
{
  if((arg[0].value<1) || (arg[0].value>4))
    {
    printf("\Source partition number is out of range...Operation Terminated.\n");
    exit(9);
    }

  if((arg[0].extra_value<1) || (arg[0].extra_value>4))
    {
    printf("\Destination partition number is out of range...Operation Terminated.\n");
    exit(9);
    }

  Primary_Partition_Slot_Transfer(SWAP,arg[0].value,arg[0].extra_value);

  Shift_Command_Line_Options(1);
}


/* /TESTFLAG command line option */
void Command_Line_Test_Flag()
{
  int flag;

  flag=Test_Flag(arg[0].value);

  if(arg[0].extra_value>0)
    {
    /* If testing for a particular value, return a true or false answer. */
    /* The error level returned will be 20 for false and 21 for true.    */

    if(flag==arg[0].extra_value)
      {
      printf("\nFlag %d is set to ",arg[0].value);
      printf("%d.\n",arg[0].extra_value);

      exit(21);
      }
    else
      {
      printf("\nFlag %d is not set to ",arg[0].value);
      printf("%d.\n",arg[0].extra_value);

      exit(20);
      }
    }
  else
    {
    /* If not testing the flag for a particular value, return the value */
    /* the flag is set to.  The error level returned will be the value  */
    /* of the flag + 30.                                                */

    printf("\nFlag %d is set to ",arg[0].value);
    printf("%d.\n",flag);

    exit( (30+flag) );
    }
}

/* /X command line option */
void Command_Line_X()
{
  int index;

  /* Ask the user if FAT32 is desired. */
  if( (flags.version==W95B) || (flags.version==W98) )
   Ask_User_About_FAT32_Support();

  flags.use_extended_int_13=FALSE;
  index=0;
  do
    {
    part_table[index].ext_int_13=FALSE;
    index++;
    }while(index<8);

  Read_Partition_Tables();
  Interactive_User_Interface();
}

/* Get the command line options */
int Get_Options(char *arguments[],int number_of_arguments)
{
  char value[6];
  char extra_value[3];

  int clearing_loop;
  int line_index;
  int loop;
  int number_of_options=number_of_arguments-1;
  int option_index=0;
  int skip=FALSE;
  int variable;
  int variable_index;

  int CHOICE=1;
  int VALUE=2;
  int EXTRA_VALUE=3;

  flags.drive_number=0x80;
  if(number_of_options==0) return(number_of_options);

  /* Limit the possible number of options to 20 to prevent an overflow of */
  /* the arg[] structure.                                                 */
  if(number_of_options>20) number_of_options=20;

  loop=1;
  do
    {
    /* Clear value[6] and extra_value[3] */
    clearing_loop=0;
    do
      {
      value[clearing_loop]=0;
      if(clearing_loop<3) extra_value[clearing_loop]=0;
      clearing_loop++;
      }while(clearing_loop<6);

    if(1==strlen(arguments[loop]))
      {
      flags.drive_number=((arguments[loop] [0])-48)+127;
      number_of_options--;
      option_index--;
      skip=TRUE;
      }

    if(skip==FALSE)
      {
      line_index=1;
      variable=CHOICE;
      variable_index=0;
      do
	{
	if( (variable==CHOICE) && (arguments[loop][line_index]!=':')
	 && (variable_index<10) )
	  {
	  arg[option_index].choice[variable_index]=arguments[loop][line_index];
	  arg[option_index].choice[variable_index]
	   =toupper(arg[option_index].choice[variable_index]);
	  }

	if( (variable==CHOICE) && (arguments[loop][line_index]==':') )
	  {
	  variable=VALUE;
	  variable_index=0;
	  line_index++;
	  }

	if( (variable==VALUE) && (arguments[loop][line_index]!=',') )
	  {
	  if( (variable_index<6) && ( (arguments[loop][line_index]>='0')
	   && (arguments[loop][line_index]<='9') ) )
	    {
	    value[variable_index]=arguments[loop][line_index];
	    }
	  }

	if( (variable==VALUE) && (arguments[loop][line_index]==',') )
	  {
	  variable=EXTRA_VALUE;
	  variable_index=0;
	  line_index++;
	  }

	if(variable==EXTRA_VALUE)
	  {
	  if( (variable_index<3) && ( (arguments[loop][line_index]>='0')
	   && (arguments[loop][line_index]<='9') ) )
	    {
	    extra_value[variable_index]=arguments[loop][line_index];
	    }
	  }

	variable_index++;
	line_index++;
	}while(line_index<strlen(arguments[loop]));
      }

    if( (value!=NULL) && (skip==FALSE) )arg[option_index].value=atol(value);

    if( (extra_value!=NULL) && (skip==FALSE) )
     arg[option_index].extra_value=atoi(extra_value);

    skip=FALSE;
    option_index++;
    loop++;
    }while(loop<=number_of_options);

//  if(number_of_options>=2) number_of_options--;
//  The above line may not be needed...BER

  /* check to make sure the drive is a legitimate number */
  if( (flags.drive_number<0x80) || (flags.drive_number>flags.maximum_drive_number) )
    {
    printf("\nInvalid drive designation...Operation Terminated.\n");
    exit(5);
    }

  return(number_of_options);
}

void Shift_Command_Line_Options(int number_of_places)
{
  int index;

  do
    {
    index=0;

    do
      {
      strcpy(arg[index].choice,arg[(index+1)].choice);
      arg[index].value=arg[(index+1)].value;
      arg[index].extra_value=arg[(index+1)].extra_value;

      index++;
      }while(index<19);

    number_of_command_line_options--;
    number_of_places--;
    }while(number_of_places>0);
}