/****************************************************************/
/*                                                              */
/*                            prf.c                             */
/*                                                              */
/*                  Abbreviated printf Function                 */
/*                                                              */
/*                      Copyright (c) 1995                      */
/*                      Pasquale J. Villani                     */
/*                      All Rights Reserved                     */
/*                                                              */
/* This file is part of DOS-C.                                  */
/*                                                              */
/* DOS-C is free software; you can redistribute it and/or       */
/* modify it under the terms of the GNU General Public License  */
/* as published by the Free Software Foundation; either version */
/* 2, or (at your option) any later version.                    */
/*                                                              */
/* DOS-C is distributed in the hope that it will be useful, but */
/* WITHOUT ANY WARRANTY; without even the implied warranty of   */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See    */
/* the GNU General Public License for more details.             */
/*                                                              */
/* You should have received a copy of the GNU General Public    */
/* License along with DOS-C; see the file COPYING.  If not,     */
/* write to the Free Software Foundation, 675 Mass Ave,         */
/* Cambridge, MA 02139, USA.                                    */
/****************************************************************/

#include "portab.h"

COUNT ASMCFUNC fstrlen (BYTE FAR * s);        /* don't want globals.h, sorry */

static BYTE *charp = 0;

static VOID handle_char(COUNT);
VOID put_console(COUNT);
BYTE *ltob(LONG, BYTE *, COUNT);
COUNT do_printf(CONST BYTE *, REG BYTE **);

/* special handler to switch between sprintf and printf */
static VOID
  handle_char(COUNT c)
{
  if (charp == 0)
    put_console(c);
  else
    *charp++ = c;
}

/* ltob -- convert an long integer to a string in any base (2-16) */
BYTE *
  ltob(LONG n, BYTE * s, COUNT base)
{
  ULONG u;
  BYTE *p;

    u = n;

  if (base == -10)              /* signals signed conversion */
  	{
    base = 10;
	if (n < 0 ) {
    	u = -n;
    	*s++ = '-';
	}
  }
  	
  p = s+10;
  *p-- = '\0';
  do {                             /* generate digits in reverse order */
  	static char hexDigits[] = "0123456789abcdef";
  
    *p-- = hexDigits[(UWORD)(u % base)];
  } while ((u /= base) > 0);

  p++;
  return p;
}


#define LEFT    0
#define RIGHT   1

/* printf -- short version of printf to conserve space */
WORD printf(CONST BYTE * fmt, ...)
{
  charp = 0;
  return do_printf(fmt, (BYTE **)&fmt + 1);
}

WORD sprintf(BYTE * buff, CONST BYTE * fmt, ...)
{
  WORD ret;

  charp = buff;
  ret = do_printf(fmt, (BYTE **)&fmt + 1);
  *charp = '\0';
  return ret;
}
/*
ULONG FAR retcs(int i)
{
    char *p = (char*)&i;
    
    p -= 4;
    return *(ULONG *)p;
}
*/
COUNT do_printf(CONST BYTE * fmt, BYTE ** arg)
{
  int base;
  BYTE s[11];
  unsigned char far * p;
  int c,
    flag,
    size,
    fill;
  int longarg;  
  long currentArg;
  
  while ((c = *fmt++) != '\0')
  {
    if (c != '%')
    {
      handle_char(c);
      continue;
    }

	longarg = FALSE;
  	size = 0;
    flag = RIGHT;
    fill = ' ';

    if ( *fmt == '-')
    {
      flag = LEFT;
      fmt++;
    }
    
    if ( *fmt == '0')
    {
      fill = '0';
      fmt++;
    }

	while (*fmt >= '0' && *fmt <= '9')
	{
      size = size * 10 + (*fmt++ - '0');
	}

    

    if (*fmt == 'l')
    {
    	longarg = TRUE;
    	fmt++;
    }

    
    c = *fmt++;
    switch (c)
    {
      case '\0': 
      		return 0;
      	
      case 'c':
	        handle_char(*(COUNT *) arg++);
    	    continue;
#if 0
      case 'p':
            {
            WORD w[2];
            static char pointerFormat[] = "%04x:%04x";
            w[1] = *((unsigned int*) arg)++;
            w[0] = *((unsigned int*) arg)++;
            do_printf(pointerFormat,(BYTE**)&w);
    	    continue;
    	    }
#endif
      case 's':
            p = (unsigned char far *)*(arg)++;
            goto do_outputstring;
            
      case 'F':
            /* we assume %Fs here */
            fmt++;
            p = (unsigned char far *)MK_FP(*(arg+1),*arg);
            arg = arg+2;
            goto do_outputstring;
      case 'S':
            p = (unsigned char far *)*(arg)++;
            goto do_outputstring;

      case 'i':
      case 'd':
            base = -10;
            goto lprt;

      case 'o':
            base = 8;
            goto lprt;

      case 'u':
            base = 10;
            goto lprt;

      case 'X':
      case 'x':
            base = 16;

        lprt:
            if (longarg) {
          		currentArg = *(LONG*)arg;arg=arg+2;
            } else
                if (base < 0)
                    currentArg = *(int*)arg++;
                else
                    currentArg = *(unsigned int*)arg++;
          			
            p = (unsigned char far *)ltob(currentArg, s, base);

do_outputstring:
            
            size  -= fstrlen((char far *)p);
            
            if (flag == RIGHT )
            {
              for ( ; size > 0; size--)
                handle_char(fill);
            }
            for (; *p != '\0'; p++)
              handle_char(*p);

            for ( ; size > 0; size--)
                handle_char(fill);
                
            continue;

          default:
/*            handle_char('?'); */
          
            handle_char(c);
            break;


    }
  }
  return 0;
}

