#ifndef CURS_KEY_H
#define CURS_KEY_H

/* This is a small ASCII-only subset of the curses KEY_ macros */

#define KEY_BACKSPACE '\b'        /* \b (^H) Backspace */
#define KEY_DC        '\177'      /* \177 Delete character */

#define KEY_SF        '\016'      /* ^N Scroll 1 line forward */
#define KEY_SR        '\020'      /* ^P Scroll 1 line backward (reverse) */
#define KEY_LEFT      '\002'      /* ^B (a UNIX hack) */
#define KEY_RIGHT     '\006'      /* ^F (a UNIX hack) */

#define KEY_ENTER     '\r'        /* \r (CR) Enter or send */
#define KEY_CANCEL    '\033'      /* \033 (ESC) Cancel key */
#define KEY_BREAK     '\003'      /* ^C Break key */

#define KEY_BEG       '\001'      /* ^A Beg(inning) key */
#define KEY_END       '\005'      /* ^E End key */

#define KEY_EXIT      '\032'      /* ^Z Exit key */
#define KEY_REFRESH   '\f'        /* \f (^L) Refresh key */

#define KEY_SUSPEND   '\023'      /* ^S Suspend key */
#define KEY_RESUME    '\030'      /* ^X Resume key */

#endif /* CURS_KEY_H */
