#ifdef unix
#include <curses.h>
#else
#include "thecurse.h"
#endif

/* this is a test program, which does very little except run through
   some basic curses routines.  use this as a portability experiment
   between curses/UNIX and dcurses/DOS. */

int
main ()
{
  int key;					/* the key to press */

  /* start curses */

  initscr();

#ifdef unix
  cbreak();
  noecho();
#endif

  /* Most programs would additionally use the sequence: */

#ifdef unix
  nonl();
  intrflush(stdscr, FALSE);
  keypad(stdscr, TRUE);
#endif

  /* erase the screen, and print a message */

  erase();
  standout();
  mvaddstr (0, 30, "press a key, Q to quit");
  standend();
  refresh();

  /* Enter a loop */

  do {
    /* get a key */

    key = getch();

    /* print the key */

    move (5, 10);
    clrtoeol ();

    switch (key) {
    case KEY_BACKSPACE:
      addstr ("backspace");
      break;
    case KEY_DC:
      addstr ("del");
      break;
    case KEY_SF:
      addstr ("scroll fwd");
      break;
    case KEY_SR:
      addstr ("scroll rev");
      break;
    case KEY_ENTER:
      addstr ("enter");
      break;
    case KEY_CANCEL:
      addstr ("cancel");
      break;
    case KEY_BREAK:
      addstr ("break");
      break;
    case KEY_BEG:
      addstr ("beginning");
      break;
    case KEY_END:
      addstr ("end");
      break;
    case KEY_EXIT:
      addstr ("exit");
      break;
    case KEY_REFRESH:
      addstr ("refresh");
      break;
    case KEY_SUSPEND:
      addstr ("suspend");
      break;
    case KEY_RESUME:
      addstr ("resume");
      break;
    case ' ':
      addstr ("Space");
      break;
    default:
      addch (key);
      break;
    } /* switch */
  } while ((key != 'q') && (key != 'Q'));

  /* exit curses */

  erase();
  refresh();

  endwin();

  /* end the program */

  exit (0);
}
