/* $Id: cat.c,v 1.2 1998/06/12 04:31:14 jhall Exp $ */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>

int
cat (const char *filename)
{
  /* Concatenate a file to stdout.  Returns non-zero (true) if
     successful, or zero (false) if failed. */

  FILE *stream;
  int ch;

  /* Open the file */

  if ((stream = fopen (filename, "r")) == NULL) {
    /* Failed to open */

    return (0);
  }

  /* Now concatenate the file to stdout */

  while ((ch = fgetc (stream)) != EOF) {
    putchar(ch);
  }

  /* Done.  Close the file and return */

  fclose (stream);
  return (1);
}
