/* $Id: getsmatch.c,v 1.2 1998/06/12 04:31:16 jhall Exp $ */

/* A function to get a string from a file, if it compares with the
   match.  For the FreeDOS Install program, getting the name of a
   program from a list that shows usage.  Returns the string, or NULL
   if none found. */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>
#include "basecmp.h"

#define STRLEN 80

char *
getsmatch (const char *filename, const char *match)
{
  static char s[STRLEN];
  char *ptr = s;
  FILE *pfile;

  /* Open the file */

  pfile = fopen (filename, "r");
  if (!pfile) {
    /* Failed */

    return ((char *) NULL);
  }

  /* Now read in strings until end of file.  after reading a string,
     compare it against the match.  If they compare ok, then return
     the string. */

  while (fgets (s, STRLEN, pfile) != (char *) NULL) {
    if (basecmp (match, s) == 0) {
      /* The strings match ok. */

      fclose (pfile);
      return (ptr);
    }
  } /* while */

  /* We failed to successfully compare the string.  Close the file and
     return an error. */

  fclose (pfile);
  return ((char *) NULL);
}

#if defined (TEST)

int
main(int argc, char **argv)
{
  char *str;

  /* Check command line */

  if (argc != 3) {
    /* Wrong command line. */

    fprintf (stderr, "%s - tests the getsmatch function\n", argv[0]);
    fprintf (stderr, "Usage: %s file progname\n", argv[0]);
    exit (1);
  }

  /* Do the match */

  str = getsmatch (argv[1], argv[2]);

  if (str) {
    printf ("match: %s\n", str);
  }

  else {
    printf ("No match found\n");
  }

  exit (0);
}
#endif /* TEST */
