/* $Id: diskname.c,v 1.3 1998/08/18 02:55:21 jhall Exp $ */

/* diskname.c - Constructs a disk name, for use in describing a
   portion of the install series. */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>
#include "fs.h"

#define STRLEN 80

char *
diskname (const char *path, const char *base, int n)
{
  /* Construct a name from the base name, and the number 'n' in the
     series. */

  static char ret[STRLEN];

  sprintf (ret, "%s%c%s.%d", path, FS_DIR_SEP, base, n);
  return (ret);
}
