/* install.c */

/* Copyright (C) 1998-1999 Jim Hall <jhall1@isd.net> */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>			/* for malloc */

#ifdef unix
#include "conio.h"
#else
#include <conio.h>
#endif

#include "cat.h"			/* for cat_file */
#include "dat.h"			/* for dat_read */
#include "getch_yn.h"			/* for getch_yn */
#include "inst.h"			/* for inst_t */
#include "repaint.h"


#define MAXLEN 80

#define DAT_FILE "install.dat"		/* top-level dat file */
#define OEM_FILE "oem.txt"		/* text file for vendors */


void usage (void);
inst_t install_top (dat_t *dat_ary, int dat_count);


int
main (int argc, char **argv)
{
  inst_t ret;				/* no. of errors, warnings */

  dat_t *dat_ary;			/* the dat file array */
  int dat_size = 30;			/* malloc size of the dat array */
  int dat_count;			/* size of the dat array */

#ifndef unix
  struct text_info ti;			/* (borland) for gettextinfo */
#endif

  /* Check command line */

  if (argc != 1)
    {
      usage ();
      exit (1);
    }

  /* Read dat file */

  dat_ary = malloc (sizeof (dat_t) * dat_size);
  if (dat_ary == NULL)
    {
      fprintf (stderr, "Error!\n");
      fprintf (stderr, "Unable to allocate memory for install data file!\n");
      fprintf (stderr, "The file was %s\n", DAT_FILE);
      exit (2);
    }

  dat_count = dat_read (DAT_FILE, dat_ary, dat_size);
  if (dat_count < 1)
    {
      fprintf (stderr, "Error!\n");
      fprintf (stderr, "The install data file is empty!\n");
      fprintf (stderr, "The file was %s\n", DAT_FILE);
      free (dat_ary);
      exit (3);
    }

  /* Say hello */

#ifdef unix
  conio_init();
#endif

#ifndef unix
  gettextinfo (&ti);

  textbackground (BLUE);
  textcolor (WHITE);
#endif

  repaint_empty();

  gotoxy (1, 5);
  cputs ("Install version 3.1, Copyright (C) 1998-1999 Jim Hall");
  gotoxy (1, 6);
  cputs ("Install comes with ABSOLUTELY NO WARRANTY");
  gotoxy (1, 7);
  cputs ("This is free software, and you are welcome to redistribute it");
  gotoxy (1, 8);
  cputs ("under certain conditions; see the file COPYING for details.");

  /* show the OEM file */

  cat_file (OEM_FILE, 10 /* start line */, 10 /* no. lines */);

  gotoxy (1, 25);
  cputs ("Press any key to continue");
  getch();

  /* Start the install */

  ret.errors = 0;
  ret.warnings = 0;
  ret = install_top (dat_ary, dat_count);

  /* say goodbye */

#ifndef unix
  textattr (ti.attribute);
#endif

  /* Clear the screen */
  clrscr();

#ifdef unix
  conio_end();
#endif

  free (dat_ary);

  /* Print results */

  if ((ret.errors == 0) && (ret.warnings == 0))
    {
      printf ("The Install program completed successfully.\n");
    }

  else
    {
      printf ("There were %u errors and %u non-fatal warnings.\n",
	      ret.errors, ret.warnings);
    }

  exit (0);
}

void
usage (void)
{
  fprintf (stderr, "usage: for the Install program:\n");
  fprintf (stderr, "     install\n\n");
}

inst_t
install_top (dat_t *dat_ary, int dat_count)
{
  /* Top-level piece for the install program.  Determines what disk
     sets the user wants to install, then installs them. */

  inst_t ret;				/* return: no. of errors,warnings */
  inst_t this;				/* no. of errors,warnings */
  char txtfile[MAXLEN];			/* name of text descr file */
  char fromdir[MAXLEN];			/* path to install from */
  char destdir[MAXLEN];			/* path to install to */
  int ch;
  int i;

  /* Say hello */

  repaint_empty();
  gotoxy (1, 3);
  cputs ("In top-level install");

  /* Where to install from, to */

  fromdir[0] = 70;
  destdir[0] = 70;

  gotoxy (5, 10);
  cputs ("Where are the install files? (where to install from?)");

  gotoxy (5, 12);
  cgets (fromdir);

  gotoxy (5, 16);
  cputs ("Where will files be installed? (where to install to?)");
      
  gotoxy (5, 18);
  cgets (destdir);

  gotoxy (1, 25);
  cputs ("Press any key to continue");
  getch();

  /* Ask to install every disk set */

  for (i = 0; i < dat_count; i++)
    {
      repaint_empty();
      gotoxy (1, 5);
      cputs ("Disk set: ");
      cputs (dat_ary[i].name);

      sprintf (txtfile, "%s.TXT", dat_ary[i].name);
      cat_file (txtfile, 10 /* start line */, 10 /* no. lines */);

      gotoxy (1, 6);
      switch (dat_ary[i].rank)
	{
	case 'Y':
	case 'y':
	  cputs ("REQUIRED");

	  gotoxy (1, 25);
	  cputs ("Press any key to continue");
	  getch();
	  break;

	case 'N':
	case 'n':
	  cputs ("SKIPPED");
	  /* don't need to pause for this */
	  break;

	default:
	  cputs ("OPTIONAL");

	  gotoxy (1, 25);
	  cputs ("Do you want to install this disk set? [yn] ");
	  ch = getch_yn();

	  switch (ch)
	    {
	    case 'Y':
	    case 'y':
	      dat_ary[i].rank = 'y';
	      cputs ("yes");
	      break;

	    default:
	      dat_ary[i].rank = 'n';
	      cputs ("no");
	      break;
	    } /* switch ch */
	  break;
	} /* switch rank */
    } /* for i */

  /* Now install the selected disk sets */

  ret.errors = 0;
  ret.warnings = 0;

  for (i = 0; i < dat_count; i++)
    {
      switch (dat_ary[i].rank)
	{
	case 'Y':
	case 'y':
	  this = set_install (dat_ary[i].name, &fromdir[2], &destdir[2]);
	  ret.errors += this.errors;
	  ret.warnings += this.warnings;
	  break;
	} /* switch */
    } /* for i */

  /* Done */

  return (ret);
}
