/* these things are imported from the resident part */

#ifndef RESIDENT
    #define RESIDENT far
#endif

typedef unsigned long ulong;
typedef unsigned int  uint;
typedef unsigned short ushort;
typedef unsigned char uchar;

extern uchar RESIDENT ResidentScancodetable[1];
extern uint  RESIDENT ResidentCombiTables[5];
extern uint  RESIDENT ResidentE0table;
extern uchar RESIDENT DecimalDingsBums; /* grey , or . */

extern uchar RESIDENT usebiosonly_flag;



extern void (interrupt far * RESIDENT OldInt15)();
extern void (interrupt far * RESIDENT OldInt2F)();

extern void interrupt RESIDENT int15_handler();
extern void interrupt RESIDENT int2f_handler();




/* magic constants in keycode table */
#define NORMAL      0x01        /* normal keys define 3 characters */
#define ALTGREY     0x02        /* altgrey+key generates a different one */
#define REPLACESCAN 0x04        /* simply swap scancode (german Z <-->Y) */

#define CAPS 0x80               /* key uses caps lock */

#define ALLSIZEFLAGS     (NORMAL|ALTGREY|REPLACESCAN)
#define ALLPOSSIBLEFLAGS (NORMAL|ALTGREY|REPLACESCAN|CAPS)


#define IGNORE 0x00
#define COMBI1 1
#define COMBI2 2
#define COMBI3 3
#define COMBI4 4
#define COMBI5 5

#define LENGTH(x) (sizeof(x)/sizeof(x[0]))
